package com.tencent.start.cgs.tools;

import java.io.File;

import static com.tencent.start.cgs.tools.App.*;
import static com.tencent.start.cgs.tools.ZpkFile.*;

public class ZpkFileUnpack {

    public static void printUsage() {
        System.out.println("  java -jar gamepack.jar zpk unpack -o output_dir [-i <zpkfile>]/<zpkfile>");
    }

    public static void usage() {
        System.out.println("Usage:");
        printUsage();
        System.exit(1);
    }

    public static void callMain(String[] args) throws Exception {
        int i = 1;
        String arg;
        String inputFile = null;
        String outputFile = null;
        while (i < args.length) {
            switch (arg = args[i++]) {
                case "-i":
                    inputFile = args[i++];
                    break;
                case "-o":
                    outputFile = args[i++];
                    break;
                default:
                    inputFile = arg;
                    break;
            }
        }
        if (App.isTextEmpty(inputFile)) {
            usage();
            return;
        } else if (App.isTextEmpty(outputFile)) {
            outputFile = new File(".").getAbsolutePath();
        }
        try (ZpkFile zpkFile = ZpkFile.open(inputFile)) {
            System.out.println("Output directory: " + outputFile);
            final long startTime = System.currentTimeMillis();
            final long totalSize = zpkFile.version(getZpkTimestamp(inputFile)).reader().dump(new File(outputFile));
            final long cost = System.currentTimeMillis() - startTime;
            System.out.println("Done! ");
            System.out.println("Size: " + humanReadableBytes(totalSize) + ". "
                    + "Speed: " + humanReadableBytes(1000.0 * totalSize / cost) + "/s" + ". "
                    + "Cost: " + humanReadableTime(cost));
            System.out.println();
        }
        System.exit(0);
    }
}
