/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.defaultsources.PropertyDefaultSource;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDefaults
extends TestCase {
    private JSAP jsap = null;

    public static Test suite() {
        return new TestSuite(TestDefaults.class);
    }

    public void testConfig() {
        Switch switch_ = (Switch)this.jsap.getByID("b");
        TestDefaults.assertNotNull((Object)switch_);
        Switch switch_2 = (Switch)this.jsap.getByShortFlag('b');
        TestDefaults.assertNotNull((Object)switch_2);
        TestDefaults.assertEquals((Object)switch_, (Object)switch_2);
    }

    public void testSimpleDefault() {
        TestDefaults.assertNotNull((Object)this.jsap);
        String[] stringArray = new String[]{"-a", "2a 2b 2c"};
        JSAPResult jSAPResult = null;
        jSAPResult = this.jsap.parse(stringArray);
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.getBoolean("a"));
        TestDefaults.assertEquals((String)"field1-default", (String)jSAPResult.getString("field1"));
        TestDefaults.assertEquals((boolean)false, (boolean)jSAPResult.getBoolean("b"));
        try {
            String string = jSAPResult.getString("a");
            TestDefaults.fail((String)("Switch returned a String [" + string + "]"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefaults2() {
        TestDefaults.assertNotNull((Object)this.jsap);
        String[] stringArray = new String[]{"-b", "--field1", "HELLO"};
        JSAPResult jSAPResult = null;
        jSAPResult = this.jsap.parse(stringArray);
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
        TestDefaults.assertEquals((boolean)false, (boolean)jSAPResult.getBoolean("a"));
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.getBoolean("b"));
        TestDefaults.assertEquals((String)"HELLO", (String)jSAPResult.getString("field1"));
        TestDefaults.assertEquals((int)0, (int)jSAPResult.getObjectArray("field2").length);
    }

    public void testRequired() {
        FlaggedOption flaggedOption = new FlaggedOption("required");
        flaggedOption.setRequired(true);
        flaggedOption.setLongFlag("required");
        try {
            this.jsap.registerParameter(flaggedOption);
        }
        catch (Exception exception) {
            TestDefaults.fail((String)exception.getMessage());
        }
        String[] stringArray = new String[]{"-b", "--field1", "HELLO"};
        JSAPResult jSAPResult = null;
        jSAPResult = this.jsap.parse(stringArray);
        TestDefaults.assertEquals((String)"Required field not provided, but no exception thrown.", (boolean)false, (boolean)jSAPResult.success());
        String[] stringArray2 = new String[]{"-b", "--field1", "HELLO", "--required", "requiredinfo"};
        jSAPResult = this.jsap.parse(stringArray2);
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
        TestDefaults.assertNotNull((Object)jSAPResult);
        TestDefaults.assertEquals((boolean)false, (boolean)jSAPResult.getBoolean("a"));
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.getBoolean("b"));
        TestDefaults.assertEquals((String)"HELLO", (String)jSAPResult.getString("field1"));
        TestDefaults.assertEquals((int)0, (int)jSAPResult.getObjectArray("field2").length);
        TestDefaults.assertEquals((String)"requiredinfo", (String)jSAPResult.getString("required"));
        this.jsap.unregisterParameter(flaggedOption);
        flaggedOption.setDefault("required_default");
        try {
            this.jsap.registerParameter(flaggedOption);
        }
        catch (JSAPException jSAPException) {
            TestDefaults.fail((String)jSAPException.getMessage());
        }
        jSAPResult = null;
        jSAPResult = this.jsap.parse(stringArray);
        TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
        TestDefaults.assertEquals((String)"required_default", (String)jSAPResult.getString("required"));
    }

    public void testOneLevelDefaults() {
        try {
            File file = File.createTempFile("jsap-", ".properties");
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            Properties properties = new Properties();
            properties.setProperty("field1", "FromPropertyFile");
            properties.setProperty("a", "true");
            properties.store(bufferedOutputStream, "JUnit test for " + ((Object)((Object)this)).getClass().getName());
            ((OutputStream)bufferedOutputStream).close();
            PropertyDefaultSource propertyDefaultSource = new PropertyDefaultSource(file.getAbsolutePath(), true);
            this.jsap.registerDefaultSource(propertyDefaultSource);
            JSAPResult jSAPResult = null;
            String[] stringArray = new String[]{"-b", "--field1", "HELLO"};
            jSAPResult = this.jsap.parse(stringArray);
            TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
            TestDefaults.assertNotNull((Object)jSAPResult);
            TestDefaults.assertEquals((String)"HELLO", (String)jSAPResult.getString("field1"));
            String[] stringArray2 = new String[]{"-b"};
            jSAPResult = this.jsap.parse(stringArray2);
            TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.success());
            TestDefaults.assertNotNull((Object)jSAPResult);
            TestDefaults.assertEquals((String)"FromPropertyFile", (String)jSAPResult.getString("field1"));
            TestDefaults.assertEquals((boolean)true, (boolean)jSAPResult.getBoolean("a"));
        }
        catch (IOException iOException) {
            TestDefaults.fail((String)iOException.getMessage());
        }
    }

    public void setUp() throws JSAPException {
        this.jsap = new JSAP();
        Switch switch_ = new Switch("a");
        switch_.setShortFlag('a');
        this.jsap.registerParameter(switch_);
        Switch switch_2 = new Switch("b");
        switch_2.setShortFlag('b');
        this.jsap.registerParameter(switch_2);
        FlaggedOption flaggedOption = new FlaggedOption("field1");
        flaggedOption.setLongFlag("field1");
        flaggedOption.setDefault("field1-default");
        this.jsap.registerParameter(flaggedOption);
        UnflaggedOption unflaggedOption = new UnflaggedOption("field2");
        unflaggedOption.setGreedy(true);
        this.jsap.registerParameter(unflaggedOption);
    }

    public void tearDown() {
        this.jsap = null;
    }
}

