/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Switch;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSwitch
extends TestCase {
    public TestSwitch(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(TestSwitch.class);
    }

    public void testID() {
        Switch switch_ = new Switch("mySwitch");
        TestSwitch.assertEquals((String)"mySwitch", (String)switch_.getID());
    }

    public void testShortFlag() {
        Switch switch_ = new Switch("mySwitch");
        switch_.setShortFlag('c');
        TestSwitch.assertEquals((char)'c', (char)switch_.getShortFlag());
        TestSwitch.assertEquals((Object)new Character('c'), (Object)switch_.getShortFlagCharacter());
    }

    public void testLongFlag() {
        Switch switch_ = new Switch("mySwitch");
        switch_.setLongFlag("thisIsMyLongFlag");
        TestSwitch.assertEquals((String)"thisIsMyLongFlag", (String)switch_.getLongFlag());
    }

    private void ensureTrueList(List list) {
        TestSwitch.assertNotNull((Object)list);
        TestSwitch.assertEquals((int)1, (int)list.size());
        TestSwitch.assertEquals(list.get(0), (Object)new Boolean(true));
    }

    private void ensureFalseList(List list) {
        TestSwitch.assertNotNull((Object)list);
        TestSwitch.assertEquals((int)1, (int)list.size());
        TestSwitch.assertEquals(list.get(0), (Object)new Boolean(false));
    }

    public void testSwitchParse() {
        try {
            Switch switch_ = new Switch("mySwitch");
            this.ensureTrueList(switch_.parse(null));
            this.ensureTrueList(switch_.parse("true"));
            this.ensureFalseList(switch_.parse("false"));
        }
        catch (JSAPException jSAPException) {
            TestSwitch.fail((String)jSAPException.getMessage());
        }
    }
}

