/*
 * Decompiled with CFR 0.152.
 */
package es.xism4.software;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.zip.DataFormatException;
import net.md_5.bungee.util.BufUtil;
import net.md_5.bungee.util.QuietException;
import net.shieldcommunity.nullcordx.config.ConfigSettings;

public final class ExploitExceptionHandler {
    private static final QuietException CACHED_INVALID_PROTOCOL_EXCEPTION = ExploitExceptionHandler.createQuietException("Invalid protocol requested");
    private static final QuietException CACHED_EMPTY_USERNAME_EXCEPTION = ExploitExceptionHandler.createQuietException("Empty username? Or malicious UTF-8 data?");
    private static final QuietException CACHED_UNEXPECTED_LOGIN_PACKET = ExploitExceptionHandler.createQuietException("Null username? Or unsupported name");
    private static final QuietException CACHED_NULL_USERNAME_EXCEPTION = ExploitExceptionHandler.createQuietException("Invalid packet received during login process");
    private static final QuietException CACHED_BIG_PAYLOAD_EXCEPTION = ExploitExceptionHandler.createQuietException("Payload may not be larger than 1048576 bytes");
    private static final QuietException CACHED_BAD_FRAME_LENGTH = ExploitExceptionHandler.createQuietException("length wider than 21-bit");
    private static final QuietException CACHED_DISCARD = ExploitExceptionHandler.createQuietException("Discard handler is added to the pipeline");
    private static final QuietException CACHED_BIG_UNFRAMED_PACKET = ExploitExceptionHandler.createQuietException("Length is bigger than 16 MiB limit");
    private static final QuietException CACHED_NO_SESSION_EXCEPTION_EXCEPTION = ExploitExceptionHandler.createQuietException("No Session!");
    private static final QuietException CACHED_INVALID_DATA_EXCEPTION = ExploitExceptionHandler.createQuietException("Invalid data request packet");
    private static final QuietException CACHED_BIG_SERVER_COMPRESSED_PACKET_EXCEPTION = ExploitExceptionHandler.createQuietException("The server sent a very large (over 2MiB compressed) packet");
    private static final QuietException CACHED_QUERY_HANDLER_EXCEPTION = ExploitExceptionHandler.createQuietException("Error whilst handling query packet");

    public static void throwInvalidQueryException(ChannelHandlerContext ctx, Throwable cause) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new IllegalStateException("Error whilst handling query packet from " + ctx.channel().remoteAddress() + ": " + cause.getMessage());
        }
        throw CACHED_QUERY_HANDLER_EXCEPTION;
    }

    public static void throwInvalidProtocolException(int protocol) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new IllegalStateException("Cannot request protocol " + protocol);
        }
        throw CACHED_INVALID_PROTOCOL_EXCEPTION;
    }

    public static void throwNullUsernameException() {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("Invalid username");
        }
        throw CACHED_NULL_USERNAME_EXCEPTION;
    }

    public static void throwEmptyUsernameException() {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("Empty username? Or malicious UTF-8 data?");
        }
        throw CACHED_EMPTY_USERNAME_EXCEPTION;
    }

    public static void throwNoSessionException(int challengeToken) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new IllegalStateException("No Session!" + challengeToken);
        }
        throw CACHED_NO_SESSION_EXCEPTION_EXCEPTION;
    }

    public static void throwInvalidDataException() {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new IllegalStateException("Invalid data request packet!");
        }
        throw CACHED_INVALID_DATA_EXCEPTION;
    }

    public static void throwUnexpectedLoginPacketException(ByteBuf raw) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new IllegalStateException("Unexpected packet received during login process! " + BufUtil.dump(raw, 16));
        }
        throw CACHED_UNEXPECTED_LOGIN_PACKET;
    }

    public static void throwBadFrameLengthException(int length) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("length wider than 21-bit. Sent length: " + length);
        }
        throw CACHED_BAD_FRAME_LENGTH;
    }

    public static void throwBigServerCompressedPacketException() throws DataFormatException {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new DataFormatException("The server sent a very large (over 2MiB compressed) packet");
        }
        throw CACHED_BIG_SERVER_COMPRESSED_PACKET_EXCEPTION;
    }

    public static void throwBigPayloadException(int length) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("Payload may not be larger than 1048576 bytes. Sent length: " + length);
        }
        throw CACHED_BIG_PAYLOAD_EXCEPTION;
    }

    public static void throwBigUnframedPacketException(ByteBuf buf) {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("Length is bigger than 16 MiB. Sent bytes: " + buf.readableBytes());
        }
        throw CACHED_BIG_UNFRAMED_PACKET;
    }

    public static void throwBadFrameLengthException() {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            throw new CorruptedFrameException("Illegal big unframed packet");
        }
        throw CACHED_BAD_FRAME_LENGTH;
    }

    public static Exception createDiscardException() {
        if (ConfigSettings.IMP.LOGS.PRINT_FULL_STACKTRACES) {
            return new IllegalStateException("Discard handler is added to the pipeline");
        }
        return CACHED_DISCARD;
    }

    private static QuietException createQuietException(String message) {
        return new QuietException(message + "; Enable print-full-stacktraces to get useful information");
    }

    private ExploitExceptionHandler() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

