/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.compress;

import es.xism4.software.ExploitExceptionHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.shieldcommunity.nullcordx.natives.ByteBufAllocationUtils;
import net.shieldcommunity.nullcordx.natives.compression.Compressor;

public class PacketCompressor
extends MessageToByteEncoder<ByteBuf> {
    private static final int MAX_BUFF_LENGTH = 0x200000;
    private final Compressor compressor;
    private int threshold = 256;

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.compressor.close();
        if (ctx.channel().isActive() && ctx.pipeline().get("packet-encoder") != null) {
            ctx.pipeline().addBefore("packet-encoder", "frame-prepender", PipelineUtils.framePrepender);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        int origSize = msg.readableBytes();
        if (origSize < this.threshold) {
            DefinedPacket.writeVarInt(origSize + 1, out);
            DefinedPacket.writeVarInt(0, out);
            out.writeBytes(msg);
            return;
        }
        int uncompressed = msg.readableBytes();
        DefinedPacket.write21BitVarInt(0, out);
        DefinedPacket.writeVarInt(uncompressed, out);
        ByteBuf compatibleIn = ByteBufAllocationUtils.makeCorrect(ctx.alloc(), this.compressor, msg);
        int startCompressed = out.writerIndex();
        try {
            this.compressor.deflate(compatibleIn, out);
        }
        finally {
            compatibleIn.release();
        }
        int compressedLength = out.writerIndex() - startCompressed;
        if (compressedLength >= 0x200000) {
            ExploitExceptionHandler.throwBigServerCompressedPacketException();
        }
        int writerIndex = out.writerIndex();
        int packetLength = out.readableBytes() - 3;
        out.writerIndex(0);
        DefinedPacket.write21BitVarInt(packetLength, out);
        out.writerIndex(writerIndex);
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext ctx, ByteBuf msg, boolean preferDirect) throws Exception {
        return PacketCompressor.allocateByteBufForCompression(ctx.alloc(), msg, this.threshold);
    }

    public static ByteBuf allocateByteBufForCompression(ByteBufAllocator allocator, ByteBuf msg, int threshold) {
        int uncompressed = msg.readableBytes();
        if (uncompressed < threshold) {
            int finalBufferSize = uncompressed + 1;
            finalBufferSize += DefinedPacket.varIntBytes(finalBufferSize);
            return allocator.directBuffer(finalBufferSize);
        }
        int initialBufferSize = uncompressed - 1 + 3 + DefinedPacket.varIntBytes(uncompressed);
        return allocator.directBuffer(initialBufferSize);
    }

    public PacketCompressor(Compressor compressor) {
        this.compressor = compressor;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }
}

