/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EntityRemoveEffect
extends DefinedPacket {
    private int entityId;
    private int effectId;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.entityId = protocolVersion >= 47 ? EntityRemoveEffect.readVarInt(buf) : buf.readInt();
        this.effectId = buf.readUnsignedByte();
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        if (protocolVersion >= 47) {
            EntityRemoveEffect.writeVarInt(this.entityId, buf);
        } else {
            buf.writeInt(this.entityId);
        }
        buf.writeByte(this.effectId);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public int getEffectId() {
        return this.effectId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setEffectId(int effectId) {
        this.effectId = effectId;
    }

    @Override
    public String toString() {
        return "EntityRemoveEffect(entityId=" + this.getEntityId() + ", effectId=" + this.getEffectId() + ")";
    }

    public EntityRemoveEffect() {
    }

    public EntityRemoveEffect(int entityId, int effectId) {
        this.entityId = entityId;
        this.effectId = effectId;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityRemoveEffect)) {
            return false;
        }
        EntityRemoveEffect other = (EntityRemoveEffect)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        return this.getEffectId() == other.getEffectId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EntityRemoveEffect;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getEffectId();
        return result;
    }
}

