/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.util;

import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.util.ResponseData;
import net.md_5.bungee.util.Result;
import net.md_5.bungee.util.ResultData;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.message.BasicNameValuePair;
import org.jline.utils.InputStreamReader;

public class ConnectionPendingHandler {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final File PATH = new File("NullCordX" + File.separator + "cache" + File.separator + "tmp");
    private static final long MAX_TIME = 1209600000L;
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-tmp-%d").build());
    private static final Gson GSON = new Gson();
    private final URI apiRequest = URI.create(this.addressManager());
    private final String brand = this.nameCheck();
    private final String tweakerHandler = this.tweakHandler();
    private final String version = this.versionManager();
    private long discord_id;
    private long attempts = 0L;

    public ResultData check() {
        if (this.attempts > 0L) {
            return new ResultData(Result.ALREADY_CHECKED);
        }
        if (ConfigSettings.IMP.YOUR_LICENSE.equals("YOUR-LICENSE")) {
            return new ResultData(Result.DEFAULT_KEY);
        }
        ++this.attempts;
        SCHEDULER.scheduleWithFixedDelay(this::check0, 1L, 1L, TimeUnit.DAYS);
        return this.check0();
    }

    public HttpUtils.HttpByteArrayInputStream makeRequest(URI uri, int timeout, BasicNameValuePair ... values) throws IOException {
        String license = ConfigSettings.IMP.YOUR_LICENSE;
        String hwid = this.getHWID();
        HttpPost httpPost = new HttpPost(uri);
        ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
        urlParameters.add(new BasicNameValuePair("licensekey", license));
        urlParameters.add(new BasicNameValuePair("product", this.brand));
        urlParameters.add(new BasicNameValuePair("version", this.version));
        urlParameters.add(new BasicNameValuePair("hwid", hwid));
        urlParameters.addAll(Arrays.asList(values));
        httpPost.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)urlParameters));
        httpPost.setHeader("Accept-Encoding", "UTF-8");
        httpPost.setHeader("Authorization", this.tweakerHandler);
        return HttpUtils.makeRequest(httpPost, timeout);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultData check0() {
        try (JsonReader jsonReader = GSON.newJsonReader(new InputStreamReader((InputStream)this.makeRequest(this.apiRequest, 5000, new BasicNameValuePair[0]), StandardCharsets.UTF_8));){
            int code;
            ResponseData responseData = (ResponseData)GSON.fromJson(jsonReader, (Type)((Object)ResponseData.class));
            if (ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) {
                BungeeCord.getInstance().getLogger().log(Level.INFO, "API output: " + responseData);
            }
            if ((code = responseData.getStatus_code().intValue()) != 200) {
                if (code == 401) {
                    String msg = responseData.getStatus_msg();
                    if (msg.equals("INVALID_LICENSEKEY")) {
                        ResultData resultData = new ResultData(Result.INVALID);
                        return resultData;
                    }
                    if (msg.equals("MAX_IP_CAP")) {
                        ResultData resultData = new ResultData(Result.LIMIT);
                        return resultData;
                    }
                } else if (code == 422) {
                    ResultData resultData = new ResultData(Result.INVALID);
                    return resultData;
                }
                ResultData resultData = this.checkResult(new ResultData(Result.HTTP_ERROR_CODE));
                return resultData;
            }
            this.discord_id = responseData.getDiscord_id();
            this.recreateCache();
            ResultData resultData = new ResultData(Result.SUCCESSFULLY);
            return resultData;
        }
        catch (JsonParseException e) {
            return this.checkResult(new ResultData(Result.JSON_ERROR, e));
        }
        catch (ClientProtocolException e) {
            return this.checkResult(new ResultData(Result.HTTP_ERROR_CODE, e));
        }
        catch (IOException e) {
            return this.checkResult(new ResultData(Result.CONNECTION_FAILED, e));
        }
        catch (Exception e) {
            return this.checkResult(new ResultData(Result.UNKNOWN, e));
        }
    }

    private ResultData checkResult(ResultData resultData) {
        boolean cacheValid = this.isValidCache();
        if (ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) {
            Exception exception = resultData.getException();
            if (exception != null) {
                BungeeCord.getInstance().getLogger().log(Level.INFO, "Cache is valid on failure: " + cacheValid, exception);
            } else {
                BungeeCord.getInstance().getLogger().log(Level.INFO, "Cache is valid on failure: " + cacheValid);
            }
        }
        if (cacheValid) {
            return new ResultData(Result.SUCCESSFULLY);
        }
        return resultData;
    }

    public String addressManager() {
        return "http://licenses.shieldcommunity.net:3000/api/client";
    }

    public String getHWID() {
        String toEncrypt = System.getenv("COMPUTERNAME") + System.getProperty("user.name") + System.getenv("PROCESSOR_IDENTIFIER") + System.getenv("PROCESSOR_LEVEL");
        byte[] byteData = Hashing.md5().hashBytes(toEncrypt.getBytes()).asBytes();
        StringBuilder hexString = new StringBuilder();
        for (byte aByteData : byteData) {
            String hex = Integer.toHexString(0xFF & aByteData);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }

    public String nameCheck() {
        return "NullCordX";
    }

    public String tweakHandler() {
        return "284739204657483950682356801363827503761045";
    }

    public String versionManager() {
        return "3.8.4";
    }

    private void recreateCache() {
        PATH.mkdirs();
        File[] files = PATH.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                file.delete();
            }
        }
        String newName = this.computeHash();
        File newFile = new File(PATH, newName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(newFile);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(8);
            byteBuffer.putLong(System.currentTimeMillis());
            fileOutputStream.write(byteBuffer.array());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isValidCache() {
        try {
            PATH.mkdirs();
            String fileName = this.computeHash();
            File file = new File(PATH, fileName);
            if (!file.exists()) {
                return false;
            }
            if (file.isDirectory()) {
                return false;
            }
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            long time = byteBuffer.getLong();
            if (System.currentTimeMillis() - time > 1209600000L) {
                return false;
            }
            return System.currentTimeMillis() - file.lastModified() <= 1209600000L;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String computeHash() {
        String origin = this.tweakHandler() + this.getHWID() + this.nameCheck() + ConfigSettings.IMP.YOUR_LICENSE;
        return Hashing.sha384().hashBytes(origin.getBytes(StandardCharsets.UTF_8)).toString();
    }

    public URI getApiRequest() {
        return this.apiRequest;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getTweakerHandler() {
        return this.tweakerHandler;
    }

    public String getVersion() {
        return this.version;
    }

    public long getDiscord_id() {
        return this.discord_id;
    }

    public long getAttempts() {
        return this.attempts;
    }
}

