/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ASNCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedFramedPuzzleCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AttributesCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.CaptchaCheckFactory;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.CountryCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.DummyCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.EmptyCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndAnimatedHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndHandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndHandCaptchaCheckFactory;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndProxyCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallAndProxyCheckFactory;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallCheckFactory;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedPuzzleCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.HandCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.PickCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ProxyCheck;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingListFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.ConditionEvent;
import net.shieldcommunity.nullcordx.api.checking.ConditionType;
import net.shieldcommunity.nullcordx.api.checking.LazyLoadedCheckingFactory;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBoundingBox;
import net.shieldcommunity.nullcordx.api.utils.location.Vector3D;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;

@Singleton
public class AntiBotChecksCreator {
    private final NullCordXLogger logger;
    private final LanguageManagerImpl languageManager;
    private AxisAlignedBounding axisAlignedBounding;

    @Inject
    public AntiBotChecksCreator(NullCordXLogger logger, LanguageManagerImpl languageManager) {
        this.logger = logger;
        this.languageManager = languageManager;
    }

    public void load() {
        AntibotSettings.ANTIBOT.DIMENSION.ALLOWED_REGION allowedRegionSettings = AntibotSettings.IMP.ANTIBOT.DIMENSION.ALLOWED_REGION;
        AxisAlignedBoundingBox alignedBounding = null;
        if (allowedRegionSettings.ENABLED) {
            AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
            alignedBounding = AxisAlignedBoundingBox.createFromLocationAndSize(Vector3D.of(location.X, location.Y, location.Z), allowedRegionSettings.X_SIZE, allowedRegionSettings.Y_SIZE, allowedRegionSettings.Z_SIZE);
        }
        this.axisAlignedBounding = alignedBounding;
    }

    public Map<String, CheckingFactory> createCheckingFactoryTemplates(ForkJoinPool executor, CheckingFactoriesImpl checkingFactories) {
        String name;
        Object data;
        HashMap<String, CheckingFactory> checkingFactoryTemplates = new HashMap<String, CheckingFactory>();
        for (Map.Entry<String, AntibotSettings.ANTIBOT.MODES_TEMPLATES.EMPTY_CHECK_TEMPLATE> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.EMPTY_CHECK_TEMPLATES.entrySet()) {
            data = entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new LazyLoadedCheckingFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), (AntibotSettings.ANTIBOT.MODES_TEMPLATES.EMPTY_CHECK_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.EMPTY_CHECK_TEMPLATE val$data;
                {
                    this.val$data = eMPTY_CHECK_TEMPLATE;
                    super(name, conditionData);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new EmptyCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.val$data.MAX_CHECK_TIME);
                }

                public Class<? extends AbstractVirtualChecking> getType() {
                    return EmptyCheck.class;
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FALL_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new FallCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_CHECK_TEMPLATE)data, executor, checkingFactories));
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.HAND_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), HandCaptchaCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX){

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new HandCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), AnimatedHandCaptchaCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX){

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new AnimatedHandCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FRAMED_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), FramedCaptchaCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX){

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new FramedCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.ANIMATED_FRAMED_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), AnimatedFramedCaptchaCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX){

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new AnimatedFramedCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FRAMED_PUZZLE_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), FramedPuzzleCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE val$data;
                {
                    this.val$data = pUZZLE_CAPTCHA_CHECK_TEMPLATE;
                    super(name, conditionData, type, languageManager, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new FramedPuzzleCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.val$data.COMPLETE_ON_CHAT, this.val$data.EXPECT_CODE, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.ANIMATED_FRAMED_PUZZLE_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), AnimatedFramedPuzzleCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.PUZZLE_CAPTCHA_CHECK_TEMPLATE val$data;
                {
                    this.val$data = pUZZLE_CAPTCHA_CHECK_TEMPLATE;
                    super(name, conditionData, type, languageManager, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new AnimatedFramedPuzzleCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.val$data.COMPLETE_ON_CHAT, this.val$data.EXPECT_CODE, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.PICK_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new CaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), PickCaptchaCheck.class, this.languageManager, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.CAPTCHA_CHECK_TEMPLATE)data).ANSWER_PREFIX){

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new PickCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.maxAttempts, this.maxSolves, this.newCaptchaOnFail, this.answerPrefix, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FALL_AND_HAND_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new FallAndHandCaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), FallAndHandCaptchaCheck.class, this.languageManager, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data, executor, checkingFactories, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).ANSWER_PREFIX, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE val$data;
                {
                    this.val$data = fALL_AND_CAPTCHA_TEMPLATE;
                    super(name, conditionData, type, languageManager, data, executor, checkingFactories, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new FallAndHandCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.val$data.MAX_CHECK_TIME, this.val$data.MIN_HEIGHT_RESET, this.cachedSynchronizePlayerPosition, connector.isGeyser() ? this.cachedFallDataForGeyserList : this.cachedFallDataForJavaList, this.tempCachedBlockPlacePacket, this.tempCachedBlockRemovePacket, this.val$data.MAX_ATTEMPTS, this.val$data.MAX_SOLVES, this.val$data.NEW_CAPTCHA_ON_FAIL, this.val$data.ANSWER_PREFIX, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FALL_AND_ANIMATED_HAND_CAPTCHA_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new FallAndHandCaptchaCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), FallAndAnimatedHandCaptchaCheck.class, this.languageManager, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data, executor, checkingFactories, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).MAX_ATTEMPTS, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).MAX_SOLVES, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).NEW_CAPTCHA_ON_FAIL, ((AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data).ANSWER_PREFIX, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_CAPTCHA_TEMPLATE val$data;
                {
                    this.val$data = fALL_AND_CAPTCHA_TEMPLATE;
                    super(name, conditionData, type, languageManager, data, executor, checkingFactories, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new FallAndAnimatedHandCaptchaCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.val$data.MAX_CHECK_TIME, this.val$data.MIN_HEIGHT_RESET, this.cachedSynchronizePlayerPosition, connector.isGeyser() ? this.cachedFallDataForGeyserList : this.cachedFallDataForJavaList, this.tempCachedBlockPlacePacket, this.tempCachedBlockRemovePacket, this.val$data.MAX_ATTEMPTS, this.val$data.MAX_SOLVES, this.val$data.NEW_CAPTCHA_ON_FAIL, this.val$data.ANSWER_PREFIX, this.messagesByLanguage);
                }
            });
        }
        for (Map.Entry<String, Object> entry : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.FALL_AND_PROXY_CHECK_TEMPLATES.entrySet()) {
            data = (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_PROXY_TEMPLATE)entry.getValue();
            name = entry.getKey();
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, name, new FallAndProxyCheckFactory(name, AntiBotChecksCreator.constructDefaultConditionData(), FallAndProxyCheck.class, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_PROXY_TEMPLATE)data, executor, checkingFactories, (AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_PROXY_TEMPLATE)data){
                final /* synthetic */ AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_AND_PROXY_TEMPLATE val$data;
                {
                    this.val$data = fALL_AND_PROXY_TEMPLATE;
                    super(name, conditionData, type, data, executor, checkingFactories);
                }

                @Override
                public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new FallAndProxyCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, this.val$data.MAX_CHECK_TIME, this.val$data.MIN_HEIGHT_RESET, this.cachedSynchronizePlayerPosition, connector.isGeyser() ? this.cachedFallDataForGeyserList : this.cachedFallDataForJavaList, this.tempCachedBlockPlacePacket, this.tempCachedBlockRemovePacket);
                }
            });
        }
        for (String string : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.COUNTRY_CHECK_TEMPLATES) {
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, string, new LazyLoadedCheckingFactory(string, AntiBotChecksCreator.constructDefaultConditionData()){

                @Override
                public AbstractChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new CountryCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding);
                }

                @Override
                public Class<? extends AbstractChecking> getType() {
                    return CountryCheck.class;
                }
            });
        }
        for (String string : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.ASN_CHECK_TEMPLATES) {
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, string, new LazyLoadedCheckingFactory(string, AntiBotChecksCreator.constructDefaultConditionData()){

                @Override
                public AbstractChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new ASNCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding);
                }

                @Override
                public Class<? extends AbstractChecking> getType() {
                    return ASNCheck.class;
                }
            });
        }
        for (String string : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.PROXY_CHECK_TEMPLATE) {
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, string, new LazyLoadedCheckingFactory(string, AntiBotChecksCreator.constructDefaultConditionData()){

                @Override
                public AbstractChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new ProxyCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding);
                }

                @Override
                public Class<? extends AbstractChecking> getType() {
                    return ProxyCheck.class;
                }
            });
        }
        for (String string : AntibotSettings.IMP.ANTIBOT.MODES_TEMPLATE.ATTRIBUTES_CHECK_TEMPLATE) {
            this.checkAndAddCheckingFactory(checkingFactoryTemplates, string, new LazyLoadedCheckingFactory(string, AntiBotChecksCreator.constructDefaultConditionData()){

                @Override
                public AbstractChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                    return new AttributesCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding);
                }

                @Override
                public Class<? extends AbstractChecking> getType() {
                    return AttributesCheck.class;
                }
            });
        }
        return checkingFactoryTemplates;
    }

    public CheckingListFactory createCheckingFactoryByModes(List<String> modes, Map<String, CheckingFactory> checkingFactoryTemplates, String name) {
        ArrayList<CheckingFactory> checking = new ArrayList<CheckingFactory>();
        if (!modes.isEmpty()) {
            for (String mode : modes) {
                CheckingFactory checkingFactory = checkingFactoryTemplates.get(mode.toLowerCase(Locale.ROOT));
                if (checkingFactory == null) {
                    checkingFactory = this.createDefaultEmptyChecking();
                    this.logger.log(Level.WARNING, "Failed to detect template mode '" + mode + "' for " + name + ". Using empty...");
                }
                this.loadCheckingFactory(checkingFactory);
                ConditionData conditionData = checkingFactory.getConditionData();
                this.lazyLoadSuccessCheckingFactory(conditionData, 1);
                this.lazyLoadFailedCheckingFactory(conditionData, 1);
                checking.add(checkingFactory);
            }
        } else {
            this.logger.log(Level.INFO, "It seems '" + name + "' does not have a list of modes! We add one empty.");
            checking.add(this.createDefaultEmptyChecking());
        }
        final List doneCheckingFactories = Collections.unmodifiableList(checking);
        return new CheckingListFactory(){

            @Override
            public List<CheckingFactory> createNewCheckingFactoriesList() {
                return new ArrayList<CheckingFactory>(doneCheckingFactories);
            }

            @Override
            public List<CheckingFactory> getUsedFactories() {
                return doneCheckingFactories;
            }
        };
    }

    private void loadCheckingFactory(CheckingFactory checkingFactory) {
        if (checkingFactory.isLazyLoaded()) {
            return;
        }
        this.logger.log(Level.INFO, "Loading antibot check '" + checkingFactory.getName() + "'...");
        try {
            long start = System.currentTimeMillis();
            checkingFactory.lazyLoad();
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Antibot check '" + checkingFactory.getName() + "' loaded in " + (end - start) + "ms");
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load antibot check '" + checkingFactory.getName() + "'", e);
        }
    }

    private void lazyLoadSuccessCheckingFactory(ConditionData conditionData, int innerCount) {
        ConditionEvent successEvent = conditionData.getOnSuccessEvent();
        CheckingFactory successFactory = successEvent.getCheckingFactory();
        if (successFactory != null) {
            if (innerCount >= 256) {
                this.logger.log(Level.SEVERE, "Too many nested goto conditions for successful check. Current check: " + successFactory.getName());
                return;
            }
            this.loadCheckingFactory(successFactory);
            this.lazyLoadSuccessCheckingFactory(successFactory.getConditionData(), innerCount + 1);
        }
    }

    private void lazyLoadFailedCheckingFactory(ConditionData conditionData, int innerCount) {
        ConditionEvent failedEvent = conditionData.getOnFailedEvent();
        CheckingFactory failedFactory = failedEvent.getCheckingFactory();
        if (failedFactory != null) {
            if (innerCount >= 256) {
                this.logger.log(Level.SEVERE, "Too many nested goto conditions for failed check. Current check: " + failedFactory.getName());
                return;
            }
            this.loadCheckingFactory(failedFactory);
            this.lazyLoadFailedCheckingFactory(failedFactory.getConditionData(), innerCount + 1);
        }
    }

    private void checkAndAddCheckingFactory(Map<String, CheckingFactory> checkingFactoryTemplates, String name, CheckingFactory checkingFactory) {
        if (checkingFactoryTemplates.get(name = name.toLowerCase(Locale.ROOT)) != null) {
            this.logger.log(Level.SEVERE, "Failed to add a mode template: Template with name '" + name + "' already exists!");
            return;
        }
        checkingFactoryTemplates.put(name, checkingFactory);
    }

    private CheckingFactory createDefaultEmptyChecking() {
        return new CheckingFactory(){

            @Override
            public String getName() {
                return "empty";
            }

            @Override
            public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                return new EmptyCheck(this, connector, nullCordX, AntiBotChecksCreator.this.axisAlignedBounding, 5000);
            }

            public Class<? extends AbstractVirtualChecking> getType() {
                return EmptyCheck.class;
            }

            @Override
            public ConditionData getConditionData() {
                return AntiBotChecksCreator.constructDefaultConditionData();
            }

            @Override
            public void setConditionData(ConditionData data) {
            }
        };
    }

    public static CheckingListFactory createDummyCheckingListFactory() {
        ArrayList<18> checking = new ArrayList<18>();
        checking.add(new LazyLoadedCheckingFactory("dummy", AntiBotChecksCreator.constructDefaultConditionData()){

            @Override
            public AbstractChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
                return new DummyCheck(this, connector, nullCordX);
            }

            @Override
            public Class<? extends AbstractChecking> getType() {
                return DummyCheck.class;
            }
        });
        final List doneCheckingFactories = Collections.unmodifiableList(checking);
        return new CheckingListFactory(){

            @Override
            public List<CheckingFactory> createNewCheckingFactoriesList() {
                return new ArrayList<CheckingFactory>(doneCheckingFactories);
            }

            @Override
            public List<CheckingFactory> getUsedFactories() {
                return doneCheckingFactories;
            }
        };
    }

    public static ConditionData constructDefaultConditionData() {
        return new ConditionData(AntiBotChecksCreator.constructDefaultSuccessConditionEvent(), AntiBotChecksCreator.constructDefaultFailedConditionEvent(), true, true);
    }

    public static ConditionEvent constructDefaultSuccessConditionEvent() {
        return new ConditionEvent(ConditionType.NEXT, null);
    }

    public static ConditionEvent constructDefaultFailedConditionEvent() {
        return new ConditionEvent(ConditionType.KICK, null);
    }
}

