/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.antiproxy;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.CachedProxyCheckerImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.CustomProxyService;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.IpHubProxyService;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.ProxyCheckProxyService;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.VpnApiProxyService;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.ProxyCheck;
import net.shieldcommunity.nullcordx.api.antibot.ExecutorCallback;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.AntiProxyManager;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.CachedProxyChecker;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.AbstractAntiProxyService;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.database.DatabaseRepository;
import net.shieldcommunity.nullcordx.database.ProxyAddress;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.LoadingCache;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

@Singleton
public class AntiProxyManagerImpl
extends ManagerComponent
implements AntiProxyManager {
    private final LocalScheduler localScheduler;
    private final CheckingFactoriesImpl checkingFactories;
    private final DatabaseRepository databaseRepository;
    private LoadingCache<InetAddress, CachedProxyCheckerImpl> cache = null;
    private ExecutorService executor = null;
    private boolean fastCacheCheckForJava = false;
    private boolean fastCacheCheckForGeyser = false;
    private InetAddressSet ignoredIps = new InetAddressSet();
    private List<AbstractAntiProxyService> antiProxyServices = new ArrayList<AbstractAntiProxyService>();

    @Inject
    public AntiProxyManagerImpl(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, CheckingFactoriesImpl checkingFactories, DatabaseRepository databaseRepository) {
        super(logger, nullCordX, "AntiProxyManager");
        this.localScheduler = localScheduler;
        this.checkingFactories = checkingFactories;
        this.databaseRepository = databaseRepository;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!this.checkingFactories.isProxyCheckUsed()) {
            this.logger.log(Level.INFO, this.componentName + " disabled: Not used anywhere in the antibot settings!");
            return;
        }
        this.ignoredIps = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.IGNORED_IPS.calculateAddresses(this.logger, "proxy ignored addresses");
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.MAX_CACHE_TIME, TimeUnit.MILLISECONDS).build(key -> new CachedProxyCheckerImpl(this.nullCordX, (InetAddress)key));
        try {
            for (ProxyAddress proxyAddress : this.databaseRepository.getAllProxyAddress().get()) {
                InetAddress address = InetSocketUtil.getAddressSafe(proxyAddress.getAddress());
                if (address == null) continue;
                ProxyResult result = ProxyResult.valueOf(proxyAddress.getResult().toUpperCase(Locale.ROOT));
                CachedProxyCheckerImpl cachedProxyChecker = new CachedProxyCheckerImpl(this.nullCordX, address);
                cachedProxyChecker.setCachedResult(result);
                this.cache.put(address, cachedProxyChecker);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load proxy addressed from database", e);
        }
        int threads = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.THREAD_POOL_SIZE;
        if (threads == -1) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        this.executor = Executors.newFixedThreadPool(threads, new ThreadFactoryBuilder().setNameFormat("NullCordX-Proxy-Check-%d").build());
        AntibotSettings.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.PROXY_CHECK_IO proxyCheckIo = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.PROXY_CHECK_IO;
        if (proxyCheckIo.ENABLED) {
            this.antiProxyServices.add(new ProxyCheckProxyService(this.nullCordX, proxyCheckIo.CONNECTION_TIMEOUT, proxyCheckIo.LICENSE_KEY, proxyCheckIo.VPN_MODE, proxyCheckIo.RISK));
        }
        AntibotSettings.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.IP_HUB_INFO ipHubInfo = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.IP_HUB_INFO;
        if (ipHubInfo.ENABLED) {
            this.antiProxyServices.add(new IpHubProxyService(this.nullCordX, ipHubInfo.CONNECTION_TIMEOUT, ipHubInfo.LICENSE_KEY, ipHubInfo.BLOCK_TYPE));
        }
        AntibotSettings.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.VPN_API_INFO vpnApiInfo = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.VPN_API_INFO;
        if (vpnApiInfo.ENABLED) {
            this.antiProxyServices.add(new VpnApiProxyService(this.nullCordX, vpnApiInfo.CONNECTION_TIMEOUT, vpnApiInfo.LICENSE_KEY, vpnApiInfo.BLOCK_TYPE));
        }
        AntibotSettings.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.CUSTOM custom = AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.SERVICES.CUSTOM;
        if (custom.ENABLED) {
            Pattern pattern;
            HashMap<String, String> parsedRequests = new HashMap<String, String>();
            for (String keyAndValue : custom.REQUEST_PROPERTIES) {
                String[] args = keyAndValue.split("=");
                if (args.length != 2) {
                    this.logger.warning("Failed to parse request '" + keyAndValue + "' for custom proxy check");
                    continue;
                }
                parsedRequests.put(args[0], args[1]);
            }
            try {
                pattern = Pattern.compile(custom.DETECT_REGEX_PATTERN);
            }
            catch (PatternSyntaxException e) {
                this.logger.warning("Failed to parse pattern detect '" + custom.DETECT_REGEX_PATTERN + "' for custom proxy check");
                pattern = Pattern.compile("VPN");
            }
            this.antiProxyServices.add(new CustomProxyService(this.nullCordX, custom.CONNECTION_TIMEOUT, custom.API_URL, parsedRequests, pattern));
        }
        this.loadAntiProxyServices();
        this.scheduleCleanup();
    }

    @Override
    protected void onUnload() {
        this.unloadAntiProxyServices();
        this.antiProxyServices.clear();
        this.clear(false);
        this.cache = null;
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
            }
        }
    }

    public boolean canUseFastCacheCheck(boolean geyser) {
        return geyser ? this.fastCacheCheckForGeyser : this.fastCacheCheckForJava;
    }

    @Override
    public void submitLookup(InetAddress address, ExecutorCallback<CachedProxyChecker> response) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            if (!response.canExecute()) {
                return;
            }
            CachedProxyCheckerImpl cachedProxyChecker = this.lookupProxy(address);
            if (cachedProxyChecker == null) {
                return;
            }
            this.databaseRepository.saveProxy(address.getHostAddress(), cachedProxyChecker.getCachedResult().name(), System.currentTimeMillis());
            response.onExecute(cachedProxyChecker);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedProxyCheckerImpl lookupProxy(InetAddress address) {
        if (this.cache == null) {
            return null;
        }
        CachedProxyCheckerImpl cachedProxyChecker = this.cache.get(address);
        if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
            cachedProxyChecker.setCachedResult(ProxyResult.LOCAL_ADDRESS);
            return cachedProxyChecker;
        }
        if (this.ignoredIps != null && this.ignoredIps.contains(address)) {
            cachedProxyChecker.setCachedResult(ProxyResult.IGNORED);
            return cachedProxyChecker;
        }
        ReentrantLock lock = cachedProxyChecker.getLock();
        if (!lock.tryLock()) {
            cachedProxyChecker.setCachedResult(ProxyResult.ALREADY_CHECKING);
            return cachedProxyChecker;
        }
        try {
            cachedProxyChecker.checkAll(this.antiProxyServices);
            CachedProxyCheckerImpl cachedProxyCheckerImpl = cachedProxyChecker;
            return cachedProxyCheckerImpl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public CachedProxyCheckerImpl getCheckerByAddress(InetAddress address) {
        if (this.cache == null) {
            return null;
        }
        return (CachedProxyCheckerImpl)this.cache.getIfPresent(address);
    }

    @Override
    public void clear(boolean database) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
        if (database) {
            this.databaseRepository.deleteAllProxies();
        }
    }

    @Override
    public void remove(InetAddress address, boolean database) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate(address);
        if (database) {
            this.databaseRepository.deleteProxy(address.getHostAddress());
        }
    }

    @Override
    public void setAntiProxyServices(List<AbstractAntiProxyService> antiProxyServices) {
        Preconditions.checkState(antiProxyServices != null, "antiProxyService is null!");
        this.antiProxyServices = antiProxyServices;
    }

    @Override
    public void reloadAntiProxyServices() {
        this.unloadAntiProxyServices();
        this.loadAntiProxyServices();
    }

    public void loadAntiProxyServices() {
        for (AbstractAntiProxyService antiProxyService : this.antiProxyServices) {
            try {
                antiProxyService.load();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load proxy service " + antiProxyService.getName(), e);
            }
        }
    }

    public void unloadAntiProxyServices() {
        for (AbstractAntiProxyService antiProxyService : this.antiProxyServices) {
            try {
                antiProxyService.unload();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to unload proxy service " + antiProxyService.getName(), e);
            }
        }
    }

    private void scheduleCleanup() {
        if (AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.USE_FAST_CACHE_CHECK) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    AntiProxyManagerImpl.this.fastCacheCheckForGeyser = AntiProxyManagerImpl.this.checkAbilityForFastCache(true);
                    AntiProxyManagerImpl.this.fastCacheCheckForJava = AntiProxyManagerImpl.this.checkAbilityForFastCache(false);
                }
            }, 1L, 1L, TimeUnit.SECONDS);
        }
        this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                AntiProxyManagerImpl.this.databaseRepository.clearOldProxies(System.currentTimeMillis() - (long)AntibotSettings.IMP.ANTIBOT.ANTI_PROXY_CHECK.MAX_CACHE_TIME);
            }
        }, 1L, 1L, TimeUnit.HOURS);
    }

    private boolean checkAbilityForFastCache(boolean geyser) {
        List<CheckingFactory> factories = this.checkingFactories.getCurrentCheckingFactory(geyser).getUsedFactories();
        for (CheckingFactory factory : factories) {
            if (factory.getType() != ProxyCheck.class) continue;
            return true;
        }
        return false;
    }
}

