/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.antiproxy.services;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.antiproxy.services.AbstractLicenseAntiProxyService;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.ProxyResult;
import net.shieldcommunity.nullcordx.api.antibot.antiproxy.services.ProxyServiceCheckFailedException;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import org.apache.http.client.methods.HttpGet;

public class IpHubProxyService
extends AbstractLicenseAntiProxyService {
    private static final String ENTRY_POINT = "https://v2.api.iphub.info/ip/";
    private final int blockType;

    public IpHubProxyService(NullCordXImpl nullCordX, int timeout, String license, int blockType) {
        super("IpHub.info", nullCordX, timeout, license);
        this.blockType = blockType;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProxyResult checkProxy(InetAddress address) throws ProxyServiceCheckFailedException {
        String apiUrl = ENTRY_POINT + address.getHostAddress();
        try {
            URI uri = URI.create(apiUrl);
            HttpGet httpGet = new HttpGet(uri);
            httpGet.setHeader("Accept-Encoding", "UTF-8");
            httpGet.setHeader("Content-Type", "application/json");
            httpGet.setHeader("X-Key", this.license);
            try (HttpUtils.HttpByteArrayInputStream inputStream = HttpUtils.makeRequest(httpGet, this.timeout);){
                ProxyResult proxyResult;
                block23: {
                    JsonReader reader;
                    block21: {
                        ProxyResult proxyResult2;
                        block22: {
                            int block;
                            block19: {
                                ProxyResult proxyResult3;
                                block20: {
                                    int code = inputStream.getCode();
                                    if (code != 200) {
                                        throw new ProxyServiceCheckFailedException("Expected response code 200 (HTTP_OK) but received: " + code + ": " + inputStream.getTextResponse() + "'");
                                    }
                                    reader = GSON.newJsonReader(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                                    try {
                                        JsonElement element = JsonParser.parseReader(reader);
                                        JsonObject jsonObject = element.getAsJsonObject();
                                        block = jsonObject.get("block").getAsInt();
                                        if (this.blockType != -1 || block == 0) break block19;
                                        proxyResult3 = ProxyResult.DETECTED;
                                        if (reader == null) break block20;
                                    }
                                    catch (Throwable throwable) {
                                        if (reader != null) {
                                            try {
                                                reader.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    reader.close();
                                }
                                return proxyResult3;
                            }
                            if (this.blockType != block) break block21;
                            proxyResult2 = ProxyResult.DETECTED;
                            if (reader == null) break block22;
                            reader.close();
                        }
                        return proxyResult2;
                    }
                    proxyResult = ProxyResult.ALLOWED;
                    if (reader == null) break block23;
                    reader.close();
                }
                return proxyResult;
            }
        }
        catch (Exception e) {
            throw new ProxyServiceCheckFailedException(e);
        }
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onUnload() {
    }
}

