/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.AntiBotManagerImpl;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.CaptchaGenerationConditionResult;
import net.shieldcommunity.nullcordx.antibot.captcha.CaptchaGenerationPreCondition;
import net.shieldcommunity.nullcordx.antibot.captcha.CaptchaGenerationTaskFactory;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapPalette;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.CaptchaDataSettings;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.AnimatedFramedCaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.AnimatedFramedPuzzleGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.AnimatedHandCaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.CaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.FramedCaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.FramedPuzzleGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.HandCaptchaGenerationTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.PickCaptchaGenerationTask;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaManagerImpl;
import net.shieldcommunity.nullcordx.cache.CachedCaptchaPacketsImpl;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedHandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.FramedPuzzleSettings;
import net.shieldcommunity.nullcordx.config.captcha.HandCaptchaSettings;
import net.shieldcommunity.nullcordx.config.captcha.PickCaptchaSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;
import net.shieldcommunity.nullcordx.utils.CustomFJPThreadFactory;
import net.shieldcommunity.nullcordx.utils.TasksUtils;

@Singleton
public class CaptchaGenerator
extends ManagerComponent {
    private final LocalScheduler localScheduler;
    private final AntiBotManagerImpl antiBotManager;
    private final CheckingFactoriesImpl checkingFactories;
    private final CaptchaDataSettings captchaDataSettings;
    private final CachedCaptchaManagerImpl cachedCaptchaManager;
    private final GenerationStateWrapper generationStateWrapper = new GenerationStateWrapper();
    private final Object lock = new Object();
    private volatile boolean generation = false;
    private volatile Thread providerThread = null;

    @Inject
    public CaptchaGenerator(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, AntiBotManagerImpl antiBotManager, CheckingFactoriesImpl checkingFactories, CaptchaDataSettings captchaDataSettings, CachedCaptchaManagerImpl cachedCaptchaManager) {
        super(logger, nullCordX, "CaptchaGenerator");
        this.localScheduler = localScheduler;
        this.antiBotManager = antiBotManager;
        this.checkingFactories = checkingFactories;
        this.captchaDataSettings = captchaDataSettings;
        this.cachedCaptchaManager = cachedCaptchaManager;
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (!this.checkingFactories.isNeedGenerateCaptcha()) {
            this.logger.log(Level.INFO, this.componentName + " disabled: Not used anywhere in the antibot settings!");
            return;
        }
        this.captchaDataSettings.load(executor);
        this.generateImages(executor, false, false);
        this.scheduleRegen();
    }

    @Override
    protected void onUnload() {
        this.generationStateWrapper.setCancelled(true);
        Thread thread = this.providerThread;
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.captchaDataSettings.isLoaded()) {
            this.captchaDataSettings.unload();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean generateImages(ForkJoinPool externalExecutor, boolean hideMessages, boolean force) {
        Object object = this.lock;
        synchronized (object) {
            if (this.generation) {
                return true;
            }
            this.generation = true;
            Thread thread = new Thread(() -> {
                CompressorThreadLocal compressorThreadLocal = new CompressorThreadLocal(ConfigSettings.IMP.PERFORMANCE.COMPRESSION.CACHED_PACKET.LEVEL);
                try {
                    this.generateCaptcha(() -> new CaptchaGenerationConditionResult(this.checkingFactories.isNeedGenerateHandCaptcha()), (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedHandCaptchaPackets(), (executor, holder) -> new HandCaptchaGenerationTask(executor, (Logger)this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getHandCaptchaData().getGroupedRenderLayers(), this.captchaDataSettings.getHandCaptchaData().getPostRenderLayers(), this.cachedCaptchaManager.getHandCaptchaSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getHandCaptchaFileCache()), HandCaptchaSettings.IMP.HAND_CAPTCHA.IMAGES_COUNT, hideMessages, force);
                    this.generateCaptcha(() -> {
                        if (this.checkingFactories.isNeedGenerateAnimatedHandCaptcha()) {
                            return new CaptchaGenerationConditionResult(true);
                        }
                        return new CaptchaGenerationConditionResult(false);
                    }, (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedAnimatedHandCaptchaPackets(), (executor, holder) -> new AnimatedHandCaptchaGenerationTask(executor, this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getAnimatedHandCaptchaData().getGroupedRenderLayers(), this.captchaDataSettings.getAnimatedHandCaptchaData().getPostRenderLayers(), this.cachedCaptchaManager.getAnimatedHandCaptchaSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getAnimatedHandCaptchaFileCache(), this.captchaDataSettings.getAnimatedHandCaptchaData().getGifGenerator(), AnimatedHandCaptchaSettings.IMP.ANIMATED_HAND_CAPTCHA.REVERSE_ANIMATION), AnimatedHandCaptchaSettings.IMP.ANIMATED_HAND_CAPTCHA.IMAGES_COUNT, () -> this.cachedCaptchaManager.loadAnimationDataForCaptcha(externalExecutor), null, hideMessages, force);
                    this.generateCaptcha(() -> new CaptchaGenerationConditionResult(this.checkingFactories.isNeedGenerateFramedCaptcha()), (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedFramedCaptchaPackets(), (executor, holder) -> new FramedCaptchaGenerationTask(executor, (Logger)this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getFramedCaptchaData().getGroupedRenderLayers(), this.captchaDataSettings.getFramedCaptchaData().getPostRenderLayers(), this.cachedCaptchaManager.getFramedCaptchaSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getFramedCaptchaFileCache()), FramedCaptchaSettings.IMP.FRAMED_CAPTCHA.IMAGES_COUNT, hideMessages, force);
                    this.generateCaptcha(() -> {
                        if (this.checkingFactories.isNeedGenerateAnimatedFramedCaptcha()) {
                            return new CaptchaGenerationConditionResult(true);
                        }
                        return new CaptchaGenerationConditionResult(false);
                    }, (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedAnimatedFramedCaptchaPackets(), (executor, holder) -> new AnimatedFramedCaptchaGenerationTask(executor, this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getAnimatedFramedCaptchaData().getGroupedRenderLayers(), this.captchaDataSettings.getAnimatedFramedCaptchaData().getPostRenderLayers(), this.cachedCaptchaManager.getAnimatedFramedCaptchaSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getAnimatedFramedCaptchaFileCache(), this.captchaDataSettings.getAnimatedFramedCaptchaData().getGifGenerator(), AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.REVERSE_ANIMATION), AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.IMAGES_COUNT, () -> this.cachedCaptchaManager.loadAnimationDataForCaptcha(externalExecutor), null, hideMessages, force);
                    this.generateCaptcha(() -> new CaptchaGenerationConditionResult(this.checkingFactories.isNeedGenerateFramedPuzzle()), (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedFramedPuzzlePackets(), (executor, holder) -> new FramedPuzzleGenerationTask(executor, (Logger)this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getFramedPuzzleData().getGroupedRenderLayers(), this.captchaDataSettings.getFramedPuzzleData().getPostRenderLayers(), this.cachedCaptchaManager.getFramedPuzzleSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getFramedPuzzleFileCache()), FramedPuzzleSettings.IMP.FRAMED_PUZZLE.IMAGES_COUNT, hideMessages, force);
                    this.generateCaptcha(() -> {
                        if (this.checkingFactories.isNeedGenerateAnimatedFramedPuzzle()) {
                            return new CaptchaGenerationConditionResult(true);
                        }
                        return new CaptchaGenerationConditionResult(false);
                    }, (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedAnimatedFramedPuzzlePackets(), (executor, holder) -> new AnimatedFramedPuzzleGenerationTask(executor, this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), this.captchaDataSettings.getAnimatedFramedPuzzleData().getGroupedRenderLayers(), this.captchaDataSettings.getAnimatedFramedPuzzleData().getPostRenderLayers(), this.cachedCaptchaManager.getAnimatedFramedPuzzleSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getAnimatedFramedPuzzleFileCache(), this.captchaDataSettings.getAnimatedFramedPuzzleData().getGifGenerator(), AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.REVERSE_ANIMATION), AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.IMAGES_COUNT, () -> this.cachedCaptchaManager.loadAnimationDataForCaptcha(externalExecutor), null, hideMessages, force);
                    this.generateCaptcha(() -> new CaptchaGenerationConditionResult(this.checkingFactories.isNeedGeneratePickCaptcha()), (CachedCaptchaPacketsImpl)this.cachedCaptchaManager.getCachedPickCaptchaPackets(), (executor, holder) -> new PickCaptchaGenerationTask(executor, this.logger, this.nullCordX, this.generationStateWrapper, compressorThreadLocal, force, holder, this.captchaDataSettings.getColors(), null, this.captchaDataSettings.getPickCaptchaData().getPostRenderLayers(), this.cachedCaptchaManager.getPickCaptchaSettingsHash(), this.captchaDataSettings.getCaptchaFileCacheType().getPickCaptchaFileCache(), this.captchaDataSettings.getForPickCaptchaGroupedImages()), PickCaptchaSettings.IMP.PICK_CAPTCHA.IMAGES_COUNT, () -> {
                        this.captchaDataSettings.loadGroupedImages(this.generationStateWrapper);
                        this.nullCordX.getCachedPacketManager().executePostTasks();
                    }, this.captchaDataSettings::unloadGroupedImages, hideMessages, force);
                }
                catch (Throwable e) {
                    this.logger.log(Level.SEVERE, "Failed to generate captcha", e);
                }
                finally {
                    try {
                        compressorThreadLocal.closeCompressors();
                        MapPalette.unloadPaletteColors();
                    }
                    finally {
                        this.generationStateWrapper.setCancelled(false);
                        this.generation = false;
                        this.providerThread = null;
                    }
                }
            });
            thread.setName("CaptchaGenerationProvider");
            thread.setPriority(1);
            this.providerThread = thread;
            thread.start();
            return false;
        }
    }

    private <T extends ByteBufPacket> void generateCaptcha(CaptchaGenerationPreCondition captchaGenerationPreCondition, CachedCaptchaPacketsImpl<T> cachedCaptchaPackets, CaptchaGenerationTaskFactory<T> captchaGenerationTaskFactory, int captchaCount, boolean hideMessages, boolean force) {
        this.generateCaptcha(captchaGenerationPreCondition, cachedCaptchaPackets, captchaGenerationTaskFactory, captchaCount, null, null, hideMessages, force);
    }

    private <T extends ByteBufPacket> void generateCaptcha(CaptchaGenerationPreCondition captchaGenerationPreCondition, CachedCaptchaPacketsImpl<T> cachedCaptchaPackets, CaptchaGenerationTaskFactory<T> captchaGenerationTaskFactory, int captchaCount, Runnable preTask, Runnable postTask, boolean hideMessages, boolean force) {
        List<CaptchaHolderImpl<T>> dirtyHolders;
        int captchaToGenerateCount;
        CaptchaGenerationConditionResult conditionResult = captchaGenerationPreCondition.checkCondition();
        if (!conditionResult.isAllow()) {
            if (conditionResult.getReason() != null) {
                this.logger.log(Level.SEVERE, "Unable to start generating " + cachedCaptchaPackets.getName() + ": " + conditionResult.getReason());
            }
            return;
        }
        if (this.generationStateWrapper.isCancelled()) {
            this.logger.log(Level.WARNING, "Generation for captcha " + cachedCaptchaPackets.getName() + " was cancelled.");
            return;
        }
        CaptchaHolderImpl<T>[] currentCaptchaHolders = cachedCaptchaPackets.getCaptchas();
        if (captchaCount <= 0) {
            captchaCount = 1;
        }
        if (currentCaptchaHolders.length != captchaCount || force) {
            this.nullCordX.sendDebugLogIfEnabled("The new number (" + captchaCount + ") of captcha is different from the old one (" + currentCaptchaHolders.length + ")! Rebuilding the collection for " + cachedCaptchaPackets.getName());
            cachedCaptchaPackets.clear();
            CaptchaHolderImpl[] newCaptchaHolders = new CaptchaHolderImpl[captchaCount];
            for (int i = 0; i < captchaCount; ++i) {
                newCaptchaHolders[i] = new CaptchaHolderImpl(i);
            }
            cachedCaptchaPackets.setCaptchas(newCaptchaHolders);
            currentCaptchaHolders = newCaptchaHolders;
        }
        if ((captchaToGenerateCount = (dirtyHolders = CaptchaGenerator.findDirtyCaptcha(currentCaptchaHolders)).size()) == 0) {
            if (!hideMessages) {
                this.logger.log(Level.INFO, "No dirty " + cachedCaptchaPackets.getName() + " found for regeneration!");
            }
            return;
        }
        if (!hideMessages) {
            this.logger.log(Level.INFO, "Found " + captchaToGenerateCount + " dirty " + cachedCaptchaPackets.getName() + " to regenerate!");
            this.logger.log(Level.INFO, BungeeCord.getInstance().isEnabled() ? "Async " + cachedCaptchaPackets.getName() + " generation started." : "Async " + cachedCaptchaPackets.getName() + " generation will continue in parallel with NullCordX loading.");
        }
        if (preTask != null) {
            preTask.run();
        }
        MapPalette.loadPaletteColors();
        int threads = CaptchaSettings.IMP.CAPTCHA.THREADS_FOR_GENERATION;
        if (threads < 0) {
            threads = Runtime.getRuntime().availableProcessors();
        }
        ForkJoinPool executor = new ForkJoinPool(threads, new CustomFJPThreadFactory("CaptchaGenerationWorker", 1), null, false);
        ArrayList<CaptchaGenerationTask<T>> tasks = new ArrayList<CaptchaGenerationTask<T>>();
        for (CaptchaHolderImpl<T> captchaHolderImpl : dirtyHolders) {
            tasks.add(captchaGenerationTaskFactory.createCaptchaGenerationTask(executor, captchaHolderImpl));
        }
        for (CaptchaGenerationTask captchaGenerationTask : tasks) {
            executor.execute(captchaGenerationTask);
        }
        long start = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        long oldCaptchaCount = 0L;
        while (executor.getActiveThreadCount() != 0) {
            if (System.currentTimeMillis() - time >= 1000L) {
                time = System.currentTimeMillis();
                long waitTasksCount = TasksUtils.findWaitTasksCount(tasks);
                long currentCount = (long)captchaToGenerateCount - waitTasksCount;
                long perSec = currentCount - oldCaptchaCount;
                oldCaptchaCount = currentCount;
                if (BungeeCord.getInstance().isEnabled() && !hideMessages) {
                    this.logger.log(Level.INFO, "Async " + cachedCaptchaPackets.getName() + " generation [" + ((long)captchaToGenerateCount - waitTasksCount) + "/" + captchaToGenerateCount + "/+" + perSec + " cps]");
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex1) {
                this.logger.log(Level.WARNING, "Failed to generate " + cachedCaptchaPackets.getName(), ex1);
                return;
            }
        }
        try {
            executor.shutdown();
            executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
        }
        if (postTask != null) {
            postTask.run();
        }
        if (CaptchaSettings.IMP.CAPTCHA.CALL_GC_AFTER_GENERATION) {
            System.gc();
        }
        if (!hideMessages) {
            this.logger.log(Level.INFO, cachedCaptchaPackets.getName() + " generated in " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    private void scheduleRegen() {
        int captchaRegenTime = CaptchaSettings.IMP.CAPTCHA.AUTO_REGENERATE_TIME;
        if (captchaRegenTime > 0) {
            this.localScheduler.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    ForkJoinPool executor = CaptchaGenerator.this.nullCordX.getLoadingExecutor();
                    if (executor != null) {
                        CaptchaGenerator.this.generateImages(executor, CaptchaSettings.IMP.CAPTCHA.AUTO_REGENERATE_HIDE_MESSAGES, false);
                    }
                }
            }, captchaRegenTime, captchaRegenTime, TimeUnit.MINUTES);
        }
    }

    private static <T extends ByteBufPacket> List<CaptchaHolderImpl<T>> findDirtyCaptcha(CaptchaHolderImpl<T>[] holders) {
        ArrayList<CaptchaHolderImpl<T>> findDirtyHolders = new ArrayList<CaptchaHolderImpl<T>>();
        for (CaptchaHolderImpl<T> holder : holders) {
            if (!holder.isDirty() || System.currentTimeMillis() - holder.getLastUsed() <= (long)CaptchaSettings.IMP.CAPTCHA.MAX_DIRTY_CAPTCHA_TIME) continue;
            findDirtyHolders.add(holder);
        }
        return findDirtyHolders;
    }

    public LocalScheduler getLocalScheduler() {
        return this.localScheduler;
    }

    public AntiBotManagerImpl getAntiBotManager() {
        return this.antiBotManager;
    }

    public CheckingFactoriesImpl getCheckingFactories() {
        return this.checkingFactories;
    }

    public CaptchaDataSettings getCaptchaDataSettings() {
        return this.captchaDataSettings;
    }

    public CachedCaptchaManagerImpl getCachedCaptchaManager() {
        return this.cachedCaptchaManager;
    }

    public GenerationStateWrapper getGenerationStateWrapper() {
        return this.generationStateWrapper;
    }

    public Object getLock() {
        return this.lock;
    }

    public boolean isGeneration() {
        return this.generation;
    }

    public Thread getProviderThread() {
        return this.providerThread;
    }
}

