/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.BufferedGif;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.config.captcha.ImageOffset;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class SimpleGifGenerator
implements GifGenerator {
    private final List<ResizedGif> resizedGifs;
    private final ImageOffset imageOffset;
    private final int framesCount;

    @Override
    public BufferedGif generate(BufferedImage sourceImage, int color, Random random, RenderSession renderSession) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        BufferedGif gif = null;
        if (this.resizedGifs != null && !this.resizedGifs.isEmpty()) {
            ResizedGif randomResizedGif = this.resizedGifs.get(random.nextInt(this.resizedGifs.size()));
            gif = randomResizedGif.getStorage().getDataByRaCWithPixels(width, height);
        }
        int framesCount = gif != null ? gif.getFrames().size() : this.framesCount;
        ArrayList<BufferedImage> frames = new ArrayList<BufferedImage>();
        int animationXOffset = 0;
        int animationYOffset = 0;
        int animationIter = 1;
        int animationXDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_X_MULTIPLICATION() : -this.imageOffset.getANIMATION_X_MULTIPLICATION();
        int animationYDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_Y_MULTIPLICATION() : -this.imageOffset.getANIMATION_Y_MULTIPLICATION();
        for (int i = 0; i < framesCount; ++i) {
            BufferedImage newFrame;
            if (gif != null) {
                BufferedImage background = ImageUtils.copyImage(gif.getFrames().get(i));
                Graphics2D g2d = background.createGraphics();
                g2d.drawImage((Image)sourceImage, 0, 0, null);
                g2d.dispose();
                newFrame = background;
            } else {
                newFrame = ImageUtils.copyImage(sourceImage);
            }
            int[] destArray = ((DataBufferInt)newFrame.getRaster().getDataBuffer()).getData();
            if (this.imageOffset.isENABLED()) {
                int[] copy = Arrays.copyOf(destArray, destArray.length);
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        int yOffset;
                        int xOffset = animationXOffset + x;
                        if (xOffset < 0) {
                            int value = Math.abs(xOffset);
                            xOffset = value < width ? width - value : value - width;
                        }
                        if ((yOffset = animationYOffset + y) < 0) {
                            int value = Math.abs(yOffset);
                            yOffset = value < height ? height - value : value - height;
                        }
                        int localX = xOffset % width;
                        int localY = yOffset % height;
                        destArray[localY * width + localX] = copy[y * width + x];
                    }
                }
                if (animationIter >= this.imageOffset.getANIMATION_ITERATION_CHANGE()) {
                    animationIter = 1;
                    animationXDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_X_MULTIPLICATION() : -this.imageOffset.getANIMATION_X_MULTIPLICATION();
                    animationYDirection = random.nextBoolean() ? this.imageOffset.getANIMATION_Y_MULTIPLICATION() : -this.imageOffset.getANIMATION_Y_MULTIPLICATION();
                } else {
                    ++animationIter;
                }
                animationXOffset += animationXDirection;
                animationYOffset += animationYDirection;
            }
            frames.add(newFrame);
        }
        return new BufferedGif(frames);
    }

    public SimpleGifGenerator(List<ResizedGif> resizedGifs, ImageOffset imageOffset, int framesCount) {
        this.resizedGifs = resizedGifs;
        this.imageOffset = imageOffset;
        this.framesCount = framesCount;
    }
}

