/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter;

import com.google.common.io.ByteStreams;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.EnumMap;
import java.util.Map;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.ColorIndexWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.IndexesVersion;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.PerVersionMapBuffer;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.PerVersionMapData;
import net.shieldcommunity.nullcordx.protocol.ProtocolMapData;

public final class MapPalette {
    private static final Map<IndexesVersion, ColorIndexWrapper> INDEXES = new EnumMap<IndexesVersion, ColorIndexWrapper>(IndexesVersion.class);
    private static final Int2ObjectMap<ColorIndexWrapper> INDEXES_BY_VERSION = new Int2ObjectOpenHashMap<ColorIndexWrapper>();
    private static final ThreadLocal<PerVersionMapBuffer> PER_VERSION_RGB_BUFFER = ThreadLocal.withInitial(() -> new PerVersionMapBuffer(128, 128, INDEXES, INDEXES_BY_VERSION));
    private static boolean loadedMapPalette = false;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPaletteColors() {
        Object object = LOCK;
        synchronized (object) {
            if (loadedMapPalette) {
                return;
            }
            INDEXES_BY_VERSION.clear();
            block13: for (int version : ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED) {
                for (ColorIndexWrapper colorIndexWrapper : INDEXES.values()) {
                    IndexesVersion indexesVersion = colorIndexWrapper.getIndexesVersion();
                    if (!indexesVersion.getPredicate().test(version)) continue;
                    colorIndexWrapper.setCanBeLoaded(true);
                    INDEXES_BY_VERSION.put(version, colorIndexWrapper);
                    continue block13;
                }
            }
            NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
            nullCordX.sendDebugLogIfEnabled("Loading map palettes...");
            long start = System.currentTimeMillis();
            try {
                for (ColorIndexWrapper colorIndexWrapper : INDEXES.values()) {
                    if (!colorIndexWrapper.isCanBeLoaded()) continue;
                    nullCordX.sendDebugLogIfEnabled("Loading map palette " + colorIndexWrapper.getIndexesVersion().name());
                    IndexesVersion indexesVersion = colorIndexWrapper.getIndexesVersion();
                    if (CaptchaSettings.IMP.CAPTCHA.USE_ONLY_1_8_PALETTE) {
                        indexesVersion = IndexesVersion.V1_8;
                    }
                    InputStream is = MapPalette.class.getClassLoader().getResourceAsStream("map_indexes_" + indexesVersion.getName());
                    try {
                        colorIndexWrapper.setIndexes(ByteStreams.toByteArray(is));
                    }
                    finally {
                        if (is == null) continue;
                        is.close();
                    }
                }
                long l = System.currentTimeMillis();
                nullCordX.sendDebugLogIfEnabled("Map palettes loaded in " + (l - start) + "ms");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                loadedMapPalette = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unloadPaletteColors() {
        Object object = LOCK;
        synchronized (object) {
            if (!loadedMapPalette) {
                return;
            }
            if (CaptchaSettings.IMP.CAPTCHA.ALWAYS_LOAD_MAP_PALETTE) {
                return;
            }
            for (ColorIndexWrapper colorIndexWrapper : INDEXES.values()) {
                colorIndexWrapper.setIndexes(null);
                colorIndexWrapper.setCanBeLoaded(false);
            }
            BungeeCord.getInstance().getNullCordX().sendDebugLogIfEnabled("Map palette unloaded!");
            loadedMapPalette = false;
        }
    }

    public static ProtocolMapData imageToMapData(BufferedImage image) {
        PerVersionMapBuffer perVersionMapBuffer = MapPalette.imageToBytes(image);
        return new ProtocolMapData(128, 128, 0, 0, new PerVersionMapData(perVersionMapBuffer.getBuffersByVersion()));
    }

    public static PerVersionMapBuffer imageToBytes(BufferedImage image) {
        PerVersionMapBuffer buffer = PER_VERSION_RGB_BUFFER.get();
        buffer.draw(image);
        return buffer;
    }

    public static Color[] createColorsWithoutTransparentFor_1_17() {
        Color[] baseColors = new Color[]{new Color(127, 178, 56), new Color(247, 233, 163), new Color(199, 199, 199), new Color(255, 0, 0), new Color(160, 160, 255), new Color(167, 167, 167), new Color(0, 124, 0), new Color(255, 255, 255), new Color(164, 168, 184), new Color(151, 109, 77), new Color(112, 112, 112), new Color(64, 64, 255), new Color(143, 119, 72), new Color(255, 252, 245), new Color(216, 127, 51), new Color(178, 76, 216), new Color(102, 153, 216), new Color(229, 229, 51), new Color(127, 204, 25), new Color(242, 127, 165), new Color(76, 76, 76), new Color(153, 153, 153), new Color(76, 127, 153), new Color(127, 63, 178), new Color(51, 76, 178), new Color(102, 76, 51), new Color(102, 127, 51), new Color(153, 51, 51), new Color(25, 25, 25), new Color(250, 238, 77), new Color(92, 219, 213), new Color(74, 128, 255), new Color(0, 217, 58), new Color(129, 86, 49), new Color(112, 2, 0), new Color(209, 177, 161), new Color(159, 82, 36), new Color(149, 87, 108), new Color(112, 108, 138), new Color(186, 133, 36), new Color(103, 117, 53), new Color(160, 77, 78), new Color(57, 41, 35), new Color(135, 107, 98), new Color(87, 92, 92), new Color(122, 73, 88), new Color(76, 62, 92), new Color(76, 50, 35), new Color(76, 82, 42), new Color(142, 60, 46), new Color(37, 22, 16), new Color(189, 48, 49), new Color(148, 63, 97), new Color(92, 25, 29), new Color(22, 126, 134), new Color(58, 142, 140), new Color(86, 44, 62), new Color(20, 180, 133), new Color(100, 100, 100), new Color(216, 175, 147), new Color(127, 167, 150)};
        Color[] mapColors = new Color[baseColors.length * 4];
        for (int i = 0; i < baseColors.length; ++i) {
            Color bc = baseColors[i];
            mapColors[i * 4 + 0] = new Color((int)((double)bc.getRed() * 180.0 / 255.0 + 0.5), (int)((double)bc.getGreen() * 180.0 / 255.0 + 0.5), (int)((double)bc.getBlue() * 180.0 / 255.0 + 0.5), bc.getAlpha());
            mapColors[i * 4 + 1] = new Color((int)((double)bc.getRed() * 220.0 / 255.0 + 0.5), (int)((double)bc.getGreen() * 220.0 / 255.0 + 0.5), (int)((double)bc.getBlue() * 220.0 / 255.0 + 0.5), bc.getAlpha());
            mapColors[i * 4 + 2] = bc;
            mapColors[i * 4 + 3] = new Color((int)((double)bc.getRed() * 135.0 / 255.0 + 0.5), (int)((double)bc.getGreen() * 135.0 / 255.0 + 0.5), (int)((double)bc.getBlue() * 135.0 / 255.0 + 0.5), bc.getAlpha());
        }
        return mapColors;
    }

    private MapPalette() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (IndexesVersion indexesVersion : IndexesVersion.values()) {
            INDEXES.put(indexesVersion, new ColorIndexWrapper(indexesVersion));
        }
    }
}

