/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.AnswerGeneratorFactory;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;

public class RenderLayerAnswer
extends AbstractRenderLayer {
    private final AnswerGeneratorFactory answerGeneratorFactory;
    private AbstractCaptchaAnswerGenerator answerGenerator = null;
    private boolean lazyLoaded = false;

    public RenderLayerAnswer(String name, AnswerGeneratorFactory answerGeneratorFactory) {
        super(name);
        this.answerGeneratorFactory = answerGeneratorFactory;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        List<RenderedFont> renderedFonts;
        if (this.answerGenerator == null) {
            return image;
        }
        AbstractCaptchaAnswerGenerator answerGenerator = this.answerGenerator;
        answerGenerator = answerGenerator.createCopy();
        answerGenerator.generateAnswer(random);
        FontListData fontData = answerGenerator.getFonts().getDataByRaCWithPixels(image.getWidth(), image.getHeight());
        if (fontData != null && !(renderedFonts = fontData.getRenderedFonts()).isEmpty()) {
            RenderedFont randomRenderedFont = renderedFonts.get(random.nextInt(renderedFonts.size()));
            answerGenerator.draw(color, randomRenderedFont, image, image.getWidth(), image.getHeight(), random);
            renderSession.setAnswer(answerGenerator);
        }
        return image;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        this.answerGenerator = this.answerGeneratorFactory.create();
        this.lazyLoaded = true;
    }

    public String toString() {
        return "RenderLayerAnswer(answerGenerator=" + this.getAnswerGenerator() + ")";
    }

    public AnswerGeneratorFactory getAnswerGeneratorFactory() {
        return this.answerGeneratorFactory;
    }

    public AbstractCaptchaAnswerGenerator getAnswerGenerator() {
        return this.answerGenerator;
    }

    public boolean isLazyLoaded() {
        return this.lazyLoaded;
    }
}

