/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerGradient
extends AbstractRenderLayer {
    private final boolean ignoreTransparent;
    private final List<Color> colors;
    private final int minGradientSize;
    private final int maxGradientSize;

    public RenderLayerGradient(String name, boolean ignoreTransparent, List<Color> colors, int minGradientSize, int maxGradientSize) {
        super(name);
        this.ignoreTransparent = ignoreTransparent;
        this.colors = Collections.unmodifiableList(colors);
        this.minGradientSize = minGradientSize;
        this.maxGradientSize = maxGradientSize;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        float singleFraction;
        int width = image.getWidth();
        int height = image.getHeight();
        int randomLength = random.nextInt(this.maxGradientSize + 1);
        if (randomLength < this.minGradientSize) {
            randomLength = this.maxGradientSize;
        }
        Color[] randomColorLength = new Color[randomLength];
        float[] fractions = new float[randomLength];
        float currentFraction = singleFraction = 1.0f / (float)randomLength;
        for (int i = 0; i < randomLength; ++i) {
            randomColorLength[i] = this.colors.get(random.nextInt(this.colors.size()));
            fractions[i] = currentFraction;
            currentFraction += singleFraction;
        }
        int rotate = random.nextInt(height * 2);
        BufferedImage newImage = new BufferedImage(width, height, image.getType());
        LinearGradientPaint lgrPaint = new LinearGradientPaint(0.0f, rotate, width, height, fractions, randomColorLength);
        Graphics2D g2 = newImage.createGraphics();
        g2.setPaint(lgrPaint);
        g2.fillRect(0, 0, width, height);
        g2.dispose();
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)newImage.getRaster().getDataBuffer()).getData();
        ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, this.ignoreTransparent);
        return image;
    }

    public String toString() {
        return "RenderLayerGradient(ignoreTransparent=" + this.ignoreTransparent + ", minGradientSize=" + this.minGradientSize + ", maxGradientSize=" + this.maxGradientSize + ")";
    }
}

