/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerGroups
extends AbstractRenderLayer {
    private final List<RenderLayer> renderLayers;
    private boolean lazyLoaded = false;

    public RenderLayerGroups(String name, List<RenderLayer> renderLayers) {
        super(name);
        this.renderLayers = renderLayers;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (this.renderLayers == null || this.renderLayers.isEmpty()) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage renderedImage = RenderLayer.renderCurrentLayers(new BufferedImage(image.getWidth(), image.getHeight(), 2), this.renderLayers, color, random, renderSession);
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)renderedImage.getRaster().getDataBuffer()).getData();
        ImageUtils.drawRawNewImageToOld(width, height, destArray, srcArray, false);
        return image;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        if (this.renderLayers != null) {
            for (RenderLayer renderLayer : this.renderLayers) {
                renderLayer.lazyLoad(executor);
            }
        }
        this.lazyLoaded = true;
    }

    public String toString() {
        return "RenderLayerGroups()";
    }
}

