/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;

public class RenderLayerRandom
extends AbstractRenderLayer {
    private final List<RenderLayer> renderLayers;
    private boolean lazyLoaded = false;

    public RenderLayerRandom(String name, List<RenderLayer> renderLayers) {
        super(name);
        this.renderLayers = renderLayers;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (this.renderLayers == null || this.renderLayers.isEmpty()) {
            return image;
        }
        RenderLayer randomLayer = this.renderLayers.get(random.nextInt(this.renderLayers.size()));
        return randomLayer.drawLayer(image, color, random, renderSession);
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        if (this.renderLayers != null) {
            for (RenderLayer renderLayer : this.renderLayers) {
                renderLayer.lazyLoad(executor);
            }
        }
        this.lazyLoaded = true;
    }

    public String toString() {
        return "RenderLayerRandom()";
    }
}

