/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Random;
import java.util.concurrent.ForkJoinPool;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;

public class RenderLayerRipple
extends AbstractRenderLayer {
    private final double width;
    private final double height;
    private AxisConfig vertical;
    private AxisConfig horizontal;
    private boolean lazyLoaded = false;

    public RenderLayerRipple(String name, double width, double height) {
        super(name);
        this.width = width;
        this.height = height;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (this.vertical == null || this.horizontal == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        BufferedImage dest = new BufferedImage(width, height, 2);
        int[] verticalDelta = this.calcDeltaArray(this.vertical, width, random);
        int[] horizontalDelta = this.calcDeltaArray(this.horizontal, height, random);
        int[] destArray = ((DataBufferInt)dest.getRaster().getDataBuffer()).getData();
        int[] srcArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int ny = (y + verticalDelta[x] + height) % height;
                int nx = (x + horizontalDelta[ny] + width) % width;
                destArray[ny * width + nx] = srcArray[y * width + x];
            }
        }
        return dest;
    }

    @Override
    public void lazyLoad(ForkJoinPool executor) {
        if (this.lazyLoaded) {
            return;
        }
        this.vertical = new AxisConfig(rnd -> rnd.nextDouble() * 2.0 * Math.PI, rnd -> (1.0 + rnd.nextDouble() * 2.0) * Math.PI, size -> (double)size / this.height);
        this.horizontal = new AxisConfig(rnd -> rnd.nextDouble() * 2.0 * Math.PI, rnd -> (2.0 + rnd.nextDouble() * 2.0) * Math.PI, size -> (double)size / this.width);
        this.lazyLoaded = true;
    }

    protected int[] calcDeltaArray(AxisConfig axisConfig, int num, Random random) {
        int[] delta = new int[num];
        double start = axisConfig.getStart(random);
        double period = axisConfig.getLength(random) / (double)num;
        double amplitude = axisConfig.getAmplitude().createValue(num);
        for (int i = 0; i < num; ++i) {
            delta[i] = (int)Math.round(amplitude * Math.sin(start + (double)i * period));
        }
        return delta;
    }

    public String toString() {
        return "RenderLayerRipple(width=" + this.width + ", height=" + this.height + ", vertical=" + this.vertical + ", horizontal=" + this.horizontal + ")";
    }

    public static class AxisConfig {
        private final AxisConfigHolder start;
        private final AxisConfigHolder length;
        private final AmplitudeConfigHolder amplitude;

        public AxisConfig(AxisConfigHolder start, AxisConfigHolder length, AmplitudeConfigHolder amplitude) {
            this.start = start;
            this.length = length;
            this.amplitude = amplitude;
        }

        public double getStart(Random random) {
            return this.normalize(this.start.createValue(random), 2);
        }

        public double getLength(Random random) {
            return this.normalize(this.length.createValue(random), 4);
        }

        private double normalize(double a, int multi) {
            double piMulti = (double)multi * Math.PI;
            a = Math.abs(a);
            double d = Math.floor(a / piMulti);
            return a - d * piMulti;
        }

        public String toString() {
            return "RenderLayerRipple.AxisConfig(start=" + this.start + ", length=" + this.length + ", amplitude=" + this.getAmplitude() + ")";
        }

        public AmplitudeConfigHolder getAmplitude() {
            return this.amplitude;
        }

        public static interface AxisConfigHolder {
            public double createValue(Random var1);
        }

        public static interface AmplitudeConfigHolder {
            public double createValue(int var1);
        }
    }
}

