/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.AbstractRenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderSession;
import net.shieldcommunity.nullcordx.utils.ImageUtils;

public class RenderLayerRotation
extends AbstractRenderLayer {
    private final boolean framed;
    private final int count;
    private final boolean exact;

    public RenderLayerRotation(String name, boolean framed, int count, boolean exact) {
        super(name);
        this.framed = framed;
        this.count = count;
        this.exact = exact;
    }

    @Override
    public BufferedImage drawLayer(BufferedImage image, Color color, Random random, RenderSession renderSession) {
        if (this.framed) {
            int rows = MapCanvasConstants.calculateSizeModification(image.getWidth());
            int columns = MapCanvasConstants.calculateSizeModification(image.getHeight());
            BufferedImage[] images = ImageUtils.splitImage(image, rows, columns);
            for (int i = this.count; i > 0; --i) {
                int randomFrameIndex = random.nextInt(images.length);
                BufferedImage randomFrame = images[randomFrameIndex];
                int randomDegrees = RenderLayerRotation.createDegrees(this.exact, random);
                images[randomFrameIndex] = ImageUtils.rotateImageByDegrees(randomFrame, randomDegrees);
            }
            return ImageUtils.restoreSplitImage(Arrays.asList(images), rows, columns);
        }
        int randomDegrees = RenderLayerRotation.createDegrees(this.exact, random);
        return ImageUtils.rotateImageByDegrees(image, randomDegrees);
    }

    private static int createDegrees(boolean exact, Random random) {
        if (exact) {
            return 90 * (random.nextInt(3) + 1);
        }
        return random.nextInt(360);
    }

    public String toString() {
        return "RenderLayerRotation(framed=" + this.framed + ", count=" + this.count + ", exact=" + this.exact + ")";
    }
}

