/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings;

import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyph;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyphListData;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.objects.ObjectSet;
import net.shieldcommunity.nullcordx.utils.IOUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FontCacheType {
    BIN{

        @Override
        public String getCacheFileName(String hash) {
            return hash + ".bin";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FontListData loadFontFromCache(String fileName, File file) throws Exception {
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeBytes(bytes);
                FontListData fontListData = FontCacheType.load(fileName, buf);
                return fontListData;
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveFontToCache(FontListData fontListData, File file) throws Exception {
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                FontCacheType.save(buf, fontListData);
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                    int size = buf.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(buf.readByte());
                    }
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
        }
    }
    ,
    BINZ{

        @Override
        public String getCacheFileName(String hash) {
            return hash + ".binz";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FontListData loadFontFromCache(String fileName, File file) throws Exception {
            ByteBuf out;
            byte[] bytes = Files.readAllBytes(file.toPath());
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                buf.writeBytes(bytes);
                out = IOUtils.decompress(buf);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
            if (out == null) {
                return new FontListData(fileName, Collections.emptyList());
            }
            try {
                FontListData fontListData = FontCacheType.load(fileName, out);
                return fontListData;
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveFontToCache(FontListData fontListData, File file) throws Exception {
            ByteBuf out;
            ByteBuf buf = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                FontCacheType.save(buf, fontListData);
                out = IOUtils.compress(buf);
            }
            finally {
                CachedPacket.releaseByteBufSafe(buf);
            }
            if (out == null) {
                return;
            }
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
                int size = out.readableBytes();
                for (int i = 0; i < size; ++i) {
                    outputStream.write(out.readByte());
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(out);
            }
        }
    }
    ,
    NONE{

        @Override
        public String getCacheFileName(String hash) {
            return null;
        }

        @Override
        public FontListData loadFontFromCache(String fileName, File file) throws Exception {
            return null;
        }

        @Override
        public void saveFontToCache(FontListData fontListData, File file) throws Exception {
        }
    };


    public abstract String getCacheFileName(String var1);

    public abstract FontListData loadFontFromCache(String var1, File var2) throws Exception;

    public abstract void saveFontToCache(FontListData var1, File var2) throws Exception;

    private static void writeBitSet(int width, int height, BitSet data, ByteBuf out) {
        int size = width * height;
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeBoolean(data.get(i));
        }
    }

    private static BitSet readBitSet(ByteBuf in) {
        int size = in.readInt();
        BitSet bitSet = new BitSet(size);
        for (int i = 0; i < size; ++i) {
            if (!in.readBoolean()) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private static FontListData load(String fileName, ByteBuf buf) {
        ArrayList<RenderedFont> renderedFontList = new ArrayList<RenderedFont>();
        int renderedFontsSize = buf.readInt();
        for (int i = 0; i < renderedFontsSize; ++i) {
            int renderedGlyphListDataSize = buf.readInt();
            Int2ObjectOpenHashMap<RenderedGlyphListData> renderedGlyphListDataInt2ObjectMap = new Int2ObjectOpenHashMap<RenderedGlyphListData>();
            for (int j = 0; j < renderedGlyphListDataSize; ++j) {
                char symbol = (char)buf.readInt();
                ArrayList<RenderedGlyph> glyphs = new ArrayList<RenderedGlyph>();
                int glyphsSize = buf.readInt();
                for (int k = 0; k < glyphsSize; ++k) {
                    int width = buf.readInt();
                    int height = buf.readInt();
                    BitSet data = FontCacheType.readBitSet(buf);
                    glyphs.add(new RenderedGlyph(symbol, data, width, height));
                }
                renderedGlyphListDataInt2ObjectMap.put(symbol, new RenderedGlyphListData(symbol, glyphs));
            }
            renderedFontList.add(new RenderedFont(renderedGlyphListDataInt2ObjectMap));
        }
        if (buf.isReadable()) {
            throw new IllegalStateException("Font larger than expected. Extra bytes: " + buf.readableBytes());
        }
        return new FontListData(fileName, renderedFontList);
    }

    private static void save(ByteBuf buf, FontListData fontListData) {
        List<RenderedFont> renderedFontList = fontListData.getRenderedFonts();
        buf.writeInt(renderedFontList.size());
        for (RenderedFont renderedFont : renderedFontList) {
            ObjectSet<Int2ObjectMap.Entry<RenderedGlyphListData>> entries = renderedFont.getCharToGlyphs().int2ObjectEntrySet();
            buf.writeInt(entries.size());
            for (Int2ObjectMap.Entry entry : entries) {
                buf.writeInt(entry.getKey());
                RenderedGlyphListData renderedGlyphListData = (RenderedGlyphListData)entry.getValue();
                List<RenderedGlyph> glyphs = renderedGlyphListData.getData();
                buf.writeInt(glyphs.size());
                for (RenderedGlyph renderedGlyph : glyphs) {
                    int width = renderedGlyph.getWidth();
                    int height = renderedGlyph.getHeight();
                    BitSet data = renderedGlyph.getData();
                    buf.writeInt(width);
                    buf.writeInt(height);
                    FontCacheType.writeBitSet(width, height, data, buf);
                }
            }
        }
    }
}

