/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.settings.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.GlowingCircleGifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.gifgenerator.SimpleGifGenerator;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.CaptchaDataSettings;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.data.CaptchaData;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.CacheCleanupUtils;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedGif;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedPuzzleSettings;

public class AnimatedFramedPuzzleData
implements CaptchaData {
    private List<ResizedGif> animatedCaptchaGif = new ArrayList<ResizedGif>();
    private GifGenerator gifGenerator = null;
    private final List<RenderLayer> groupedRenderLayers = new ArrayList<RenderLayer>();
    private final List<RenderLayer> postRenderLayers = new ArrayList<RenderLayer>();

    @Override
    public void load(CheckingFactoriesImpl checkingFactories, CaptchaDataSettings captchaDataSettings, Map<String, RenderLayer> renderLayerTemplates, ForkJoinPool executor, NullCordXImpl nullCordX) {
        if (checkingFactories.isNeedGenerateAnimatedFramedPuzzle()) {
            this.animatedCaptchaGif = captchaDataSettings.loadGifs(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.GIFS_PATH, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMinRow(), AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMaxRow(), AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMinColumn(), AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAME_SIZES.getMaxColumn());
            HashSet<String> currentHashed = new HashSet<String>();
            for (ResizedGif resizedGif : this.animatedCaptchaGif) {
                currentHashed.add(resizedGif.getChecksum());
            }
            CacheCleanupUtils.doCleanup(nullCordX.getLogger(), CaptchaDataSettings.GLOBAL_GIFS_CACHE_DIRECTORY, currentHashed, (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached gif files."));
            nullCordX.sendDebugLogIfEnabled("Loaded " + this.animatedCaptchaGif.size() + " gifs");
            List<RenderLayer> circleShadowBackground = null;
            List<RenderLayer> renderLayers = captchaDataSettings.loadGroupedLayers(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.GLOWING_CIRCLE.SHADOW_RENDER_LAYERS, renderLayerTemplates, executor);
            if (!renderLayers.isEmpty()) {
                circleShadowBackground = renderLayers;
                nullCordX.sendDebugLogIfEnabled("Using animatedHandCaptcha circleShadowBackground " + circleShadowBackground + " render groups");
            }
            this.gifGenerator = AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.GLOWING_CIRCLE.ENABLED ? new GlowingCircleGifGenerator(this.animatedCaptchaGif, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.GLOWING_CIRCLE, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.IMAGE_OFFSET, circleShadowBackground, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAMES_COUNT) : new SimpleGifGenerator(this.animatedCaptchaGif, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.IMAGE_OFFSET, AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.FRAMES_COUNT);
            this.groupedRenderLayers.addAll(captchaDataSettings.loadGroupedLayers(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.RENDER_LAYER_GROUPS, renderLayerTemplates, executor));
            this.postRenderLayers.addAll(captchaDataSettings.loadRenderLayers(AnimatedFramedPuzzleSettings.IMP.ANIMATED_FRAMED_PUZZLE.POST_RENDER, renderLayerTemplates, executor));
            nullCordX.sendDebugLogIfEnabled("Using animatedFramedPuzzle " + this.groupedRenderLayers + " render groups");
            nullCordX.sendDebugLogIfEnabled("Using animatedFramedPuzzle " + this.postRenderLayers + " post render");
        }
    }

    public List<ResizedGif> getAnimatedCaptchaGif() {
        return this.animatedCaptchaGif;
    }

    public GifGenerator getGifGenerator() {
        return this.gifGenerator;
    }

    public List<RenderLayer> getGroupedRenderLayers() {
        return this.groupedRenderLayers;
    }

    public List<RenderLayer> getPostRenderLayers() {
        return this.postRenderLayers;
    }
}

