/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha;

import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.renderlayer.RenderLayer;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.CaptchaDataSettings;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.captcha.filecache.CaptchaFileCacheType;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.cache.CaptchaHolderImpl;
import net.shieldcommunity.nullcordx.utils.CompressorThreadLocal;

public abstract class CaptchaGenerationTask<T extends ByteBufPacket>
extends RecursiveAction {
    private final ForkJoinPool executor;
    protected final Logger logger;
    protected final NullCordXImpl nullCordX;
    protected final GenerationStateWrapper generationStateWrapper;
    protected final CompressorThreadLocal compressorThreadLocal;
    protected final boolean force;
    protected final CaptchaHolderImpl<T> holder;
    protected final List<Color> colors;
    protected final List<RenderLayer> groupedRenderLayers;
    protected final List<RenderLayer> postRenderLayers;
    protected final String cacheHash;
    protected final CaptchaFileCacheType<T> cacheType;

    @Override
    public void compute() {
        try {
            if (this.generationStateWrapper.isCancelled()) {
                return;
            }
            File cachedCaptchaFile = null;
            File markDeletedFile = null;
            boolean markDeletedExists = false;
            String cacheFileName = this.cacheType.getCacheName();
            boolean generateNow = true;
            if (cacheFileName != null) {
                File cacheDirectory = new File(CaptchaDataSettings.GLOBAL_CAPTCHA_CACHE_DIRECTORY, this.cacheHash);
                File captchaNumberCache = new File(cacheDirectory, String.valueOf(this.holder.getNumber()));
                if (!captchaNumberCache.exists()) {
                    captchaNumberCache.mkdirs();
                }
                cachedCaptchaFile = new File(captchaNumberCache, cacheFileName);
                markDeletedFile = new File(captchaNumberCache, "mark_deleted.tmp");
                markDeletedExists = markDeletedFile.exists();
                boolean bl = generateNow = !cachedCaptchaFile.exists() || markDeletedExists || this.force;
            }
            if (markDeletedExists) {
                markDeletedFile.delete();
            }
            if (generateNow) {
                this.generate(cachedCaptchaFile);
                return;
            }
            try {
                this.cacheType.loadCaptchaCache(this.nullCordX, cachedCaptchaFile, this.holder);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to load captcha #" + this.holder.getNumber() + " from cache. Regenerating...", e);
                this.generate(cachedCaptchaFile);
            }
        }
        catch (Throwable e) {
            this.generationStateWrapper.setCancelled(true);
            this.logger.log(Level.SEVERE, "Failed to generate captcha #" + this.holder.getNumber(), e);
        }
    }

    public abstract void generate(File var1);

    public ForkJoinPool getExecutor() {
        return this.executor;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public NullCordXImpl getNullCordX() {
        return this.nullCordX;
    }

    public GenerationStateWrapper getGenerationStateWrapper() {
        return this.generationStateWrapper;
    }

    public CompressorThreadLocal getCompressorThreadLocal() {
        return this.compressorThreadLocal;
    }

    public boolean isForce() {
        return this.force;
    }

    public CaptchaHolderImpl<T> getHolder() {
        return this.holder;
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public List<RenderLayer> getGroupedRenderLayers() {
        return this.groupedRenderLayers;
    }

    public List<RenderLayer> getPostRenderLayers() {
        return this.postRenderLayers;
    }

    public String getCacheHash() {
        return this.cacheHash;
    }

    public CaptchaFileCacheType<T> getCacheType() {
        return this.cacheType;
    }

    public CaptchaGenerationTask(ForkJoinPool executor, Logger logger, NullCordXImpl nullCordX, GenerationStateWrapper generationStateWrapper, CompressorThreadLocal compressorThreadLocal, boolean force, CaptchaHolderImpl<T> holder, List<Color> colors, List<RenderLayer> groupedRenderLayers, List<RenderLayer> postRenderLayers, String cacheHash, CaptchaFileCacheType<T> cacheType) {
        this.executor = executor;
        this.logger = logger;
        this.nullCordX = nullCordX;
        this.generationStateWrapper = generationStateWrapper;
        this.compressorThreadLocal = compressorThreadLocal;
        this.force = force;
        this.holder = holder;
        this.colors = colors;
        this.groupedRenderLayers = groupedRenderLayers;
        this.postRenderLayers = postRenderLayers;
        this.cacheHash = cacheHash;
        this.cacheType = cacheType;
    }
}

