/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.ImageCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.GroupedImage;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ImageResizeTask;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedImage;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;

public class GroupedImageResizeTask
extends RecursiveTask<GroupedImage> {
    private final Logger logger;
    private final ForkJoinPool executor;
    private final GenerationStateWrapper generationStateWrapper;
    private final File groupPath;
    private final File cacheDirectory;
    private final int minRows;
    private final int maxRows;
    private final int minColumns;
    private final int maxColumns;
    private final ImageCacheType imageCacheType;
    private final Scalr.Method resizeMethod;

    @Override
    protected GroupedImage compute() {
        if (this.generationStateWrapper.isCancelled()) {
            return null;
        }
        String groupName = this.groupPath.getName();
        File[] imagePaths = this.groupPath.listFiles();
        if (imagePaths != null && imagePaths.length > 0) {
            this.logger.log(Level.INFO, "Found " + imagePaths.length + " potential images for " + groupName + " group");
            ArrayList<ImageResizeTask> imageTasks = new ArrayList<ImageResizeTask>();
            for (File imageFile : imagePaths) {
                imageTasks.add(new ImageResizeTask(this.logger, this.executor, this.generationStateWrapper, this.cacheDirectory, this.minRows, this.maxRows, this.minColumns, this.maxColumns, this.imageCacheType, this.resizeMethod, imageFile));
            }
            HashSet<ResizedImage> images = new HashSet<ResizedImage>();
            for (ImageResizeTask task : GroupedImageResizeTask.invokeAll(imageTasks)) {
                try {
                    ResizedImage resizedImage = (ResizedImage)task.get();
                    if (resizedImage == null) continue;
                    images.add(resizedImage);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.logger.log(Level.INFO, "Loaded " + images.size() + " images for " + groupName + " group");
            return new GroupedImage(groupName, images);
        }
        return null;
    }

    public GroupedImageResizeTask(Logger logger, ForkJoinPool executor, GenerationStateWrapper generationStateWrapper, File groupPath, File cacheDirectory, int minRows, int maxRows, int minColumns, int maxColumns, ImageCacheType imageCacheType, Scalr.Method resizeMethod) {
        this.logger = logger;
        this.executor = executor;
        this.generationStateWrapper = generationStateWrapper;
        this.groupPath = groupPath;
        this.cacheDirectory = cacheDirectory;
        this.minRows = minRows;
        this.maxRows = maxRows;
        this.minColumns = minColumns;
        this.maxColumns = maxColumns;
        this.imageCacheType = imageCacheType;
        this.resizeMethod = resizeMethod;
    }
}

