/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.shieldcommunity.nullcordx.antibot.captcha.GenerationStateWrapper;
import net.shieldcommunity.nullcordx.antibot.captcha.settings.ImageCacheType;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.resizer.ResizedImage;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.libs.imgscalr.Scalr;
import net.shieldcommunity.nullcordx.utils.ImageUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class ImageResizeTask
extends RecursiveTask<ResizedImage> {
    private final Logger logger;
    private final ForkJoinPool executor;
    private final GenerationStateWrapper generationStateWrapper;
    private final File cacheDirectory;
    private final int minRows;
    private final int maxRows;
    private final int minColumns;
    private final int maxColumns;
    private final ImageCacheType imageCacheType;
    private final Scalr.Method resizeMethod;
    private final File imageFile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ResizedImage compute() {
        if (this.imageFile.isDirectory()) {
            return null;
        }
        if (!this.imageFile.exists()) {
            return null;
        }
        try (InputStream is = Files.newInputStream(this.imageFile.toPath(), new OpenOption[0]);){
            String checksum = DigestUtils.md5Hex(is);
            PerRaCStorage<BufferedImage> perRaCStorage = new PerRaCStorage<BufferedImage>(BufferedImage.class, this.minRows, this.maxRows, this.minColumns, this.maxColumns);
            if (this.generationStateWrapper != null && this.generationStateWrapper.isCancelled()) {
                ResizedImage resizedImage2 = new ResizedImage(checksum, perRaCStorage);
                return resizedImage2;
            }
            File cachedImageDirectory = new File(this.cacheDirectory, checksum);
            if (!cachedImageDirectory.exists()) {
                cachedImageDirectory.mkdirs();
            }
            boolean cacheExists = true;
            block8: for (int w = this.minRows; w <= this.maxRows; ++w) {
                for (int h2 = this.minColumns; h2 <= this.maxColumns; ++h2) {
                    String cachedFileName = this.imageCacheType.getCacheFileName(w, h2, this.resizeMethod.ordinal());
                    if (cachedFileName == null) {
                        cacheExists = false;
                        break block8;
                    }
                    File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                    if (cachedImageFile.exists()) continue;
                    cacheExists = false;
                    break block8;
                }
            }
            if (cacheExists) {
                perRaCStorage.loadNow(this.executor, (rows, columns) -> {
                    String cachedFileName = this.imageCacheType.getCacheFileName(rows, columns, this.resizeMethod.ordinal());
                    File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                    int expectedWidth = 128 * rows;
                    int expectedHeight = 128 * columns;
                    try {
                        return this.imageCacheType.loadImageFromCache(rows, columns, cachedImageFile);
                    }
                    catch (Exception e) {
                        cachedImageFile.delete();
                        this.logger.log(Level.SEVERE, "Error while loading cached image " + cachedImageFile.toPath(), e);
                        return new BufferedImage(expectedWidth, expectedHeight, 2);
                    }
                });
            } else {
                BufferedImage readImage = ImageIO.read(this.imageFile);
                if (readImage == null) {
                    throw new IllegalStateException("Failed to load an image " + this.imageFile.toPath());
                }
                perRaCStorage.loadNow(this.executor, (rows, columns) -> {
                    BufferedImage image = ImageUtils.resizeImage(readImage, 128 * rows, 128 * columns, this.resizeMethod);
                    String cachedFileName = this.imageCacheType.getCacheFileName(rows, columns, this.resizeMethod.ordinal());
                    if (cachedFileName != null) {
                        File cachedImageFile = new File(cachedImageDirectory, cachedFileName);
                        try {
                            this.imageCacheType.saveImageToCache(image, cachedImageFile);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.SEVERE, "Error while writing an image " + cachedImageFile.toPath(), e);
                        }
                    }
                    return image;
                });
            }
            ResizedImage resizedImage = new ResizedImage(checksum, perRaCStorage);
            return resizedImage;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Could not load image: '" + this.imageFile.toPath() + "'", e);
            return null;
        }
    }

    public ImageResizeTask(Logger logger, ForkJoinPool executor, GenerationStateWrapper generationStateWrapper, File cacheDirectory, int minRows, int maxRows, int minColumns, int maxColumns, ImageCacheType imageCacheType, Scalr.Method resizeMethod, File imageFile) {
        this.logger = logger;
        this.executor = executor;
        this.generationStateWrapper = generationStateWrapper;
        this.cacheDirectory = cacheDirectory;
        this.minRows = minRows;
        this.maxRows = maxRows;
        this.minColumns = minColumns;
        this.maxColumns = maxColumns;
        this.imageCacheType = imageCacheType;
        this.resizeMethod = resizeMethod;
        this.imageFile = imageFile;
    }
}

