/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.checklimiter;

import java.net.InetAddress;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AddressLimit;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AddressLimitResult;
import net.shieldcommunity.nullcordx.antibot.checklimiter.LoadedProgression;
import net.shieldcommunity.nullcordx.antibot.checklimiter.ProgressionData;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.LoadingCache;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;

@Singleton
public class AntiBotCheckLimiter
extends ManagerComponent {
    private LoadingCache<InetAddress, AddressLimit> cache = null;
    private InetAddressSet ignoredIps = new InetAddressSet();
    private LoadedProgression sameNameProgression = new LoadedProgression();
    private LoadedProgression differentNameProgression = new LoadedProgression();

    @Inject
    public AntiBotCheckLimiter(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "AntiBotCheckLimiter");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        this.ignoredIps = AntibotSettings.IMP.ANTIBOT.IGNORED_IPS.calculateAddresses(this.logger, "antibot ignored addresses");
        this.sameNameProgression = this.loadedProgression(AntibotSettings.IMP.ANTIBOT.MANY_CHECKS.PROGRESSION.SAME_NICKNAME_PROGRESSION);
        this.differentNameProgression = this.loadedProgression(AntibotSettings.IMP.ANTIBOT.MANY_CHECKS.PROGRESSION.DIFFERENT_NICKNAME_PROGRESSION);
        this.cache = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).initialCapacity(1000).expireAfterWrite(AntibotSettings.IMP.ANTIBOT.MANY_CHECKS.PROGRESSION.PROGRESSION_MAX_TIME, TimeUnit.SECONDS).build(AddressLimit::new);
    }

    @Override
    protected void onUnload() {
        this.clear();
        this.cache = null;
    }

    public void increaseOrAdd(InetAddress address, String name) {
        if (this.cache == null) {
            return;
        }
        if (this.isIgnoredIp(address)) {
            return;
        }
        AddressLimit addressLimit = this.cache.get(address);
        if (addressLimit.getBlockedTime() > 0L) {
            return;
        }
        AtomicInteger count = addressLimit.getCount();
        int newCount = count.incrementAndGet();
        if (newCount >= AntibotSettings.IMP.ANTIBOT.MANY_CHECKS.MAX_ATTEMPTS) {
            addressLimit.setBlockedTime(System.currentTimeMillis());
            addressLimit.incrementBlockedCount();
            count.set(0);
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("Address " + address.getHostAddress() + " blocked. Blocked count: " + addressLimit.getBlockedCount());
            }
        }
        if (addressLimit.getLastName() == null) {
            addressLimit.setLastName(name);
        }
        if (!addressLimit.getLastName().equals(name)) {
            addressLimit.setDifferentName(true);
        }
    }

    public AddressLimitResult getManyCheckResult(InetAddress address) {
        if (this.cache == null) {
            return AddressLimitResult.ALLOW;
        }
        AddressLimit addressLimit = this.cache.get(address);
        LoadedProgression currentLoadedProgression = addressLimit.isDifferentName() ? this.differentNameProgression : this.sameNameProgression;
        ProgressionData progressionData = currentLoadedProgression.getProgression(addressLimit.getBlockedCount());
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Address " + address.getHostAddress() + ". Blocked count: " + addressLimit.getBlockedCount() + ". Progression time: " + progressionData.getTime() + ". Different: " + addressLimit.isDifferentName());
        }
        if (System.currentTimeMillis() - addressLimit.getBlockedTime() >= TimeUnit.SECONDS.toMillis(progressionData.getTime())) {
            addressLimit.setBlockedTime(0L);
            return AddressLimitResult.ALLOW;
        }
        return addressLimit.isDifferentName() ? AddressLimitResult.MANY_DIFFERENT_NICKNAMES : AddressLimitResult.MANY_SAME_NICKNAMES;
    }

    public void remove(InetAddress address) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate(address);
    }

    public boolean isIgnoredIp(InetAddress ip) {
        if (this.ignoredIps == null) {
            return false;
        }
        return this.ignoredIps.contains(ip);
    }

    public boolean isEnabled() {
        return !AntibotSettings.IMP.ANTIBOT.ALWAYS_CHECK;
    }

    public void clear() {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
    }

    private LoadedProgression loadedProgression(Map<String, Integer> map) {
        LoadedProgression loadedProgression = new LoadedProgression();
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            int key;
            try {
                key = Integer.parseInt(entry.getKey());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to parse key for progression", e);
                continue;
            }
            loadedProgression.add(new ProgressionData(key, entry.getValue()));
        }
        return loadedProgression;
    }
}

