/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.maxmind;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.LocalScheduler;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.MaxMindDatabase;
import net.shieldcommunity.nullcordx.api.antibot.ExecutorCallback;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.CachedDataChecker;
import net.shieldcommunity.nullcordx.api.antibot.maxmind.MaxMindManager;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.LoadingCache;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;

public abstract class AbstractMaxMindManager<T>
extends ManagerComponent
implements MaxMindManager<T> {
    protected final LocalScheduler localScheduler;
    protected final CheckingFactoriesImpl checkingFactories;
    protected InetAddressSet ignoredIps = new InetAddressSet();
    protected boolean fastCacheCheckForJava = false;
    protected boolean fastCacheCheckForGeyser = false;
    protected MaxMindDatabase database = null;
    protected LoadingCache<InetAddress, CachedDataChecker<T>> cache = null;
    protected ExecutorService executor = null;

    public AbstractMaxMindManager(NullCordXLogger logger, NullCordXImpl nullCordX, LocalScheduler localScheduler, CheckingFactoriesImpl checkingFactories, String name) {
        super(logger, nullCordX, name);
        this.localScheduler = localScheduler;
        this.checkingFactories = checkingFactories;
    }

    @Override
    protected void onUnload() {
        this.closeReader();
        this.clear();
        this.cache = null;
        if (this.executor != null) {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during executor shutdown", e);
            }
        }
    }

    public boolean canUseFastCacheCheck(boolean geyser) {
        return geyser ? this.fastCacheCheckForGeyser : this.fastCacheCheckForJava;
    }

    @Override
    public void submitLookup(InetAddress address, ExecutorCallback<CachedDataChecker<T>> response) {
        if (this.executor == null) {
            return;
        }
        this.executor.execute(() -> {
            if (!response.canExecute()) {
                return;
            }
            CachedDataChecker data = this.lookup(address);
            if (data == null) {
                return;
            }
            response.onExecute(data);
        });
    }

    @Override
    public void clear() {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidateAll();
    }

    @Override
    public void remove(InetAddress address) {
        if (this.cache == null) {
            return;
        }
        this.cache.invalidate(address);
    }

    @Override
    public CachedDataChecker<T> getCheckerByAddress(InetAddress address) {
        if (this.cache == null) {
            return null;
        }
        return (CachedDataChecker)this.cache.getIfPresent(address);
    }

    @Override
    public void reloadDatabase() {
        if (this.database != null) {
            this.database.reloadDatabase();
        }
    }

    protected void checkDatabase() {
        if (this.database != null) {
            this.database.checkDatabase();
        }
    }

    private void closeReader() {
        if (this.database != null) {
            this.database.closeReader();
        }
    }

    protected boolean checkAbilityForFastCache(boolean geyser, Class<? extends AbstractChecking> clazz) {
        List<CheckingFactory> factories = this.checkingFactories.getCurrentCheckingFactory(geyser).getUsedFactories();
        for (CheckingFactory factory : factories) {
            if (factory.getType() != clazz) continue;
            return true;
        }
        return false;
    }
}

