/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.epoll.EpollSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import net.md_5.bungee.PlayerSkinConfiguration;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.SkinConfiguration;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.compress.PacketDecompressor;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.FinishConfiguration;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.LoginAcknowledged;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.antibot.checklimiter.AntiBotCheckLimiter;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.PingCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.ping.PingResult;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AbstractChecking;
import net.shieldcommunity.nullcordx.api.checking.AntiBotCheckResult;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.ConditionEvent;
import net.shieldcommunity.nullcordx.api.checking.ConditionType;
import net.shieldcommunity.nullcordx.api.checking.TeleportWait;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.database.CachedUserData;
import net.shieldcommunity.nullcordx.api.events.UserCheckedSuccessfullyEvent;
import net.shieldcommunity.nullcordx.api.events.UserFailedCheckEvent;
import net.shieldcommunity.nullcordx.api.utils.ProtocolVersion;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedPacketManagerImpl;
import net.shieldcommunity.nullcordx.cache.CachedPlayerInfo;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.protocol.packets.EntityInteractPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerOnGroundPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionAndLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PongTransactionPacket;
import net.shieldcommunity.nullcordx.protocol.packets.TeleportConfirmPacket;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;

public class VirtualConnector
extends PacketHandler
implements CheckingUser {
    private final NullCordXImpl nullCordX;
    private final String name;
    private final InetAddress inetAddress;
    private final String ip;
    private final int protocolVersion;
    private final boolean geyser;
    private final AntiBotCheckResult antiBotCheckResult;
    private final long joinTime;
    private final ChannelWrapper channel;
    private final InitialHandler initialHandler;
    private final boolean kickAfterComplete;
    private final Iterator<CheckingFactory> checkingFactoriesIterator;
    private long timeoutTime = Long.MAX_VALUE;
    private AbstractChecking currentChecking = null;
    private Runnable waitClientSettingsCallback = null;
    private Runnable waitTeleportConfirmCallback = null;
    private TeleportWait waitingTeleport = null;
    private final List<PluginMessage> pluginMessage = new ArrayList<PluginMessage>();
    private String brand = null;
    private UUID tabListUserNameUUID = null;
    private int pluginMessagesBytes = 0;
    private long lastPluginMessageSend = 0L;
    private long lastPlayerPositionSend = 0L;
    private long lastClientSettingsSend = 0L;
    private ClientSettings clientSettings = null;
    private long lastKeepAliveSend = 0L;
    private final PingCheck pingCheck;
    private long lastPingTransactionSend = 0L;
    private long pingTransactionDelay = 0L;
    private boolean disconnected = false;
    private boolean completed = false;
    private boolean kicked = false;
    private boolean configurationClientSettingsReceived = false;
    private boolean configurationPluginMessagesReceived = false;
    private boolean waitConfigurationPackets = false;
    private boolean expectFinish = false;
    private long packetSendDelay;
    private LanguageType languageType;

    public VirtualConnector(String name, InitialHandler initialHandler, AntiBotCheckResult antiBotCheckResult, boolean kickAfterComplete, NullCordXImpl nullCordX) {
        long currentTime;
        this.name = name;
        this.antiBotCheckResult = antiBotCheckResult;
        this.nullCordX = nullCordX;
        this.channel = initialHandler.getCh();
        this.protocolVersion = initialHandler.getVersion();
        this.inetAddress = InetSocketUtil.getAddress(this.channel.getRemoteAddress());
        this.ip = this.inetAddress.getHostAddress();
        this.geyser = initialHandler.isGeyser();
        this.initialHandler = initialHandler;
        this.kickAfterComplete = kickAfterComplete;
        this.checkingFactoriesIterator = this.nullCordX.getCheckingFactories().getCurrentCheckingFactory(this.geyser).createNewCheckingFactoriesList().iterator();
        if (!AntibotSettings.IMP.ANTIBOT.WAIT_CLIENT_SETTINGS || this.protocolVersion >= 764) {
            this.currentChecking = this.checkingFactoriesIterator.next().createChecking(this, this.nullCordX);
        }
        this.pingCheck = this.nullCordX.getAntiBotManager().getPingCheckFactory().create();
        this.languageType = this.nullCordX.getLanguageManager().getDefaultLanguage();
        this.lastPlayerPositionSend = currentTime = System.currentTimeMillis();
        this.pingTransactionDelay = currentTime;
        this.packetSendDelay = currentTime;
        this.joinTime = currentTime;
    }

    @Override
    public String getDisplayName() {
        AbstractChecking currentChecking = this.currentChecking;
        String pingDisplay = this.pingCheck.toDisplayString();
        return "[" + this.ip + "|" + this.name + "|" + ProtocolVersion.getProtocolName(this.protocolVersion) + (String)(pingDisplay != null ? "|" + pingDisplay : "") + (String)(currentChecking != null ? "|" + currentChecking.getName() : "") + "] <-> VirtualConnector";
    }

    @Override
    public int getPing() {
        return (int)this.pingCheck.getCurrentPing();
    }

    @Override
    public PendingConnection getPendingConnection() {
        return this.initialHandler;
    }

    @Override
    public String getUUID() {
        return this.initialHandler.getUUID();
    }

    @Override
    public UUID getUniqueId() {
        return this.initialHandler.getUniqueId();
    }

    @Override
    public Locale getLocale() {
        if (this.clientSettings == null) {
            return Locale.US;
        }
        return Locale.forLanguageTag(this.clientSettings.getLocale().replace('_', '-'));
    }

    @Override
    public byte getViewDistance() {
        if (this.clientSettings == null) {
            return 10;
        }
        return this.clientSettings.getViewDistance();
    }

    @Override
    public ProxiedPlayer.ChatMode getChatMode() {
        if (this.clientSettings == null) {
            return ProxiedPlayer.ChatMode.SHOWN;
        }
        return switch (this.clientSettings.getChatFlags()) {
            default -> ProxiedPlayer.ChatMode.SHOWN;
            case 1 -> ProxiedPlayer.ChatMode.COMMANDS_ONLY;
            case 2 -> ProxiedPlayer.ChatMode.HIDDEN;
        };
    }

    @Override
    public boolean hasChatColors() {
        if (this.clientSettings == null) {
            return false;
        }
        return this.clientSettings.isChatColours();
    }

    @Override
    @Deprecated
    public SkinConfiguration getSkinParts() {
        if (this.clientSettings == null) {
            return new PlayerSkinConfiguration(127);
        }
        return new PlayerSkinConfiguration(this.clientSettings.getSkinParts());
    }

    @Override
    public ProxiedPlayer.MainHand getMainHand() {
        if (this.clientSettings == null) {
            return ProxiedPlayer.MainHand.RIGHT;
        }
        return this.clientSettings.getMainHand() == 1 ? ProxiedPlayer.MainHand.RIGHT : ProxiedPlayer.MainHand.LEFT;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getBrand() {
        return this.brand;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.initialHandler.getAddress();
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.initialHandler.getSocketAddress();
    }

    @Override
    public boolean isConnected() {
        return !this.disconnected && !this.channel.isClosed();
    }

    @Override
    public void exception(Throwable t2) throws Exception {
        this.disconnected = true;
        this.channel.close();
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return !this.disconnected;
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        if (!this.kicked && this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog(this.getDisplayName() + " disconnected during" + (String)(this.currentChecking != null ? " " + this.currentChecking.getName() : "") + " check");
        }
        this.nullCordX.getUserManager().removeConnection(this);
        this.disconnected = true;
    }

    @Override
    public void handlerChanged() {
        this.disconnected = true;
    }

    @Override
    public void handle(Chat chat) throws Exception {
        if (this.currentChecking != null) {
            this.currentChecking.handle(chat);
        }
    }

    @Override
    public void handle(ClientChat chat) throws Exception {
        if (this.currentChecking != null) {
            this.currentChecking.handle(chat);
        }
    }

    @Override
    public void handle(ClientCommand command) throws Exception {
        if (this.currentChecking != null) {
            this.currentChecking.handle(command);
        }
    }

    @Override
    public void handle(ClientSettings settings) throws Exception {
        this.lastClientSettingsSend = 0L;
        this.clientSettings = settings;
        try {
            this.languageType = LanguageType.valueOf(settings.getLocale().toUpperCase(Locale.ROOT));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.waitConfigurationPackets) {
            this.configurationClientSettingsReceived = true;
            this.checkConfigurationReceived();
            return;
        }
        if (this.channel.getEncodeProtocol() == Protocol.CONFIGURATION_FILTER) {
            return;
        }
        this.startDelayedCheckIfNeed();
        if (this.currentChecking != null) {
            this.currentChecking.handle(settings);
        }
    }

    private void startDelayedCheckIfNeed() {
        if (this.waitClientSettingsCallback != null) {
            this.waitClientSettingsCallback.run();
            this.waitClientSettingsCallback = null;
        }
    }

    @Override
    public void handle(KeepAlive keepAlive) throws Exception {
        Long secondPingResult;
        if (this.lastKeepAliveSend == 0L) {
            this.kick(KickType.PING, "Unexpected KeepAlive");
            return;
        }
        if (keepAlive.getRandomId() != (long)this.nullCordX.getCheckingFactories().getKeepAliveId()) {
            this.kick(KickType.PING, "KeepAlive mismatch");
            return;
        }
        long ping = System.currentTimeMillis() - this.lastKeepAliveSend;
        this.lastKeepAliveSend = 0L;
        Long pingResult = this.pingCheck.onPingReceived(ping);
        if (pingResult != null && this.nullCordX.getAntiBotManager().checkBigPing(pingResult)) {
            this.kick(KickType.PING, "Too high ping");
            return;
        }
        Long currentRtt = this.getCurrentRTT();
        if (currentRtt != null && (secondPingResult = this.pingCheck.onSecondPingReceived(currentRtt)) != null && pingResult != null && this.nullCordX.getAntiBotManager().checkBigPingAdvanced(Math.abs(pingResult - secondPingResult))) {
            this.kick(KickType.PING, "Too big difference in ping");
            return;
        }
        if (this.currentChecking != null) {
            this.currentChecking.handle(keepAlive);
        }
    }

    @Override
    public void handle(PluginMessage pluginMessage) throws Exception {
        this.lastPluginMessageSend = 0L;
        this.pluginMessagesBytes += pluginMessage.calculatePacketSize();
        if (this.pluginMessagesBytes > AntibotSettings.IMP.ANTIBOT.MAX_PLUGIN_MESSAGES_BYTES) {
            this.kick(KickType.BIG_PACKET, "Too big plugin messages");
            return;
        }
        if (!this.initialHandler.relayMessageAndCheck(pluginMessage)) {
            this.pluginMessage.add(pluginMessage);
            if (this.pluginMessage.size() > AntibotSettings.IMP.ANTIBOT.MAX_PLUGIN_MESSAGES_AMOUNT) {
                this.kick(KickType.BIG_PACKET, "Too many plugin messages registered");
                return;
            }
        } else {
            this.checkAndSetBrand();
        }
        if (this.waitConfigurationPackets) {
            this.configurationPluginMessagesReceived = true;
            this.checkConfigurationReceived();
            return;
        }
        if (this.channel.getEncodeProtocol() == Protocol.CONFIGURATION_FILTER) {
            return;
        }
        if (this.currentChecking != null) {
            this.currentChecking.handle(pluginMessage);
        }
    }

    private void checkAndSetBrand() {
        PluginMessage brandPluginMessage;
        if (this.brand == null && (brandPluginMessage = this.initialHandler.getBrandMessage()) != null) {
            ByteBuf byteBuf = Unpooled.wrappedBuffer(brandPluginMessage.getData());
            try {
                this.brand = DefinedPacket.readString(byteBuf);
                if (this.nullCordX.canSendDebugLog()) {
                    this.nullCordX.sendDebugLog("For player " + this.name + " decoded client brand: '" + this.brand + "'");
                }
            }
            finally {
                byteBuf.release();
            }
        }
    }

    @Override
    public void handle(PlayerOnGroundPacket playerOnGroundPacket) throws Exception {
        if (this.currentChecking != null) {
            this.currentChecking.handle(playerOnGroundPacket);
        }
    }

    @Override
    public void handle(PlayerPositionPacket playerPositionPacket) throws Exception {
        this.lastPlayerPositionSend = System.currentTimeMillis();
        if (this.currentChecking != null) {
            this.currentChecking.handle(playerPositionPacket);
        }
    }

    @Override
    public void handle(PlayerPositionAndLookPacket playerPositionAndLookPacket) throws Exception {
        this.lastPlayerPositionSend = System.currentTimeMillis();
        if (this.protocolVersion == 47 && this.waitTeleportConfirmCallback != null) {
            this.waitTeleportConfirmCallback.run();
            this.waitTeleportConfirmCallback = null;
        }
        if (this.currentChecking != null) {
            this.currentChecking.handle(playerPositionAndLookPacket);
        }
    }

    @Override
    public void handle(PlayerLookPacket playerLookPacket) throws Exception {
        this.lastPlayerPositionSend = System.currentTimeMillis();
        if (this.currentChecking != null) {
            this.currentChecking.handle(playerLookPacket);
        }
    }

    @Override
    public void handle(TeleportConfirmPacket teleportConfirmPacket) throws Exception {
        TeleportWait waitingTeleport = this.waitingTeleport;
        if (waitingTeleport == null) {
            this.kick(KickType.CHECKING_ERROR, "Unexpected TeleportConfirm");
            return;
        }
        if (!waitingTeleport.isCorrectId(teleportConfirmPacket.getTeleportId())) {
            this.kick(KickType.CHECKING_ERROR, "TeleportConfirm mismatch");
            return;
        }
        this.resetTeleportConfirm();
        Runnable future = waitingTeleport.getFuture();
        if (future != null) {
            future.run();
        }
        if (this.waitTeleportConfirmCallback != null) {
            this.waitTeleportConfirmCallback.run();
            this.waitTeleportConfirmCallback = null;
        }
        if (this.currentChecking != null) {
            this.currentChecking.handle(teleportConfirmPacket);
        }
    }

    @Override
    public void awaitTeleportConfirm() {
        this.awaitTeleportConfirm(null);
    }

    @Override
    public void awaitTeleportConfirm(Runnable future) {
        this.waitingTeleport = new TeleportWait(this.nullCordX.getCheckingFactories().getWaitingTeleportId(), future, System.currentTimeMillis());
    }

    @Override
    public void resetTeleportConfirm() {
        this.waitingTeleport = null;
    }

    @Override
    public void handle(EntityInteractPacket entityInteractPacket) throws Exception {
        if (this.currentChecking != null) {
            this.currentChecking.handle(entityInteractPacket);
        }
    }

    @Override
    public void handle(PongTransactionPacket pongTransactionPacket) throws Exception {
        if (this.lastPingTransactionSend == 0L) {
            this.kick(KickType.PING, "Unexpected PongTransaction");
            return;
        }
        if (pongTransactionPacket.getId() != this.nullCordX.getCheckingFactories().getPingTransactionId()) {
            this.kick(KickType.PING, "PongTransaction id mismatch");
            return;
        }
        if (pongTransactionPacket.getWindowId() != 0) {
            this.kick(KickType.PING, "PongTransaction window id mismatch");
            return;
        }
        if (!pongTransactionPacket.isAccepted()) {
            this.kick(KickType.PING, "PongTransaction accepted mismatch");
            return;
        }
        this.lastPingTransactionSend = 0L;
        if (this.currentChecking != null) {
            this.currentChecking.handle(pongTransactionPacket);
        }
    }

    @Override
    public void forceClose(String message) {
        this.kick(KickType.BIG_PACKET, message);
    }

    @Override
    public void disconnect(String reason) {
        this.disconnect(TextComponent.fromLegacy(reason));
    }

    @Override
    public void disconnect(BaseComponent ... reason) {
        this.disconnect(TextComponent.fromArray(reason));
    }

    @Override
    public void disconnect(BaseComponent reason) {
        this.kicked = true;
        this.channel.close(new Kick(reason));
        this.disconnected = true;
        if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog(this.getDisplayName() + " kicked during connecting to a server: '" + TextComponent.toPlainText(reason) + "'");
        }
    }

    @Override
    public void handle(LoginAcknowledged loginAcknowledged) throws Exception {
        this.channel.setDecodeProtocol(Protocol.CONFIGURATION_FILTER);
        CachedPacketManagerImpl cachedPacketManager = this.nullCordX.getCachedPacketManager();
        this.sendCachedPacket(cachedPacketManager.getCachedPluginMessageByProtocol(Protocol.CONFIGURATION_FILTER));
        this.sendCachedPacket(cachedPacketManager.getCachedRegistryData(), true);
        this.waitConfigurationPackets = true;
        this.lastClientSettingsSend = System.currentTimeMillis();
        this.lastPluginMessageSend = System.currentTimeMillis();
    }

    private void checkConfigurationReceived() {
        if (!this.waitConfigurationPackets) {
            return;
        }
        if (this.configurationClientSettingsReceived && this.configurationPluginMessagesReceived) {
            this.waitConfigurationPackets = false;
            this.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedFinishConfiguration(), true);
            this.expectFinish = true;
        }
    }

    @Override
    public void handle(FinishConfiguration finishConfiguration) {
        if (!this.expectFinish) {
            this.kick(KickType.CHECKING_ERROR, "Unexpected FinishConfiguration");
            return;
        }
        this.expectFinish = false;
        this.channel.setEncodeProtocol(Protocol.GAME);
        this.channel.setDecodeProtocol(Protocol.FILTER);
        this.performSpawn();
    }

    public void spawn() {
        if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog(this.getDisplayName() + " joined to the filter. Reason: " + this.antiBotCheckResult.getMessage());
        }
        this.nullCordX.getStatisticsManager().getBotStatistics().addCounterAndCheckAttack();
        AntiBotCheckLimiter antiBotCheckLimiter = this.nullCordX.getAntiBotCheckLimiter();
        if (antiBotCheckLimiter.isEnabled()) {
            antiBotCheckLimiter.increaseOrAdd(this.inetAddress, this.name);
        }
        if (this.channel.getEncodeProtocol() == Protocol.CONFIGURATION_FILTER) {
            return;
        }
        this.performSpawn();
    }

    private void performSpawn() {
        CachedPacketManagerImpl cachedPacketManager = this.nullCordX.getCachedPacketManager();
        this.sendCachedPacket(cachedPacketManager.getCachedJoin());
        this.sendCachedPacket(cachedPacketManager.getCachedDefaultSpawnPosition());
        if (this.protocolVersion < 764) {
            this.sendCachedPacket(cachedPacketManager.getCachedPluginMessageByProtocol(Protocol.GAME));
        }
        this.sendCachedPacket(cachedPacketManager.getCachedTimeUpdate());
        CachedPlayerInfo cachedPlayerInfo = cachedPacketManager.getCachedPlayerInfo();
        this.tabListUserNameUUID = cachedPlayerInfo.getUuid();
        this.sendCachedPacket(cachedPlayerInfo);
        if (this.protocolVersion >= 477) {
            this.sendCachedPacket(cachedPacketManager.getCachedSetCenterChunk());
        }
        if (this.protocolVersion >= 765) {
            this.sendCachedPacket(cachedPacketManager.getCachedStartWaitingChunks());
        }
        for (ByteBufPacket packet : cachedPacketManager.getCachedEmptyChunks()) {
            this.sendCachedPacket(packet);
        }
        if (AntibotSettings.IMP.ANTIBOT.WAIT_CLIENT_SETTINGS && this.protocolVersion < 764) {
            this.waitClientSettingsCallback = () -> this.channel.getHandle().eventLoop().execute(() -> {
                if (this.disconnected) {
                    return;
                }
                this.currentChecking = this.checkingFactoriesIterator.next().createChecking(this, this.nullCordX);
                this.currentChecking.onAdded(true);
            });
            this.lastClientSettingsSend = System.currentTimeMillis();
        } else {
            this.currentChecking.onAdded(false);
        }
        this.channel.getHandle().flush();
        this.lastPlayerPositionSend = System.currentTimeMillis();
        this.pingTransactionDelay = System.currentTimeMillis();
        long plusTimeout = this.geyser ? AntibotSettings.IMP.ANTIBOT.MODES.BEDROCK.TIME_OUT : AntibotSettings.IMP.ANTIBOT.MODES.JAVA.TIME_OUT;
        this.timeoutTime = System.currentTimeMillis() + plusTimeout;
        this.checkAndSendPing();
    }

    @Override
    public void completeChecking(KickType kickType, String message) {
        if (this.disconnected) {
            return;
        }
        if (this.completed) {
            return;
        }
        if (this.waitTeleportConfirmCallback != null) {
            return;
        }
        if (this.waitingTeleport != null) {
            this.waitTeleportConfirmCallback = () -> this.channel.getHandle().eventLoop().execute(() -> {
                if (this.disconnected) {
                    return;
                }
                this.completeCheckingPost(kickType, message);
            });
            return;
        }
        this.completeCheckingPost(kickType, message);
    }

    private void completeCheckingPost(KickType kickType, String message) {
        if (this.disconnected) {
            return;
        }
        if (this.currentChecking == null) {
            if (this.nullCordX.canSendDebugLog()) {
                this.nullCordX.sendDebugLog("For player " + this.name + " no checks available.");
            }
            this.complete();
            return;
        }
        ConditionData conditionData = this.currentChecking.getCheckingFactory().getConditionData();
        if (conditionData.isCheckPingOnComplete() && this.checkAveragePing(false)) {
            return;
        }
        this.currentChecking.onRemoved();
        ConditionEvent conditionEvent = kickType != null ? conditionData.getOnFailedEvent() : conditionData.getOnSuccessEvent();
        ConditionType conditionType = conditionEvent.getConditionType();
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("For player " + this.name + " next check condition: " + (String)(conditionType != null ? conditionType.name() : "GOTO " + conditionEvent.getCheckingFactory().getName()));
        }
        if (conditionType != null) {
            switch (conditionType) {
                case NEXT: {
                    if (!this.checkingFactoriesIterator.hasNext()) {
                        this.currentChecking = null;
                        if (this.nullCordX.canSendDebugLog()) {
                            this.nullCordX.sendDebugLog("For player " + this.name + " no more checks left.");
                        }
                        this.complete();
                        return;
                    }
                    if (conditionData.isResetPingOnComplete()) {
                        this.pingCheck.reset();
                    }
                    CheckingFactory checkingFactory = this.checkingFactoriesIterator.next();
                    this.currentChecking = checkingFactory.createChecking(this, this.nullCordX);
                    if (this.nullCordX.canSendDebugLog()) {
                        this.nullCordX.sendDebugLog("For player " + this.name + " after 'NEXT' condition new check: " + checkingFactory.getName());
                    }
                    this.currentChecking.onAdded(true);
                    return;
                }
                case FINISH: {
                    this.complete();
                    return;
                }
                case KICK: {
                    this.kick(kickType != null ? kickType : KickType.FAILED_CHECK, message);
                    return;
                }
            }
            return;
        }
        if (conditionData.isResetPingOnComplete()) {
            this.pingCheck.reset();
        }
        CheckingFactory checkingFactory = conditionEvent.getCheckingFactory();
        this.currentChecking = checkingFactory.createChecking(this, this.nullCordX);
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("For player " + this.name + " GOTO check: " + checkingFactory.getName());
        }
        this.currentChecking.onAdded(true);
    }

    private void complete() {
        if (this.checkAveragePing(true)) {
            return;
        }
        this.completed = true;
        this.channel.getHandle().flush();
        this.nullCordX.getUserManager().removeConnection(this);
        this.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.languageType).getCachedMessageSuccessful());
        CachedUserData cachedUserData = this.nullCordX.getUserManager().saveCachedUser(this.name, this.inetAddress, true);
        cachedUserData.setAllowJoin(true);
        PacketDecompressor packetDecompressor = this.channel.getHandle().pipeline().get(PacketDecompressor.class);
        if (packetDecompressor != null) {
            packetDecompressor.setChecking(false);
        }
        this.disconnected = true;
        ProxyServer.getInstance().getPluginManager().callEvent(new UserCheckedSuccessfullyEvent(this, this.kickAfterComplete));
        if (this.kickAfterComplete) {
            this.kick(KickType.SUCCESSFULLY, "Has successfully passed check in the filter.");
            return;
        }
        if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog(this.getDisplayName() + " has successfully passed check in the filter.");
        }
        this.initialHandler.endLoginProcessForAntibot(this);
    }

    public void onScheduledTask() {
        if (this.isInEventLoop()) {
            this.performScheduledTask();
            return;
        }
        this.channel.getHandle().eventLoop().execute(this::performScheduledTask);
    }

    private void performScheduledTask() {
        if (this.completed || this.disconnected) {
            return;
        }
        this.checkAndSendPing();
        if (this.channel.getEncodeProtocol() == Protocol.CONFIGURATION_FILTER) {
            return;
        }
        if (this.currentChecking != null) {
            this.informTimeoutByExperience();
            this.currentChecking.onScheduledTask();
        }
    }

    private void informTimeoutByExperience() {
        int remainSecond;
        ByteBufPacket expPacket;
        CachedArrayPackets cachedArrayPackets = this.nullCordX.getCachedPacketManager().getCachedExperience();
        if (cachedArrayPackets != null && (expPacket = cachedArrayPackets.getByIndex(remainSecond = (int)((this.timeoutTime - System.currentTimeMillis()) / 1000L))) != null) {
            this.sendCachedPacket(expPacket, true);
        }
    }

    private void checkAndSendPing() {
        boolean configurationState;
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Player: " + this.name + ". Ping data: " + this.pingCheck + ". TeleportWait: " + (this.waitingTeleport != null ? Long.valueOf(System.currentTimeMillis() - this.waitingTeleport.getTime()) : null) + ". PlayerPosition: " + (System.currentTimeMillis() - this.lastPlayerPositionSend) + ". ClientSettings: " + (System.currentTimeMillis() - this.lastClientSettingsSend) + ". PluginMessage: " + (System.currentTimeMillis() - this.lastPluginMessageSend) + ". KeepAlive: " + (System.currentTimeMillis() - this.lastKeepAliveSend) + ". PingTransaction: " + (System.currentTimeMillis() - this.lastPingTransactionSend));
        }
        boolean bl = configurationState = this.channel.getEncodeProtocol() == Protocol.CONFIGURATION_FILTER;
        if (!configurationState && !this.keepAliveCheckAndSend()) {
            return;
        }
        if (!this.clientSettingsCheck()) {
            return;
        }
        if (configurationState) {
            if (!this.pluginMessageCheck()) {
                return;
            }
            return;
        }
        if (!this.teleportConfirmCheck()) {
            return;
        }
        if (!this.playerPositionAndLookCheck()) {
            return;
        }
        this.pingTransactionCheckAndSend();
    }

    @Override
    public void kick(KickType type, String kickMessage) {
        if (this.isInEventLoop()) {
            this.performKick(type, kickMessage);
            return;
        }
        this.channel.getHandle().eventLoop().execute(() -> this.performKick(type, kickMessage));
    }

    private void performKick(KickType type, String kickMessage) {
        if (!ConfigSettings.IMP.PERFORMANCE.DISABLE_USER_FAILED_CHECK_EVENT) {
            ProxyServer.getInstance().getPluginManager().callEvent(new UserFailedCheckEvent(this, type, kickMessage));
        }
        this.kicked = true;
        this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.languageType).sendKickPacket(type, this.channel, this.getChannel().getEncodeProtocol(), this.protocolVersion);
        this.disconnected = true;
        if (this.nullCordX.canSendAntibotLog()) {
            this.nullCordX.sendAntibotLog(this.getDisplayName() + " kicked: " + (kickMessage != null ? kickMessage : "Unknown reason"));
        }
    }

    @Override
    public void sendCachedPacket(ByteBufPacket packet) {
        this.sendCachedPacket(packet, false);
    }

    @Override
    public void sendCachedPacket(ByteBufPacket packet, boolean flush) {
        if (packet == null) {
            throw new NullPointerException("Packet cannot be null!");
        }
        if (flush) {
            packet.writeAndFlushPacket(this.channel, this.protocolVersion, this.initialHandler.isOnlineMode());
        } else {
            packet.writePacket(this.channel, this.protocolVersion, this.initialHandler.isOnlineMode());
        }
    }

    @Override
    public void sendCachedPackets(Collection<ByteBufPacket> packets) {
        for (ByteBufPacket packet : packets) {
            this.sendCachedPacket(packet);
        }
    }

    @Override
    public void sendCachedPackets(Collection<ByteBufPacket> packets, boolean flush) {
        this.sendCachedPackets(packets);
        this.channel.getHandle().flush();
    }

    @Override
    public void sendCachedPacketWithDelay(ByteBufPacket packet, int delay) {
        if (System.currentTimeMillis() - this.packetSendDelay >= (long)delay) {
            this.packetSendDelay = System.currentTimeMillis();
            this.sendCachedPacket(packet);
        }
    }

    @Override
    public void disableFalling() {
        this.disableFalling(false);
    }

    @Override
    public void disableFalling(boolean flush) {
        ByteBufPacket packet = this.protocolVersion > 47 && AntibotSettings.IMP.ANTIBOT.DIMENSION.LEVITATE_EFFECT ? this.nullCordX.getCachedPacketManager().getCachedLevitateZero() : this.nullCordX.getCachedPacketManager().getCachedPlayerAbilitiesFlying();
        this.sendCachedPacket(packet, flush);
    }

    @Override
    public void allowFalling() {
        this.allowFalling(false);
    }

    @Override
    public void allowFalling(boolean flush) {
        ByteBufPacket packet = this.protocolVersion > 47 && AntibotSettings.IMP.ANTIBOT.DIMENSION.LEVITATE_EFFECT ? this.nullCordX.getCachedPacketManager().getCachedRemoveEffectLevitate() : this.nullCordX.getCachedPacketManager().getCachedPlayerAbilitiesDefault();
        this.sendCachedPacket(packet, flush);
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    private boolean clientSettingsCheck() {
        if (this.lastClientSettingsSend != 0L) {
            if (System.currentTimeMillis() - this.lastClientSettingsSend > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
                this.kick(KickType.TIMED_OUT, "ClientSettings timeout");
            }
            return false;
        }
        return true;
    }

    private boolean pluginMessageCheck() {
        if (this.lastPluginMessageSend != 0L) {
            if (System.currentTimeMillis() - this.lastPluginMessageSend > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
                this.kick(KickType.TIMED_OUT, "PluginMessage timeout");
            }
            return false;
        }
        return true;
    }

    private boolean teleportConfirmCheck() {
        if (this.protocolVersion <= 47) {
            return true;
        }
        if (this.waitingTeleport != null) {
            if (System.currentTimeMillis() - this.waitingTeleport.getTime() > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
                this.kick(KickType.TIMED_OUT, "TeleportConfirm timeout");
            }
            return false;
        }
        return true;
    }

    private boolean playerPositionAndLookCheck() {
        if (System.currentTimeMillis() - this.lastPlayerPositionSend > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
            this.kick(KickType.TIMED_OUT, "PlayerPosition timeout");
            return false;
        }
        return true;
    }

    private boolean keepAliveCheckAndSend() {
        if (this.lastKeepAliveSend != 0L) {
            if (System.currentTimeMillis() - this.lastKeepAliveSend > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
                this.kick(KickType.TIMED_OUT, "KeepAlive timeout");
            }
            return false;
        }
        this.lastKeepAliveSend = System.currentTimeMillis();
        this.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedKeepAlive(), true);
        return true;
    }

    private void pingTransactionCheckAndSend() {
        if (this.lastPingTransactionSend != 0L) {
            if (System.currentTimeMillis() - this.lastPingTransactionSend > (long)AntibotSettings.IMP.ANTIBOT.PACKET_RECEIVE_TIMEOUT) {
                this.kick(KickType.TIMED_OUT, "PongTransaction timeout");
            }
            return;
        }
        if (System.currentTimeMillis() - this.pingTransactionDelay > 2000L) {
            this.pingTransactionDelay = System.currentTimeMillis();
            this.lastPingTransactionSend = System.currentTimeMillis();
            this.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedPingTransaction(), true);
        }
    }

    private boolean checkAveragePing(boolean full) {
        PingResult pingResult;
        PingResult pingResult2 = pingResult = full ? this.pingCheck.onFullCheckCompleted() : this.pingCheck.onSingleCheckCompleted();
        if (pingResult != null) {
            long currentPing = pingResult.getPing();
            if (this.nullCordX.getAntiBotManager().checkBigPing(currentPing)) {
                this.kick(KickType.PING, "Too high ping");
                return true;
            }
            Long secondPing = pingResult.getSecondPing();
            if (secondPing != null && this.nullCordX.getAntiBotManager().checkBigPingAdvanced(Math.abs(currentPing - secondPing))) {
                this.kick(KickType.PING, "Too big difference in ping");
                return true;
            }
        }
        return false;
    }

    private boolean isInEventLoop() {
        return this.channel.getHandle().eventLoop().inEventLoop();
    }

    private Long getCurrentRTT() {
        if (!AntibotSettings.IMP.ANTIBOT.UNSTABLE_PING_CHECK.ADVANCED.ENABLED) {
            return null;
        }
        EpollSocketChannel epollSocketChannel = this.getChannel().getEpollSocketChannel();
        if (epollSocketChannel == null) {
            return null;
        }
        return epollSocketChannel.tcpInfo().rtt() / 1000L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VirtualConnector)) {
            return false;
        }
        VirtualConnector other = (VirtualConnector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VirtualConnector;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public NullCordXImpl getNullCordX() {
        return this.nullCordX;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public boolean isGeyser() {
        return this.geyser;
    }

    public AntiBotCheckResult getAntiBotCheckResult() {
        return this.antiBotCheckResult;
    }

    @Override
    public long getJoinTime() {
        return this.joinTime;
    }

    @Override
    public ChannelWrapper getChannel() {
        return this.channel;
    }

    public InitialHandler getInitialHandler() {
        return this.initialHandler;
    }

    public boolean isKickAfterComplete() {
        return this.kickAfterComplete;
    }

    public Iterator<CheckingFactory> getCheckingFactoriesIterator() {
        return this.checkingFactoriesIterator;
    }

    @Override
    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    @Override
    public AbstractChecking getCurrentChecking() {
        return this.currentChecking;
    }

    public Runnable getWaitClientSettingsCallback() {
        return this.waitClientSettingsCallback;
    }

    public Runnable getWaitTeleportConfirmCallback() {
        return this.waitTeleportConfirmCallback;
    }

    @Override
    public TeleportWait getWaitingTeleport() {
        return this.waitingTeleport;
    }

    public List<PluginMessage> getPluginMessage() {
        return this.pluginMessage;
    }

    public UUID getTabListUserNameUUID() {
        return this.tabListUserNameUUID;
    }

    public int getPluginMessagesBytes() {
        return this.pluginMessagesBytes;
    }

    public long getLastPluginMessageSend() {
        return this.lastPluginMessageSend;
    }

    public long getLastPlayerPositionSend() {
        return this.lastPlayerPositionSend;
    }

    public long getLastClientSettingsSend() {
        return this.lastClientSettingsSend;
    }

    public ClientSettings getClientSettings() {
        return this.clientSettings;
    }

    public long getLastKeepAliveSend() {
        return this.lastKeepAliveSend;
    }

    public PingCheck getPingCheck() {
        return this.pingCheck;
    }

    public long getLastPingTransactionSend() {
        return this.lastPingTransactionSend;
    }

    public long getPingTransactionDelay() {
        return this.pingTransactionDelay;
    }

    @Override
    public boolean isDisconnected() {
        return this.disconnected;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isKicked() {
        return this.kicked;
    }

    public boolean isConfigurationClientSettingsReceived() {
        return this.configurationClientSettingsReceived;
    }

    public boolean isConfigurationPluginMessagesReceived() {
        return this.configurationPluginMessagesReceived;
    }

    public boolean isWaitConfigurationPackets() {
        return this.waitConfigurationPackets;
    }

    public boolean isExpectFinish() {
        return this.expectFinish;
    }

    public long getPacketSendDelay() {
        return this.packetSendDelay;
    }

    @Override
    public LanguageType getLanguageType() {
        return this.languageType;
    }
}

