/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionAndLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionPacket;

public abstract class AbstractBoundingChecking
extends AbstractVirtualChecking {
    protected final AxisAlignedBounding axisAlignedBounding;
    protected int teleportBackAttempts = 0;

    public AbstractBoundingChecking(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding) {
        super(checkingFactory, connector, nullCordX);
        this.axisAlignedBounding = axisAlignedBounding;
    }

    @Override
    public void handle(PlayerPositionPacket playerPositionPacket) throws Exception {
        if (this.axisAlignedBounding == null) {
            return;
        }
        if (this.axisAlignedBounding.isInside(playerPositionPacket.getX(), playerPositionPacket.getY(), playerPositionPacket.getZ())) {
            return;
        }
        this.teleportToDefaultLocationAndWait();
    }

    @Override
    public void handle(PlayerPositionAndLookPacket playerPositionAndLookPacket) throws Exception {
        if (this.connector.getProtocolVersion() == 47 && this.connector.getWaitingTeleport() != null) {
            this.connector.resetTeleportConfirm();
        }
        if (this.axisAlignedBounding == null) {
            return;
        }
        if (this.axisAlignedBounding.isInside(playerPositionAndLookPacket.getX(), playerPositionAndLookPacket.getY(), playerPositionAndLookPacket.getZ())) {
            return;
        }
        this.teleportToDefaultLocationAndWait();
    }

    public void teleportToDefaultLocation(boolean flush) {
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition(), flush);
    }

    private void teleportToDefaultLocationAndWait() {
        if (this.connector.getWaitingTeleport() != null) {
            return;
        }
        if (this.teleportBackAttempts >= AntibotSettings.IMP.ANTIBOT.DIMENSION.ALLOWED_REGION.MAX_TELEPORTS) {
            this.connector.kick(KickType.FAILED_CHECK, "Too many teleportation to the spawn");
            return;
        }
        ++this.teleportBackAttempts;
        if (this.nullCordX.canSendDebugLog()) {
            this.nullCordX.sendDebugLog("Player " + this.connector.getName() + " is outside the allowed region. Teleporting back. Attempts: " + this.teleportBackAttempts);
        }
        this.connector.disableFalling();
        this.teleportToDefaultLocation(true);
        this.connector.awaitTeleportConfirm();
    }
}

