/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.AnimatedCaptchaCheck;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedCaptchaCheck;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.cache.cachedframes.CachedFramesAnimatedFramedCaptcha;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.captcha.AnimatedFramedCaptchaSettings;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;

public class AnimatedFramedCaptchaCheck
extends FramedCaptchaCheck
implements AnimatedCaptchaCheck {
    private List<CachedFramesAnimatedFramedCaptcha<? extends ByteBufPacket>> frames = null;
    private ListIterator<CachedFramesAnimatedFramedCaptcha<? extends ByteBufPacket>> framesIterator = null;
    private int frameId = 0;
    private boolean firstIteration = true;
    private boolean reverse = false;
    private boolean animationReady = false;
    private ByteBufPacket[][] cachedAnimatedEntityMetadata = null;

    public AnimatedFramedCaptchaCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix, messagesAttemptsByLanguage);
    }

    @Override
    public String getName() {
        return "AnimatedFramedCaptcha";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingAnimatedFramedCaptcha());
        this.sendCaptcha(flush);
    }

    @Override
    public void handleAnimation(boolean flush) {
        if (!this.animationReady) {
            return;
        }
        this.doAnimation(flush);
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingAnimatedFramedCaptcha(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    private void doAnimation(boolean flush) {
        if (this.frames == null) {
            return;
        }
        if (this.framesIterator == null) {
            this.framesIterator = this.frames.listIterator();
            this.firstIteration = true;
            this.reverse = false;
        }
        if (this.reverse ? !this.framesIterator.hasPrevious() : !this.framesIterator.hasNext()) {
            if (!AnimatedFramedCaptchaSettings.IMP.ANIMATED_FRAMED_CAPTCHA.REVERSE_REPLAY_CYCLE) {
                this.framesIterator = this.frames.listIterator();
            } else {
                this.reverse = !this.reverse;
            }
            this.firstIteration = false;
        }
        CachedFramesAnimatedFramedCaptcha<? extends ByteBufPacket> framesInFrame = this.reverse ? this.framesIterator.previous() : this.framesIterator.next();
        this.frameId = framesInFrame.getFrameId();
        if (this.firstIteration) {
            for (ByteBufPacket frame : framesInFrame.getFrames()) {
                this.connector.sendCachedPacket(frame);
            }
        }
        for (ByteBufPacket meta : this.cachedAnimatedEntityMetadata[this.frameId - 1]) {
            this.connector.sendCachedPacket(meta);
        }
        if (flush) {
            this.connector.getChannel().getHandle().flush();
        }
    }

    @Override
    public void sendCaptcha(boolean flush) {
        CaptchaHolder<? extends CachedFramesAnimatedFramedCaptcha<? extends CachedFramesAnimatedFramedCaptcha<? extends ByteBufPacket>>> holder;
        this.animationReady = false;
        if (this.entityFrameData != null) {
            if (this.connector.getProtocolVersion() == 755) {
                this.connector.sendCachedPackets(this.entityFrameData.getCachedRemoveItemFramesLegacy());
            } else {
                this.connector.sendCachedPacket(this.entityFrameData.getCachedRemoveItemFrames());
            }
        }
        if ((holder = this.nullCordX.getCachedCaptchaManager().getCachedAnimatedFramedCaptchaPackets().randomCaptcha()) == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        holder.setLastUsed(System.currentTimeMillis());
        CachedFramesAnimatedFramedCaptcha<? extends CachedFramesAnimatedFramedCaptcha<? extends ByteBufPacket>> cachedFrames = holder.getCaptcha();
        this.entityFrameData = cachedFrames.getEntityFrameData();
        this.spawnEntityFrames();
        this.captchaAnswerGenerator = holder.getAnswer();
        this.frames = new ArrayList(cachedFrames.getFrames());
        this.framesIterator = null;
        this.frameId = 0;
        this.firstIteration = true;
        this.resetFrameRotations(this.entityFrameData);
        this.doAnimation(false);
        this.teleportToCaptcha();
        if (flush) {
            this.connector.getChannel().getHandle().flush();
        }
        this.animationReady = true;
    }

    @Override
    public void updateRotationAtFrame(int entityId, ProtocolItemFrameRotationType rotate) {
        this.setEntityFrameRotationForAllFrames(entityId, rotate);
        ByteBufPacket rotationPacket = this.frames.get(this.frameId - 1).getItemFrameRotationData().getRotationByTypeAndEntityId(rotate, entityId);
        this.connector.sendCachedPacket(rotationPacket, true);
    }

    @Override
    public void resetFrameRotations(CachedEntityFrameData entityFrameData) {
        super.resetFrameRotations(entityFrameData);
        ByteBufPacket[][] entityMetaFramesRotations = new ByteBufPacket[this.frames.size()][];
        for (int i = 0; i < this.frames.size(); ++i) {
            ArrayList<ByteBufPacket> collectionPackets = new ArrayList<ByteBufPacket>(this.frames.get(i).getItemFrameRotationData().getRotationsByType(ProtocolItemFrameRotationType.UP));
            ByteBufPacket[] packets = new ByteBufPacket[collectionPackets.size()];
            for (int j = 0; j < collectionPackets.size(); ++j) {
                packets[j] = (ByteBufPacket)collectionPackets.get(j);
            }
            entityMetaFramesRotations[i] = packets;
        }
        this.cachedAnimatedEntityMetadata = entityMetaFramesRotations;
    }

    public void setEntityFrameRotationForAllFrames(int toEntityId, ProtocolItemFrameRotationType rotation) {
        int i;
        int mapIndex = toEntityId - 250;
        ByteBufPacket[] readyRotations = new ByteBufPacket[this.frames.size()];
        for (i = 0; i < this.frames.size(); ++i) {
            readyRotations[i] = this.frames.get(i).getItemFrameRotationData().getRotationByTypeAndEntityId(rotation, toEntityId);
        }
        for (i = 0; i < this.cachedAnimatedEntityMetadata.length; ++i) {
            ByteBufPacket[] frame = this.cachedAnimatedEntityMetadata[i];
            frame[mapIndex] = readyRotations[i];
        }
    }
}

