/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.Collections;
import java.util.EnumMap;
import net.shieldcommunity.nullcordx.LanguageManagerImpl;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.LazyLoadedCheckingFactory;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.api.config.messages.MessagesSettings;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.cache.CachedPacketManagerImpl;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;

public abstract class CaptchaCheckFactory
extends LazyLoadedCheckingFactory {
    private final Class<? extends AbstractVirtualChecking> type;
    protected final LanguageManagerImpl languageManager;
    protected final int maxAttempts;
    protected final int maxSolves;
    protected final boolean newCaptchaOnFail;
    protected final String answerPrefix;
    protected CachedMessagesByLanguage<CachedArrayPackets> messagesByLanguage;

    public CaptchaCheckFactory(String name, ConditionData conditionData, Class<? extends AbstractVirtualChecking> type, LanguageManagerImpl languageManager, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix) {
        super(name, conditionData);
        this.type = type;
        this.languageManager = languageManager;
        this.maxAttempts = maxAttempts;
        this.maxSolves = maxSolves;
        this.newCaptchaOnFail = newCaptchaOnFail;
        this.answerPrefix = answerPrefix;
        EnumMap<LanguageType, CachedArrayPackets> cachedAttemptsMessagesMap = new EnumMap<LanguageType, CachedArrayPackets>(LanguageType.class);
        cachedAttemptsMessagesMap.put(languageManager.getDefaultLanguage(), new CachedArrayPackets(new ByteBufPacket[0]));
        this.messagesByLanguage = new CachedMessagesByLanguage(this.languageManager, cachedAttemptsMessagesMap);
    }

    public Class<? extends AbstractVirtualChecking> getType() {
        return this.type;
    }

    @Override
    public void lazyLoad() {
        if (this.lazyLoaded) {
            return;
        }
        EnumMap<LanguageType, CachedArrayPackets> messagesByLanguage = new EnumMap<LanguageType, CachedArrayPackets>(LanguageType.class);
        for (MessagesSettings messagesSettings : this.languageManager.getAllMessagesSettings()) {
            ByteBufPacket[] messageAttempts = new ByteBufPacket[this.maxAttempts + 1];
            ReadyComponentMessage readyComponentMessage = messagesSettings.MESSAGES.NULLCORDX.CAPTCHA_WRONG;
            for (int i = 0; i <= this.maxAttempts; ++i) {
                messageAttempts[i] = CachedPacketManagerImpl.createMessagePacket(readyComponentMessage.replace("attempts", String.valueOf(i)));
            }
            messagesByLanguage.put(messagesSettings.getType(), new CachedArrayPackets(messageAttempts));
        }
        this.messagesByLanguage = new CachedMessagesByLanguage(this.languageManager, Collections.unmodifiableMap(messagesByLanguage));
        this.lazyLoaded = true;
    }

    @Override
    public void unload() {
        if (!this.lazyLoaded) {
            return;
        }
        this.messagesByLanguage.release();
        this.lazyLoaded = false;
    }
}

