/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import net.md_5.bungee.protocol.Protocol;
import net.shieldcommunity.nullcordx.antibot.CheckingFactoriesImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FallCheck;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.checking.AbstractVirtualChecking;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.checking.ConditionData;
import net.shieldcommunity.nullcordx.api.checking.LazyLoadedCheckingFactory;
import net.shieldcommunity.nullcordx.cache.CachedFallData;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.cache.CachedPerVersionFallData;
import net.shieldcommunity.nullcordx.cache.EmptyCachedPacket;
import net.shieldcommunity.nullcordx.cache.FallDataManager;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolBlockType;
import net.shieldcommunity.nullcordx.protocol.ProtocolPosition;
import net.shieldcommunity.nullcordx.protocol.ProtocolRelativePositionType;
import net.shieldcommunity.nullcordx.protocol.packets.BlockUpdatePacket;
import net.shieldcommunity.nullcordx.protocol.packets.SynchronizePlayerPositionPacket;

public class FallCheckFactory
extends LazyLoadedCheckingFactory {
    private final AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_CHECK_TEMPLATE data;
    private final ForkJoinPool executor;
    private final CheckingFactoriesImpl checkingFactories;
    private ByteBufPacket tempCachedBlockPlacePacket = new EmptyCachedPacket();
    private ByteBufPacket tempCachedBlockRemovePacket = new EmptyCachedPacket();
    private ByteBufPacket cachedSynchronizePlayerPosition = new EmptyCachedPacket();
    private CachedPerVersionFallData cachedFallDataForJavaList = new CachedPerVersionFallData(new Int2ObjectOpenHashMap<List<CachedFallData>>());
    private CachedPerVersionFallData cachedFallDataForGeyserList = new CachedPerVersionFallData(new Int2ObjectOpenHashMap<List<CachedFallData>>());

    public FallCheckFactory(String name, ConditionData conditionData, AntibotSettings.ANTIBOT.MODES_TEMPLATES.FALL_CHECK_TEMPLATE data, ForkJoinPool executor, CheckingFactoriesImpl checkingFactories) {
        super(name, conditionData);
        this.data = data;
        this.executor = executor;
        this.checkingFactories = checkingFactories;
    }

    @Override
    public AbstractVirtualChecking createChecking(CheckingUser connector, NullCordX nullCordX) {
        return new FallCheck(this, connector, nullCordX, this.data.MAX_CHECK_TIME, this.data.MIN_HEIGHT_RESET, this.cachedSynchronizePlayerPosition, connector.isGeyser() ? this.cachedFallDataForGeyserList : this.cachedFallDataForJavaList, this.tempCachedBlockPlacePacket, this.tempCachedBlockRemovePacket);
    }

    public Class<? extends AbstractVirtualChecking> getType() {
        return FallCheck.class;
    }

    @Override
    public void lazyLoad() {
        if (this.lazyLoaded) {
            return;
        }
        HashSet<ProtocolBlockType> blockTypes = new HashSet<ProtocolBlockType>();
        for (String block : this.data.HIT_PLATFORM_BLOCKS) {
            ProtocolBlockType blockType;
            if (block.equalsIgnoreCase("*")) {
                blockTypes.addAll(ProtocolBlockType.getDefaultBlocks());
                continue;
            }
            try {
                blockType = ProtocolBlockType.valueOf(block.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                this.checkingFactories.getLogger().warning("Failed to parse block type '" + block + "' for fall check '" + this.getName() + "'");
                continue;
            }
            blockTypes.add(blockType);
        }
        AntibotSettings.ANTIBOT.DIMENSION.LOCATION location = AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION;
        this.cachedSynchronizePlayerPosition = CachedPacket.create(new SynchronizePlayerPositionPacket(location.X, this.data.SPAWN_HEIGHT, location.Z, 90.0f, 0.0f, this.checkingFactories.getWaitingTeleportId(), new ProtocolRelativePositionType[0]), Protocol.FILTER);
        this.tempCachedBlockPlacePacket = FallCheckFactory.createSingleBlock(new ProtocolPosition((int)location.X, this.data.SPAWN_HEIGHT - 1, (int)location.Z), ProtocolBlockType.STONE);
        this.tempCachedBlockRemovePacket = FallCheckFactory.createSingleBlock(new ProtocolPosition((int)location.X, this.data.SPAWN_HEIGHT - 1, (int)location.Z), ProtocolBlockType.AIR);
        this.cachedFallDataForJavaList = FallDataManager.createCachedPerVersionFallData(this.executor, this.data.SPAWN_HEIGHT, this.data.HIT_PLATFORM_MIN_HEIGHT, this.data.HIT_PLATFORM_MAX_HEIGHT, this.data.HIT_PLATFORM_ENABLED, false, blockTypes);
        this.cachedFallDataForGeyserList = FallDataManager.createCachedPerVersionFallData(this.executor, this.data.SPAWN_HEIGHT, this.data.HIT_PLATFORM_MIN_HEIGHT, this.data.HIT_PLATFORM_MAX_HEIGHT, this.data.HIT_PLATFORM_ENABLED, true, blockTypes);
        this.lazyLoaded = true;
    }

    @Override
    public void unload() {
        if (!this.lazyLoaded) {
            return;
        }
        this.tempCachedBlockPlacePacket.release();
        this.tempCachedBlockRemovePacket.release();
        this.cachedSynchronizePlayerPosition.release();
        this.cachedFallDataForJavaList.release();
        this.cachedFallDataForGeyserList.release();
        this.lazyLoaded = false;
    }

    public static ByteBufPacket createSingleBlock(ProtocolPosition position, ProtocolBlockType type) {
        return CachedPacket.create(new BlockUpdatePacket(position, type), Protocol.FILTER);
    }
}

