/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.BungeeCord;
import net.shieldcommunity.nullcordx.antibot.AntiBotManagerImpl;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.HandCaptchaCheck;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.api.cache.CachedSpawnEntityItemFramePacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.cache.cachedframes.CachedFramesFramedCaptcha;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.api.utils.location.Location3D;
import net.shieldcommunity.nullcordx.api.utils.location.Vector3D;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;
import net.shieldcommunity.nullcordx.protocol.packets.EntityInteractPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionAndLookPacket;
import net.shieldcommunity.nullcordx.protocol.packets.PlayerPositionPacket;

public class FramedCaptchaCheck
extends HandCaptchaCheck {
    private final AntiBotManagerImpl antiBotManager;
    protected Int2ObjectMap<FrameRotation> rotatedFramesByEntityId = null;
    protected Int2ObjectMap<FrameRotation> rotatedFramesByMapId = null;
    protected CachedEntityFrameData entityFrameData = null;
    private long entityInteractCooldown = System.currentTimeMillis();
    private int entityInteractFactViolations = 0;
    private Location3D oldLocation;
    private Location3D currentLocation;
    private final Set<ReceivedLocation> receivedLocations;
    private final Set<ReceivedClick> receivedClicks;

    public FramedCaptchaCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix, messagesAttemptsByLanguage);
        this.oldLocation = new Location3D(AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION);
        this.currentLocation = new Location3D(AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION);
        this.receivedLocations = new HashSet<ReceivedLocation>();
        this.receivedClicks = new HashSet<ReceivedClick>();
        this.antiBotManager = BungeeCord.getInstance().getNullCordX().getAntiBotManager();
        this.receivedLocations.add(new ReceivedLocation(new Location3D(AntibotSettings.IMP.ANTIBOT.DIMENSION.LOCATION), System.currentTimeMillis()));
    }

    @Override
    public String getName() {
        return "FramedCaptcha";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingFramedCaptcha());
        this.sendCaptcha(flush);
    }

    @Override
    public void onRemoved() {
        if (this.entityFrameData != null) {
            if (this.connector.getProtocolVersion() == 755) {
                this.connector.sendCachedPackets(this.entityFrameData.getCachedRemoveItemFramesLegacy(), true);
            } else {
                this.connector.sendCachedPacket(this.entityFrameData.getCachedRemoveItemFrames(), true);
            }
        }
    }

    @Override
    public void handle(PlayerLookPacket playerLookPacket) throws Exception {
        this.changeLocation(playerLookPacket.getYaw(), playerLookPacket.getPitch());
        super.handle(playerLookPacket);
    }

    @Override
    public void handle(PlayerPositionPacket playerPositionPacket) throws Exception {
        this.changeLocation(playerPositionPacket.getX(), playerPositionPacket.getY(), playerPositionPacket.getZ());
        super.handle(playerPositionPacket);
    }

    @Override
    public void handle(PlayerPositionAndLookPacket playerPositionAndLookPacket) throws Exception {
        this.changeLocation(playerPositionAndLookPacket.getX(), playerPositionAndLookPacket.getY(), playerPositionAndLookPacket.getZ(), playerPositionAndLookPacket.getYaw(), playerPositionAndLookPacket.getPitch());
        super.handle(playerPositionAndLookPacket);
    }

    private void changeLocation(double x, double y, double z, float yaw, float pitch) {
        this.oldLocation = this.currentLocation;
        this.currentLocation = new Location3D(x, y, z, yaw, pitch);
        this.receivedLocations.add(new ReceivedLocation(this.currentLocation, System.currentTimeMillis()));
    }

    private void changeLocation(double x, double y, double z) {
        this.oldLocation = this.currentLocation;
        this.currentLocation = new Location3D(x, y, z, this.oldLocation.getYaw(), this.oldLocation.getPitch());
        this.receivedLocations.add(new ReceivedLocation(this.currentLocation, System.currentTimeMillis()));
    }

    private void changeLocation(float yaw, float pitch) {
        this.oldLocation = this.currentLocation;
        this.currentLocation = new Location3D(this.oldLocation.getX(), this.oldLocation.getY(), this.oldLocation.getZ(), yaw, pitch);
        this.receivedLocations.add(new ReceivedLocation(this.currentLocation, System.currentTimeMillis()));
    }

    @Override
    public void handle(EntityInteractPacket entityInteractPacket) throws Exception {
        if (this.rotatedFramesByEntityId == null) {
            return;
        }
        int type = entityInteractPacket.getType();
        if (type < 0 || type > 2) {
            this.complete(KickType.FAILED_CAPTCHA, "Wrong interact type! We got " + type);
            return;
        }
        if (entityInteractPacket.getHand() != 0) {
            return;
        }
        if (type == 0 || type == 1) {
            int entityId = entityInteractPacket.getEntityId();
            FrameRotation frameRotation = (FrameRotation)this.rotatedFramesByEntityId.get(entityId);
            if (frameRotation == null) {
                this.complete(KickType.FAILED_CAPTCHA, "Wrong interacted entity id! We got " + entityId);
                return;
            }
            if (System.currentTimeMillis() - this.entityInteractCooldown <= (long)AntibotSettings.IMP.ANTIBOT.DIMENSION.ITEM_FRAME.MAX_ROTATION_COOLDOWN) {
                if (this.entityInteractFactViolations >= AntibotSettings.IMP.ANTIBOT.DIMENSION.ITEM_FRAME.MAX_ROTATION_VIOLATIONS) {
                    this.complete(KickType.FAILED_CAPTCHA, "Too fast entity interaction!");
                    return;
                }
                ++this.entityInteractFactViolations;
                return;
            }
            this.entityInteractCooldown = System.currentTimeMillis();
            this.receivedClicks.add(new ReceivedClick(frameRotation, System.currentTimeMillis()));
            this.onFrameRotation(frameRotation, type, entityId);
        }
    }

    public void updateRotationAtFrame(int entityId, ProtocolItemFrameRotationType rotate) {
        this.connector.sendCachedPacket(this.entityFrameData.getRightFrameMetaByIdAndRotation(entityId, rotate), true);
    }

    public void onFrameRotation(FrameRotation frameRotation, int type, int entityId) {
        ProtocolItemFrameRotationType rotate = frameRotation.getRotation();
        rotate = type == 0 ? rotate.getNextRotation() : rotate.getPrevRotation();
        this.updateRotationAtFrame(entityId, rotate);
        frameRotation.setRotation(rotate);
    }

    @Override
    public void onScheduledTask() {
        this.connector.sendCachedPacketWithDelay(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingFramedCaptcha(), AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
    }

    @Override
    public void sendCaptcha(boolean flush) {
        CaptchaHolder<? extends CachedFramesFramedCaptcha<? extends ByteBufPacket>> holder;
        if (this.entityFrameData != null) {
            if (this.connector.getProtocolVersion() == 755) {
                this.connector.sendCachedPackets(this.entityFrameData.getCachedRemoveItemFramesLegacy());
            } else {
                this.connector.sendCachedPacket(this.entityFrameData.getCachedRemoveItemFrames());
            }
        }
        if ((holder = this.nullCordX.getCachedCaptchaManager().getCachedFramedCaptchaPackets().randomCaptcha()) == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        CachedFramesFramedCaptcha<? extends ByteBufPacket> cachedFrames = holder.getCaptcha();
        this.entityFrameData = cachedFrames.getEntityFrameData();
        this.resetFrameRotations(this.entityFrameData);
        this.spawnEntityFrames();
        Collection<ByteBufPacket> metas = this.entityFrameData.getFrameMetaByRotation(ProtocolItemFrameRotationType.UP).values();
        for (ByteBufPacket meta : metas) {
            this.connector.sendCachedPacket(meta);
        }
        this.captchaAnswerGenerator = holder.getAnswer();
        for (ByteBufPacket packet : cachedFrames.getFrames()) {
            this.connector.sendCachedPacket(packet);
        }
        this.teleportToCaptcha();
        if (flush) {
            this.connector.getChannel().getHandle().flush();
        }
    }

    public void teleportToCaptcha() {
        this.teleportToDefaultLocation(false);
        this.connector.awaitTeleportConfirm();
    }

    public void spawnEntityFrames() {
        for (CachedSpawnEntityItemFramePacket entitySpawn : this.entityFrameData.getCachedItemFramesSpawn()) {
            this.connector.sendCachedPacket(entitySpawn);
        }
    }

    @Override
    public void teleportToDefaultLocation(boolean flush) {
        boolean centeredSpawn = false;
        CachedEntityFrameData cachedEntityFrameData = this.entityFrameData;
        if (cachedEntityFrameData != null) {
            centeredSpawn = cachedEntityFrameData.getRows() % 2 == 0;
        }
        this.connector.sendCachedPacket(centeredSpawn ? this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPositionCentered() : this.nullCordX.getCachedPacketManager().getCachedSynchronizePlayerPosition(), flush);
    }

    @Override
    public void onCaptchaComplete(boolean completed) {
        if (this.checkInteractions(completed)) {
            return;
        }
        super.onCaptchaComplete(completed);
    }

    private boolean checkInteractions(boolean completed) {
        double percentThreshold = AntibotSettings.IMP.ANTIBOT.DIMENSION.ITEM_FRAME.PLAYER_DIRECTION_THRESHOLD;
        if (percentThreshold != -1.0) {
            this.antiBotManager.submitUtilsTask(() -> {
                double percent;
                if (this.connector.isDisconnected()) {
                    return;
                }
                if (this.connector.getCurrentChecking() != this) {
                    return;
                }
                ArrayList<ReceivedLocation> foundLocations = new ArrayList<ReceivedLocation>();
                block0: for (ReceivedClick receivedClick : this.receivedClicks) {
                    long clickTime = receivedClick.getTime();
                    for (ReceivedLocation receivedLocation : this.receivedLocations) {
                        if (Math.abs(clickTime - receivedLocation.getTime()) > 100L) continue;
                        foundLocations.add(receivedLocation);
                        continue block0;
                    }
                }
                int count = this.receivedClicks.size();
                int collidedCount = 0;
                block2: for (ReceivedClick receivedClick : this.receivedClicks) {
                    for (ReceivedLocation receivedLocation : foundLocations) {
                        if (!this.startRaytracingToBoundingBox(receivedClick.getRotationData().getAxisAlignedBounding(), receivedLocation.getLocation3D())) continue;
                        ++collidedCount;
                        continue block2;
                    }
                }
                if (count > 0 && (percent = 1.0 / (double)count * (double)collidedCount) < percentThreshold) {
                    this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                        if (this.connector.isDisconnected()) {
                            return;
                        }
                        if (this.connector.getCurrentChecking() != this) {
                            return;
                        }
                        this.complete(KickType.FAILED_CAPTCHA, "Failed direction check");
                    });
                    return;
                }
                this.connector.getChannel().getHandle().eventLoop().execute(() -> {
                    if (this.connector.isDisconnected()) {
                        return;
                    }
                    if (this.connector.getCurrentChecking() != this) {
                        return;
                    }
                    super.onCaptchaComplete(completed);
                });
            });
            return true;
        }
        return false;
    }

    private boolean startRaytracingToBoundingBox(AxisAlignedBounding axisAlignedBounding, Location3D from) {
        Vector3D headDirection = Vector3D.getDirection(from.getYaw(), from.getPitch());
        double maxRange = 3.2;
        double maxStep = 0.05;
        double maxIterations = maxRange / maxStep;
        Vector3D step = headDirection.copy().normalize().multiply(Vector3D.of(maxStep, maxStep, maxStep));
        double headHeight = 1.62;
        Vector3D currentPosition = Vector3D.of(from.getX(), from.getY() + headHeight, from.getZ());
        int i = 0;
        while ((double)i < maxIterations) {
            boolean inside = axisAlignedBounding.isInside(currentPosition);
            if (inside) {
                return true;
            }
            currentPosition.add(step);
            ++i;
        }
        return false;
    }

    public void resetFrameRotations(CachedEntityFrameData entityFrameData) {
        Int2ObjectOpenHashMap<FrameRotation> rotatedFramesByEntityId = new Int2ObjectOpenHashMap<FrameRotation>();
        Int2ObjectOpenHashMap<FrameRotation> rotatedFramesByMapId = new Int2ObjectOpenHashMap<FrameRotation>();
        for (CachedSpawnEntityItemFramePacket cachedSpawnEntityItemFramePacket : entityFrameData.getCachedItemFramesSpawn()) {
            int entityId = cachedSpawnEntityItemFramePacket.getEntityId();
            int mapId = cachedSpawnEntityItemFramePacket.getMapId();
            double x = cachedSpawnEntityItemFramePacket.getX();
            double y = cachedSpawnEntityItemFramePacket.getY();
            double z = cachedSpawnEntityItemFramePacket.getZ();
            AxisAlignedBounding axisAlignedBounding = cachedSpawnEntityItemFramePacket.getAxisAlignedBounding();
            FrameRotation frameRotation = new FrameRotation(entityId, x, y, z, axisAlignedBounding);
            rotatedFramesByEntityId.put(entityId, frameRotation);
            rotatedFramesByMapId.put(mapId, frameRotation);
        }
        this.rotatedFramesByEntityId = rotatedFramesByEntityId;
        this.rotatedFramesByMapId = rotatedFramesByMapId;
        this.entityInteractFactViolations = 0;
        this.receivedLocations.clear();
        this.receivedClicks.clear();
    }

    public static final class ReceivedLocation {
        private final Location3D location3D;
        private final long time;

        public ReceivedLocation(Location3D location3D, long time) {
            this.location3D = location3D;
            this.time = time;
        }

        public Location3D getLocation3D() {
            return this.location3D;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceivedLocation)) {
                return false;
            }
            ReceivedLocation other = (ReceivedLocation)o;
            if (this.getTime() != other.getTime()) {
                return false;
            }
            Location3D this$location3D = this.getLocation3D();
            Location3D other$location3D = other.getLocation3D();
            return !(this$location3D == null ? other$location3D != null : !((Object)this$location3D).equals(other$location3D));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            Location3D $location3D = this.getLocation3D();
            result = result * 59 + ($location3D == null ? 43 : ((Object)$location3D).hashCode());
            return result;
        }

        public String toString() {
            return "FramedCaptchaCheck.ReceivedLocation(location3D=" + this.getLocation3D() + ", time=" + this.getTime() + ")";
        }
    }

    public static class FrameRotation {
        private final int frameEntityId;
        private final double x;
        private final double y;
        private final double z;
        private final AxisAlignedBounding axisAlignedBounding;
        private ProtocolItemFrameRotationType rotation = ProtocolItemFrameRotationType.UP;

        public int getFrameEntityId() {
            return this.frameEntityId;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public AxisAlignedBounding getAxisAlignedBounding() {
            return this.axisAlignedBounding;
        }

        public ProtocolItemFrameRotationType getRotation() {
            return this.rotation;
        }

        public void setRotation(ProtocolItemFrameRotationType rotation) {
            this.rotation = rotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FrameRotation)) {
                return false;
            }
            FrameRotation other = (FrameRotation)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFrameEntityId() != other.getFrameEntityId()) {
                return false;
            }
            if (Double.compare(this.getX(), other.getX()) != 0) {
                return false;
            }
            if (Double.compare(this.getY(), other.getY()) != 0) {
                return false;
            }
            if (Double.compare(this.getZ(), other.getZ()) != 0) {
                return false;
            }
            AxisAlignedBounding this$axisAlignedBounding = this.getAxisAlignedBounding();
            AxisAlignedBounding other$axisAlignedBounding = other.getAxisAlignedBounding();
            if (this$axisAlignedBounding == null ? other$axisAlignedBounding != null : !this$axisAlignedBounding.equals(other$axisAlignedBounding)) {
                return false;
            }
            ProtocolItemFrameRotationType this$rotation = this.getRotation();
            ProtocolItemFrameRotationType other$rotation = other.getRotation();
            return !(this$rotation == null ? other$rotation != null : !((Object)((Object)this$rotation)).equals((Object)other$rotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FrameRotation;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFrameEntityId();
            long $x = Double.doubleToLongBits(this.getX());
            result = result * 59 + (int)($x >>> 32 ^ $x);
            long $y = Double.doubleToLongBits(this.getY());
            result = result * 59 + (int)($y >>> 32 ^ $y);
            long $z = Double.doubleToLongBits(this.getZ());
            result = result * 59 + (int)($z >>> 32 ^ $z);
            AxisAlignedBounding $axisAlignedBounding = this.getAxisAlignedBounding();
            result = result * 59 + ($axisAlignedBounding == null ? 43 : $axisAlignedBounding.hashCode());
            ProtocolItemFrameRotationType $rotation = this.getRotation();
            result = result * 59 + ($rotation == null ? 43 : ((Object)((Object)$rotation)).hashCode());
            return result;
        }

        public String toString() {
            return "FramedCaptchaCheck.FrameRotation(frameEntityId=" + this.getFrameEntityId() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", axisAlignedBounding=" + this.getAxisAlignedBounding() + ", rotation=" + this.getRotation() + ")";
        }

        public FrameRotation(int frameEntityId, double x, double y, double z, AxisAlignedBounding axisAlignedBounding) {
            this.frameEntityId = frameEntityId;
            this.x = x;
            this.y = y;
            this.z = z;
            this.axisAlignedBounding = axisAlignedBounding;
        }
    }

    public static final class ReceivedClick {
        private final FrameRotation rotationData;
        private final long time;

        public ReceivedClick(FrameRotation rotationData, long time) {
            this.rotationData = rotationData;
            this.time = time;
        }

        public FrameRotation getRotationData() {
            return this.rotationData;
        }

        public long getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReceivedClick)) {
                return false;
            }
            ReceivedClick other = (ReceivedClick)o;
            if (this.getTime() != other.getTime()) {
                return false;
            }
            FrameRotation this$rotationData = this.getRotationData();
            FrameRotation other$rotationData = other.getRotationData();
            return !(this$rotationData == null ? other$rotationData != null : !((Object)this$rotationData).equals(other$rotationData));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            FrameRotation $rotationData = this.getRotationData();
            result = result * 59 + ($rotationData == null ? 43 : ((Object)$rotationData).hashCode());
            return result;
        }

        public String toString() {
            return "FramedCaptchaCheck.ReceivedClick(rotationData=" + this.getRotationData() + ", time=" + this.getTime() + ")";
        }
    }
}

