/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks;

import java.util.Collection;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.FramedCaptchaCheck;
import net.shieldcommunity.nullcordx.api.KickType;
import net.shieldcommunity.nullcordx.api.NullCordX;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedCaptchaMessages;
import net.shieldcommunity.nullcordx.api.cache.CachedEntityFrameData;
import net.shieldcommunity.nullcordx.api.cache.CachedSpawnEntityItemFramePacket;
import net.shieldcommunity.nullcordx.api.cache.CaptchaHolder;
import net.shieldcommunity.nullcordx.api.cache.cachedframes.CachedFramesPickCaptcha;
import net.shieldcommunity.nullcordx.api.checking.CheckingFactory;
import net.shieldcommunity.nullcordx.api.checking.CheckingUser;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.cache.CachedArrayPackets;
import net.shieldcommunity.nullcordx.cache.CachedMessagesByLanguage;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.protocol.ProtocolItemFrameRotationType;

public class PickCaptchaCheck
extends FramedCaptchaCheck {
    private String mainTheme;
    private Int2ObjectMap<String> answerPerMapId = null;
    private Int2ObjectMap<FrameAnswer> currentAnswerFramesByEntityId = null;

    public PickCaptchaCheck(CheckingFactory checkingFactory, CheckingUser connector, NullCordX nullCordX, AxisAlignedBounding axisAlignedBounding, int maxAttempts, int maxSolves, boolean newCaptchaOnFail, String answerPrefix, CachedMessagesByLanguage<CachedArrayPackets> messagesAttemptsByLanguage) {
        super(checkingFactory, connector, nullCordX, axisAlignedBounding, maxAttempts, maxSolves, newCaptchaOnFail, answerPrefix, messagesAttemptsByLanguage);
    }

    @Override
    public String getName() {
        return "PickCaptcha";
    }

    @Override
    public void onAdded(boolean flush) {
        this.connector.disableFalling();
        this.sendCaptcha(flush);
    }

    @Override
    public void sendCaptcha(boolean flush) {
        CaptchaHolder<? extends CachedFramesPickCaptcha<? extends ByteBufPacket>> holder;
        if (this.entityFrameData != null) {
            if (this.connector.getProtocolVersion() == 755) {
                this.connector.sendCachedPackets(this.entityFrameData.getCachedRemoveItemFramesLegacy());
            } else {
                this.connector.sendCachedPacket(this.entityFrameData.getCachedRemoveItemFrames());
            }
        }
        if ((holder = this.nullCordX.getCachedCaptchaManager().getCachedPickCaptchaPackets().randomCaptcha()) == null) {
            this.complete(KickType.FAILED_CAPTCHA, this.getName() + " was not generated");
            return;
        }
        CachedFramesPickCaptcha<? extends ByteBufPacket> cachedFrames = holder.getCaptcha();
        this.mainTheme = cachedFrames.getMainTheme();
        this.answerPerMapId = cachedFrames.getAnswerPerFrame();
        this.entityFrameData = cachedFrames.getEntityFrameData();
        this.resetFrameRotations(this.entityFrameData);
        this.resetFrameAnswers(this.entityFrameData);
        this.spawnEntityFrames();
        Collection<ByteBufPacket> metas = this.entityFrameData.getFrameMetaByRotation(ProtocolItemFrameRotationType.UP).values();
        for (ByteBufPacket meta : metas) {
            this.connector.sendCachedPacket(meta);
        }
        for (ByteBufPacket packet : cachedFrames.getFrames()) {
            this.connector.sendCachedPacket(packet);
        }
        ByteBufPacket messagePacket = this.getMessageAbout();
        if (messagePacket != null) {
            this.connector.sendCachedPacket(messagePacket);
        }
        this.teleportToCaptcha();
        if (flush) {
            this.connector.getChannel().getHandle().flush();
        }
    }

    @Override
    public void onScheduledTask() {
        ByteBufPacket messagePacket = this.getMessageAbout();
        if (messagePacket != null) {
            this.connector.sendCachedPacketWithDelay(messagePacket, AntibotSettings.IMP.ANTIBOT.DIMENSION.MESSAGES.CHECKING_MESSAGES_DELAY);
        }
    }

    private ByteBufPacket getMessageAbout() {
        CachedCaptchaMessages cachedCaptchaMessages = this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedPickCaptchaMessages();
        if (cachedCaptchaMessages != null && this.mainTheme != null) {
            return cachedCaptchaMessages.getMessage(this.mainTheme);
        }
        return null;
    }

    @Override
    public void onMessageReceived(String message) {
        int themeCount = this.countAllPossibleAnswers();
        if (themeCount == 0) {
            this.connector.sendCachedPacket(this.nullCordX.getCachedPacketManager().getCachedMessagesByLanguage(this.connector.getLanguageType()).getCachedMessageCheckingMoreCaptcha());
            this.sendCaptcha(true);
            return;
        }
        int solvedCount = 0;
        int unsolvedCount = 0;
        for (FrameAnswer frameAnswer : this.currentAnswerFramesByEntityId.values()) {
            if (!frameAnswer.isClicked()) continue;
            if (this.mainTheme != null && this.mainTheme.equals(frameAnswer.getAnswer())) {
                ++solvedCount;
                continue;
            }
            ++unsolvedCount;
        }
        if (themeCount == solvedCount && unsolvedCount == 0) {
            this.onCaptchaComplete(true);
            return;
        }
        this.onCaptchaComplete(false);
    }

    private int countAllPossibleAnswers() {
        int count = 0;
        for (FrameAnswer frameAnswer : this.currentAnswerFramesByEntityId.values()) {
            String answer = frameAnswer.getAnswer();
            if (answer == null || this.mainTheme == null || !this.mainTheme.equals(answer)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void onFrameRotation(FramedCaptchaCheck.FrameRotation frameRotation, int type, int entityId) {
        FrameAnswer frameAnswer;
        frameAnswer.setClicked(!(frameAnswer = (FrameAnswer)this.currentAnswerFramesByEntityId.get(entityId)).isClicked());
        ByteBufPacket packet = frameAnswer.isClicked() ? this.entityFrameData.getEmptyFrameMetadata(entityId) : this.entityFrameData.getRightFrameMetaByIdAndRotation(entityId, ProtocolItemFrameRotationType.UP);
        this.connector.sendCachedPacket(packet, true);
    }

    public void resetFrameAnswers(CachedEntityFrameData entityFrameData) {
        Int2ObjectOpenHashMap<FrameAnswer> currentAnswerFramesByEntityId = new Int2ObjectOpenHashMap<FrameAnswer>();
        for (CachedSpawnEntityItemFramePacket cachedSpawnEntityItemFramePacket : entityFrameData.getCachedItemFramesSpawn()) {
            int entityId = cachedSpawnEntityItemFramePacket.getEntityId();
            int mapId = cachedSpawnEntityItemFramePacket.getMapId();
            String answer = (String)this.answerPerMapId.get(mapId);
            currentAnswerFramesByEntityId.put(entityId, new FrameAnswer(entityId, answer));
        }
        this.currentAnswerFramesByEntityId = currentAnswerFramesByEntityId;
    }

    public static class FrameAnswer {
        private final int entityId;
        private final String answer;
        private boolean clicked = false;

        public int getEntityId() {
            return this.entityId;
        }

        public String getAnswer() {
            return this.answer;
        }

        public boolean isClicked() {
            return this.clicked;
        }

        public void setClicked(boolean clicked) {
            this.clicked = clicked;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FrameAnswer)) {
                return false;
            }
            FrameAnswer other = (FrameAnswer)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getEntityId() != other.getEntityId()) {
                return false;
            }
            if (this.isClicked() != other.isClicked()) {
                return false;
            }
            String this$answer = this.getAnswer();
            String other$answer = other.getAnswer();
            return !(this$answer == null ? other$answer != null : !this$answer.equals(other$answer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FrameAnswer;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getEntityId();
            result = result * 59 + (this.isClicked() ? 79 : 97);
            String $answer = this.getAnswer();
            result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
            return result;
        }

        public String toString() {
            return "PickCaptchaCheck.FrameAnswer(entityId=" + this.getEntityId() + ", answer=" + this.getAnswer() + ", clicked=" + this.isClicked() + ")";
        }

        public FrameAnswer(int entityId, String answer) {
            this.entityId = entityId;
            this.answer = answer;
        }
    }
}

