/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks.answer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.BitSet;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.GlyphsBounds;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedGlyph;
import net.shieldcommunity.nullcordx.api.cache.CaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;

public abstract class AbstractCaptchaAnswerGenerator
implements CaptchaAnswerGenerator {
    protected final PerRaCStorage<FontListData> fonts;

    @Override
    public abstract String getAnswer();

    public abstract void generateAnswer(Random var1);

    public abstract void draw(Color var1, RenderedFont var2, BufferedImage var3, int var4, int var5, Random var6);

    public abstract AbstractCaptchaAnswerGenerator createCopy();

    public static void drawText(BufferedImage image, RenderedFont font, int color, int fontSpace, boolean randomGlyphHeight, String text, Random random) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] destArray = ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
        GlyphsBounds glyphsBounds = font.createGlyphsBounds(text, fontSpace, random);
        double bw = glyphsBounds.getWidth();
        double cmw = (double)width / 2.0;
        int minHeight = (int)((double)height / 3.0);
        int maxHeight = minHeight + minHeight;
        double randomHeight = minHeight + random.nextInt(maxHeight - minHeight + 1);
        double cbw = bw / 2.0;
        int offsetX = (int)(cmw - cbw);
        for (RenderedGlyph glyph : glyphsBounds.getGlyphs()) {
            int y;
            BitSet data = glyph.getData();
            int localWidth = glyph.getWidth();
            int localHeight = glyph.getHeight();
            int cHeight = localHeight / 2;
            if (randomGlyphHeight) {
                int heightRange = height - localHeight;
                if (heightRange <= 0) {
                    heightRange = 1;
                }
                y = random.nextInt(heightRange);
            } else {
                y = (int)randomHeight - cHeight;
            }
            for (int i = 0; i < localWidth; ++i) {
                for (int j = 0; j < localHeight; ++j) {
                    int localX;
                    int localY;
                    int index;
                    if (!data.get(j * localWidth + i) || (index = (localY = j + y) * width + (localX = i + offsetX)) < 0 || index >= destArray.length) continue;
                    destArray[index] = color;
                }
            }
            offsetX += fontSpace + localWidth;
        }
    }

    public AbstractCaptchaAnswerGenerator(PerRaCStorage<FontListData> fonts) {
        this.fonts = fonts;
    }

    public PerRaCStorage<FontListData> getFonts() {
        return this.fonts;
    }
}

