/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.antibot.virtual.checks.answer;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.shieldcommunity.nullcordx.antibot.captcha.FontListData;
import net.shieldcommunity.nullcordx.antibot.captcha.RenderedFont;
import net.shieldcommunity.nullcordx.antibot.captcha.painter.MapCanvasConstants;
import net.shieldcommunity.nullcordx.antibot.virtual.checks.answer.AbstractCaptchaAnswerGenerator;
import net.shieldcommunity.nullcordx.cache.PerRaCStorage;
import net.shieldcommunity.nullcordx.config.CaptchaSettings;

public class CodeAnswerGenerator
extends AbstractCaptchaAnswerGenerator {
    private final CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE codeAnswerLayerTemplate;
    private String answer;

    public CodeAnswerGenerator(PerRaCStorage<FontListData> fonts, CaptchaSettings.CAPTCHA.RENDER_LAYER_TEMPLATES.CODE_ANSWER_LAYER_TEMPLATE codeAnswerLayerTemplate) {
        super(fonts);
        this.codeAnswerLayerTemplate = codeAnswerLayerTemplate;
    }

    @Override
    public String getAnswer() {
        return this.answer;
    }

    @Override
    public void generateAnswer(Random random) {
        this.answer = this.randomAnswer(random);
    }

    @Override
    public void draw(Color color, RenderedFont renderedFont, BufferedImage image, int width, int height, Random random) {
        CodeAnswerGenerator.drawText(image, renderedFont, color.getRGB(), this.codeAnswerLayerTemplate.FONT_SPACE * MapCanvasConstants.calculateSizeModification(width), this.codeAnswerLayerTemplate.GLYPH_RANDOM_HEIGHT, this.answer, random);
    }

    @Override
    public CodeAnswerGenerator createCopy() {
        return new CodeAnswerGenerator(this.fonts, this.codeAnswerLayerTemplate);
    }

    private String randomAnswer(Random random) {
        int maxLength = this.codeAnswerLayerTemplate.MAX_LENGTH;
        int minLength = this.codeAnswerLayerTemplate.MIN_LENGTH;
        if (minLength < 1) {
            minLength = 1;
        }
        if (maxLength < 1) {
            maxLength = 1;
        }
        int randomLength = minLength + random.nextInt(maxLength - minLength + 1);
        return this.generateRandomString(randomLength, random);
    }

    private String generateRandomString(int length, Random random) {
        StringBuilder randStr = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(this.codeAnswerLayerTemplate.CHAR_SET.length());
            char ch = this.codeAnswerLayerTemplate.CHAR_SET.charAt(number);
            randStr.append(ch);
        }
        return randStr.toString();
    }

    public String toString() {
        return "CodeAnswerGenerator(answer=" + this.getAnswer() + ")";
    }
}

