/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.api.config.messages;

import java.io.BufferedReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.shieldcommunity.nullcordx.api.config.messages.LanguageType;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.chat.modern.ReadyPrefixMessage;
import net.shieldcommunity.nullcordx.config.PrefixSerializable;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.MapType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class MessagesSettings
extends SafeYamlSerializable
implements PrefixSerializable {
    @Transient
    private static final String DEFAULT_PREFIX = "<blue><bold>Null<aqua><bold>Cord<white><bold>X <gray>\u00bb<RESET>";
    @Transient
    private static final PrefixSerializable PREFIX_SERIALIZABLE = new PrefixSerializable(){

        @Override
        public String getPrefix() {
            return MessagesSettings.DEFAULT_PREFIX;
        }

        @Override
        public void setPrefix(String prefix) {
        }
    };
    @Transient
    private static final ReadyComponentMessageSerializer READY_COMPONENT_MESSAGE_SERIALIZER = new ReadyComponentMessageSerializer();
    @Transient
    private final LanguageType type;
    @Transient
    private String prefix = null;
    @Comment(value={@CommentValue(value="Configuration for NullCordX messages."), @CommentValue(value="The default format is MiniMessages, which allows RGB colors and gradients."), @CommentValue(value="For more information: https://docs.advntr.dev/minimessage/index.html"), @CommentValue(value="To create a new line use the placeholder {NL}"), @CommentValue, @CommentValue(value="You can copy this file and rename it for the new language."), @CommentValue(value="The file must be named \"messages_*language*\"."), @CommentValue(value="Where *language* must be the correct country code."), @CommentValue(value="You can find it here: http://www.lingoes.net/en/translator/langcode.htm")})
    public ReadyPrefixMessage PREFIX = new ReadyPrefixMessage("<blue><bold>Null<aqua><bold>Cord<white><bold>X <gray>\u00bb<RESET>");
    public MESSAGES MESSAGES = new MESSAGES();
    public long CONFIG_VERSION = 1L;

    public MessagesSettings(SerializerConfig serializerConfig) {
        this(serializerConfig, null);
    }

    public MessagesSettings(SerializerConfig serializerConfig, LanguageType type) {
        super(serializerConfig);
        this.type = type;
    }

    @Override
    public boolean load(BufferedReader bufferedReader) {
        boolean loadResult = super.load(bufferedReader);
        this.MESSAGES.BUNGEECORD.loadMessages();
        return loadResult;
    }

    private static ReadyComponentMessage rcm(String text) {
        return READY_COMPONENT_MESSAGE_SERIALIZER.deserialize(text);
    }

    public LanguageType getType() {
        return this.type;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    public MESSAGES getMESSAGES() {
        return this.MESSAGES;
    }

    public long getCONFIG_VERSION() {
        return this.CONFIG_VERSION;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessagesSettings)) {
            return false;
        }
        MessagesSettings other = (MessagesSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCONFIG_VERSION() != other.getCONFIG_VERSION()) {
            return false;
        }
        LanguageType this$type = this.getType();
        LanguageType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$PREFIX = this.getPrefix();
        String other$PREFIX = other.getPrefix();
        return !(this$PREFIX == null ? other$PREFIX != null : !this$PREFIX.equals(other$PREFIX));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessagesSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.getCONFIG_VERSION();
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        LanguageType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $PREFIX = this.getPrefix();
        result = result * 59 + ($PREFIX == null ? 43 : $PREFIX.hashCode());
        return result;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    static {
        READY_COMPONENT_MESSAGE_SERIALIZER.setPrefixSerializable(PREFIX_SERIALIZABLE);
    }

    public static class MESSAGES {
        public NULLCORDX NULLCORDX = new NULLCORDX();
        public BUNGEECORD BUNGEECORD = new BUNGEECORD();

        public static class NULLCORDX {
            public ReadyComponentMessage FALL_CHECKING = MessagesSettings.rcm("{PRFX} <green>Checking in progress, please wait...");
            public ReadyComponentMessage EMPTY_CHECKING = MessagesSettings.rcm("{PRFX} <green>Checking in progress, please wait...");
            public ReadyComponentMessage PROXY_CHECKING = MessagesSettings.rcm("{PRFX} <green>Checking in progress, please wait...");
            public ReadyComponentMessage COUNTRY_CHECKING = MessagesSettings.rcm("{PRFX} <green>Checking in progress, please wait...");
            public ReadyComponentMessage ASN_CHECKING = MessagesSettings.rcm("{PRFX} <green>Checking in progress, please wait...");
            public ReadyComponentMessage COMPLETED_SUCCESSFULLY = MessagesSettings.rcm("{PRFX} <green>You have successfully passed the check! :)");
            public ReadyComponentMessage HAND_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Enter the code from the image in the chat.");
            public ReadyComponentMessage ANIMATED_HAND_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Enter the code from the animated image in the chat.");
            public ReadyComponentMessage FRAMED_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Rotate the frame to the correct position if need and then enter the code from the image in the chat.");
            public ReadyComponentMessage ANIMATED_FRAMED_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Rotate the animated frame to the correct position if need and then enter the code from the animated image in the chat.");
            public ReadyComponentMessage FRAMED_PUZZLE = MessagesSettings.rcm("{PRFX} <green>Solve the puzzle by scrolling the frame in the right direction and then enter any text in the chat.");
            public ReadyComponentMessage ANIMATED_FRAMED_PUZZLE = MessagesSettings.rcm("{PRFX} <green>Solve the animated puzzle by scrolling the frame in the right direction and then enter any text in the chat.");
            public ReadyComponentMessage PICK_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Click on all images with the <red><bold><underlined>{TYPE}<reset><green>. If there are no images left, enter any text in the chat.");
            public ReadyComponentMessage CAPTCHA_WRONG = MessagesSettings.rcm("{PRFX} <red>You solved the captcha incorrectly, please try again. <red>You have <green>{ATTEMPTS} <red>attempts left.");
            public ReadyComponentMessage MORE_CAPTCHA = MessagesSettings.rcm("{PRFX} <green>Please solve the captcha again.");
            public ReadyComponentMessage MANY_CHECKS_SAME = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>You have exceeded the number of checks in a short time. {NL}<gold>Please try again later.");
            public ReadyComponentMessage MANY_CHECKS_DIFFERENT = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Suspicious activity detected from your IP. {NL}<gold>Please try again later.");
            public ReadyComponentMessage NOT_PLAYER = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>You failed the verification. Probably you are a bot. {NL}<gray><italic>Notify the administration if this is an error.");
            public ReadyComponentMessage COUNTRY = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Your country is blocked from the server. {NL}<gold>discord.gg/shieldcommunity");
            public ReadyComponentMessage ASN = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Your ASN is blocked from the server. {NL}<gold>discord.gg/shieldcommunity");
            public ReadyComponentMessage PROXY = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>This server is not allowed to access with Proxy or VPN. {NL}<gold>discord.gg/shieldcommunity");
            public ReadyComponentMessage ALREADY_CHECKING = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>You have been kicked because your ip address is still being verified. {NL}<gold>(discord.gg/shieldcommunity)");
            public ReadyComponentMessage CHECKING_ERROR = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>An error occurred while checking your connection. {NL}<gold>Please try again later. {NL}<gold>discord.gg/shieldcommunity");
            public ReadyComponentMessage BIG_PING = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>You have a high and weird ping, try joining again in some minutes.");
            public ReadyComponentMessage BIG_PACKET = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>It seems you sent a big packet!");
            public ReadyComponentMessage TO_MANY_PACKETS = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Looks like you sent too many packets!");
            public ReadyComponentMessage RELOADING = MessagesSettings.rcm("{PRFX} {NL}{NL}<green>Reloading...");
            public ReadyComponentMessage DIRECT_CONNECTION = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Refresh the server list to join the server. {NL}<gold>discord.gg/shieldcommunity");
            public ReadyComponentMessage BLACKLISTED_USERNAME = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Your username is blacklisted!");
            public ReadyComponentMessage BLACKLISTED_BRAND = MessagesSettings.rcm("{PRFX} {NL}{NL}<red>Your client is blacklisted!");
            public ReadyComponentMessage SUCCESSFULLY = MessagesSettings.rcm("{PRFX} {NL}{NL}<green>You have successfully passed the verification, please rejoin to the server!");
            public ReadyComponentMessage CONSOLE_BAN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx ban <address> <dark_aqua>- <white>Block the specified IP address. This is equivalent to how the proxy automatically blocks the IP address in the blacklist");
            public ReadyComponentMessage CONSOLE_BAN_LIST_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx banlist <dark_aqua>- <white>Show all banned ip addresses");
            public ReadyComponentMessage CONSOLE_BAN_LIST_PAGE_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx banlist page <page> <dark_aqua>- <white>Show ip addresses list by page");
            public ReadyComponentMessage CONSOLE_CACHED_ADD_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx cached add <username> <address> <dark_aqua>- <white>Add a player to the cache so that the proxy considers that he passed the check");
            public ReadyComponentMessage CONSOLE_CACHED_INFO_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx cached info <dark_aqua>- <white>Information about the current cache of players");
            public ReadyComponentMessage CONSOLE_CACHED_REMOVE_ALL_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx cached removeall <dark_aqua>- <white>Remove all players from the cache");
            public ReadyComponentMessage CONSOLE_CACHED_REMOVE_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx cached remove <username> <dark_aqua>- <white>Remove the specified player from the cache");
            public ReadyComponentMessage CONSOLE_CAPTCHA_FORCE_REGEN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx captcha forceregen <dark_aqua>- <white>Force regenerate captcha");
            public ReadyComponentMessage CONSOLE_CAPTCHA_REGEN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx captcha regen <dark_aqua>- <white>Regenerate dirty (used) captcha");
            public ReadyComponentMessage CONSOLE_CHECK_CUSTOM_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx check custom <is bedrock [true/false]> <check> <dark_aqua>- <white>Set the specified custom check for the specified check type");
            public ReadyComponentMessage CONSOLE_CPU_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx cpu <dark_aqua>- <white>View proxy resources usage");
            public ReadyComponentMessage CONSOLE_TEST_COMPRESSION_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx testcompression <level> <dark_aqua>- <white>Test the compression speed of all types of compressors with the specified type of compression level");
            public ReadyComponentMessage CONSOLE_DUMP_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx dump <dark_aqua>- <white>Collect all information about the system, environment and all configs and send it to paste service");
            public ReadyComponentMessage CONSOLE_MAIN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx <dark_aqua>- <white>This page");
            public ReadyComponentMessage CONSOLE_MOTD_RELOAD_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx motd reload <dark_aqua>- <white>Reload motd from motd.yml config");
            public ReadyComponentMessage CONSOLE_RELOAD_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx reload <dark_aqua>- <white>Reload NullCordX");
            public ReadyComponentMessage CONSOLE_RESET_STATS_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx reset stats <dark_aqua>- <white>Reset current statistics");
            public ReadyComponentMessage CONSOLE_SERVERS_RELOAD_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx servers reload <dark_aqua>- <white>Reload server list from BungeeCord config");
            public ReadyComponentMessage CONSOLE_TOGGLE_ATTACK_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx toggle {TYPE} <dark_aqua>- <white>Toggle 'under {TYPE} attack' mode");
            public ReadyComponentMessage CONSOLE_TRIGGER_ATTACK_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx trigger {TYPE} <dark_aqua>- <white>Trigger 'under {TYPE} attack' mode");
            public ReadyComponentMessage CONSOLE_UN_TRIGGER_ATTACK_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx untrigger {TYPE} <dark_aqua>- <white>Un trigger 'under {TYPE} attack' mode");
            public ReadyComponentMessage CONSOLE_UNBAN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx unban <address|all> <dark_aqua>- <white>Unblock the ip address that failed the bot check too many times or was blacklisted");
            public ReadyComponentMessage CONSOLE_WHITELIST_ADD_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx whitelist add <username> <dark_aqua>- <white>Add player to whitelist");
            public ReadyComponentMessage CONSOLE_WHITELIST_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx whitelist <dark_aqua>- <white>Show all added players in the whitelist");
            public ReadyComponentMessage CONSOLE_WHITELIST_PAGE_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx whitelist page <page> <dark_aqua>- <white>Show players list by page");
            public ReadyComponentMessage CONSOLE_WHITELIST_REMOVE_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx whitelist remove <username> <dark_aqua>- <white>Remove player from whitelist");
            public ReadyComponentMessage PLAYER_LIVE_STATS_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx {TYPE} <dark_aqua>- <white>Toggle display of {TYPE} statistics");
            public ReadyComponentMessage PLAYER_MAIN_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx <dark_aqua>- <white>Toggle display of live statistics");
            public ReadyComponentMessage COMMON_HELP_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx help <dark_aqua>- <white>This help page");
            public ReadyComponentMessage COMMON_STATS_DESCRIPTION = MessagesSettings.rcm("<aqua>/nullcordx stat|stats|info <dark_aqua>- <white>Show proxy statistics");
            public ReadyComponentMessage INVALID_IP_ADDRESS = MessagesSettings.rcm("{PRFX} Invalid ip address specified!");
            public ReadyComponentMessage IP_ADDRESS_SUCCESSFULLY_BANNED = MessagesSettings.rcm("{PRFX} Ip address '<green>{ADDRESS}<gray>' successfully banned!");
            public ReadyComponentMessage COMMAND_EXECUTE_EXCEPTION = MessagesSettings.rcm("{PRFX} <red>Exception during command execute!");
            public ReadyComponentMessage COMMAND_SUGGEST_EXCEPTION = MessagesSettings.rcm("{PRFX} <red>Exception during suggest!");
            public ReadyComponentMessage DO_NOT_HAVE_PERMISSION = MessagesSettings.rcm("{PRFX} <red>You do not have permissions!");
            public ReadyComponentMessage PAGE_MUST_BE_GREATER = MessagesSettings.rcm("{PRFX} The specified page must be greater than zero.");
            public ReadyComponentMessage PAGE_NOT_FOUND = MessagesSettings.rcm("{PRFX} The specified page was not found.");
            public ReadyComponentMessage TOTAL_OBJECTS = MessagesSettings.rcm("Total <dark_aqua>{COUNT} <white>objects.");
            public ReadyComponentMessage CURRENT_PAGE = MessagesSettings.rcm("Page: <dark_aqua>{CURRENT_PAGE}<white>/<aqua>{MAX_PAGE}");
            public ReadyComponentMessage PAGE_DATA = MessagesSettings.rcm("<aqua>{NUMBER}. <white>{DATA}");
            public ReadyComponentMessage NUMBER_PARSE_FAILED = MessagesSettings.rcm("{PRFX} Failed to parse the number!");
            public ReadyComponentMessage USERNAME_ALREADY_CACHED = MessagesSettings.rcm("{PRFX} Username '<green>{USER}<gray>' already cached!");
            public ReadyComponentMessage SUCCESSFULLY_ADDED_CACHE = MessagesSettings.rcm("{PRFX} '<green>{USER}<gray>' successfully added to the cache!");
            public ReadyComponentMessage CACHED_USERS = MessagesSettings.rcm("{PRFX} Cached users: <green>{COUNT}");
            public ReadyComponentMessage CHECKING_USERS = MessagesSettings.rcm("{PRFX} Checking users: <green>{COUNT}");
            public ReadyComponentMessage ALL_CACHED_PLAYERS_DELETED = MessagesSettings.rcm("{PRFX} All cached players have been deleted successfully!");
            public ReadyComponentMessage USER_IS_NOT_CACHED = MessagesSettings.rcm("{PRFX} Username '<green>{USER}<gray>' is not cached!");
            public ReadyComponentMessage USER_DELETED_FROM_CACHE = MessagesSettings.rcm("{PRFX} '<green>{USER}<gray>' successfully deleted from the cache!");
            public ReadyComponentMessage CAPTCHA_GENERATION_ALREADY_IN_PROGRESS = MessagesSettings.rcm("{PRFX} <red>Captcha generation already in progress!");
            public ReadyComponentMessage CAPTCHA_GENERATION_STARTED = MessagesSettings.rcm("{PRFX} <green>Captcha generation started.");
            public ReadyComponentMessage BOOLEAN_PARSE_FAILED = MessagesSettings.rcm("{PRFX} Failed to parse boolean value. Expected true or false.");
            public ReadyComponentMessage FAILED_FIND_CUSTOM_CHECK = MessagesSettings.rcm("{PRFX} Failed to find custom checking with name '<dark_aqua>{CHECK}<white>'");
            public ReadyComponentMessage CUSTOM_MODE_SET = MessagesSettings.rcm("{PRFX} Successfully set custom mode '<dark_aqua>{CHECK}<white>'");
            public ReadyComponentMessage PROXY_UPTIME = MessagesSettings.rcm("{PRFX} Proxy uptime: <aqua>{UPTIME_DATA} <white>[<gold>{UPTIME_TIME}<white>]");
            public ReadyComponentMessage PROXY_CPU_USAGE = MessagesSettings.rcm("{PRFX} Proxy cpu usage: {CPU} <white>(Threads: <red>{THREADS}<white>)");
            public ReadyComponentMessage PROCESSOR_CPU_USAGE = MessagesSettings.rcm("{PRFX} Processor usage: {CPU} <white>(Cores: <red>{CORES}<white>)");
            public ReadyComponentMessage MAXIMUM_HEAP_MEMORY = MessagesSettings.rcm("{PRFX} Maximum heap memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage TOTAL_HEAP_MEMORY = MessagesSettings.rcm("{PRFX} Total heap memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage FREE_HEAP_MEMORY = MessagesSettings.rcm("{PRFX} Free heap memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage USED_HEAP_MEMORY = MessagesSettings.rcm("{PRFX} Used heap memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage USED_DIRECT_MEMORY = MessagesSettings.rcm("{PRFX} Used direct memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage TOTAL_USED_MEMORY = MessagesSettings.rcm("{PRFX} Total used memory: <aqua>{MEMORY} <white>MB");
            public ReadyComponentMessage START_COLLECT_INFORMATION = MessagesSettings.rcm("{PRFX} Starting to collect information...");
            public ReadyComponentMessage COLLECT_SYSTEM_INFORMATION = MessagesSettings.rcm("{PRFX} Collecting all information about the system...");
            public ReadyComponentMessage SENDING_DUMP = MessagesSettings.rcm("{PRFX} Sending dump to ShieldCommunity\u2122's servers.");
            public ReadyComponentMessage DUMP_UPLOADED = MessagesSettings.rcm("{PRFX} Dump uploaded! You can view the information here: {URL}");
            public ReadyComponentMessage DUMP_FAILED = MessagesSettings.rcm("{PRFX} Failed to send a dump: {ERROR}");
            public ReadyComponentMessage MOTD_RELOADED = MessagesSettings.rcm("{PRFX} MOTD configuration successfully reloaded!");
            public ReadyComponentMessage TRYING_RELOAD = MessagesSettings.rcm("{PRFX} <red>Trying to reload...");
            public ReadyComponentMessage SUCCESSFULLY_RELOADED = MessagesSettings.rcm("{PRFX} <green>Successfully reloaded!");
            public ReadyComponentMessage FAILED_RELOAD = MessagesSettings.rcm("{PRFX} <red>Error: {ERROR}");
            public ReadyComponentMessage FATAL_ERROR_RELOAD = MessagesSettings.rcm("{PRFX} <red>Fatal error while disabling!");
            public ReadyComponentMessage STATS_RESET = MessagesSettings.rcm("{PRFX} Statistics reset successfully.");
            public ReadyComponentMessage SERVERS_RELOADED = MessagesSettings.rcm("{PRFX} Servers successfully reloaded.");
            public ReadyComponentMessage FORCE_ATTACK_MODE = MessagesSettings.rcm("{PRFX} Force {TYPE} attack protection mode {MODE}");
            public ReadyComponentMessage TRIGGER_ATTACK_MODE = MessagesSettings.rcm("{PRFX} Successfully triggered {TYPE} attack protection mode!");
            public ReadyComponentMessage UN_TRIGGER_ATTACK_MODE = MessagesSettings.rcm("{PRFX} Successfully un triggered {TYPE} attack protection mode!");
            public ReadyComponentMessage TEST_COMPRESSION_STARTED = MessagesSettings.rcm("{PRFX} Started compression test, please wait...");
            public ReadyComponentMessage TEST_COMPRESSION_TEST = MessagesSettings.rcm("{PRFX} Starting test for {TYPE} compression...");
            public ReadyComponentMessage TEST_COMPRESSION_RESULT = MessagesSettings.rcm("{PRFX} {TYPE}: Compression speed: {COMPRESSION}/s. Decompression speed: {DECOMPRESSION}/s");
            public ReadyComponentMessage TEST_COMPRESSION_FINISH = MessagesSettings.rcm("{PRFX} Compression test finished in {TIME} ms");
            public ReadyComponentMessage ENABLED = MessagesSettings.rcm("<green>enabled");
            public ReadyComponentMessage DISABLED = MessagesSettings.rcm("<red>disabled");
            public ReadyComponentMessage ALL_ADDRESS_UNBAN = MessagesSettings.rcm("{PRFX} All ip addresses have been successfully unbanned!");
            public ReadyComponentMessage ADDRESS_PARSE_FAILED = MessagesSettings.rcm("{PRFX} Invalid ip address specified!");
            public ReadyComponentMessage ADDRESS_UNBAN = MessagesSettings.rcm("{PRFX} Ip address '<green>{ADDRESS}<gray>' successfully unbanned!");
            public ReadyComponentMessage ALREADY_WHITELISTED = MessagesSettings.rcm("{PRFX} Username '<green>{USER}<gray>' already added to whitelist!");
            public ReadyComponentMessage WHITELIST_ADDED = MessagesSettings.rcm("{PRFX} '<green>{USER}<gray>' successfully added to whitelist!");
            public ReadyComponentMessage WHITELIST_NOT_FOUND = MessagesSettings.rcm("{PRFX} Username '<green>{USER}<gray>' not found on the whitelist!");
            public ReadyComponentMessage WHITELIST_REMOVED = MessagesSettings.rcm("{PRFX} '<green>{USER}<gray>' successfully removed from whitelist!");
            public ReadyComponentMessage LIVE_STATS_CHANGED = MessagesSettings.rcm("{PRFX} <green>Live statistics view changed to '<gold>{TYPE}<green>'");
            public ReadyComponentMessage LIVE_STATS_STOPPED = MessagesSettings.rcm("{PRFX} <red>Live statistics view stopped.");
            public ReadyComponentMessage LIVE_STATS_STARTED = MessagesSettings.rcm("{PRFX} <green>Live statistics view started.");
            public ReadyComponentMessage UNDER_BOT_ATTACK = MessagesSettings.rcm("{PRFX} Under bot attack: <aqua>{MODE}");
            public ReadyComponentMessage UNDER_PING_ATTACK = MessagesSettings.rcm("{PRFX} Under ping attack: <aqua>{MODE}");
            public ReadyComponentMessage UNDER_SPAM_ATTACK = MessagesSettings.rcm("{PRFX} Under spam attack: <aqua>{MODE}");
            public ReadyComponentMessage BOT_COUNTER = MessagesSettings.rcm("{PRFX} Bot counter: <aqua>{COUNT}<dark_gray>/<aqua>{THRESHOLD}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage PING_COUNTER = MessagesSettings.rcm("{PRFX} Ping counter: <aqua>{COUNT}<dark_gray>/<aqua>{THRESHOLD}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage SPAM_COUNTER = MessagesSettings.rcm("{PRFX} Spam counter: <aqua>{COUNT}<dark_gray>/<aqua>{THRESHOLD}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage ONLINE_ON_CHECKING = MessagesSettings.rcm("{PRFX} Online on checking: <aqua>{COUNT}");
            public ReadyComponentMessage CONNECTION_PER_SECOND = MessagesSettings.rcm("{PRFX} Connection per second: <aqua>{COUNT}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage PING_PER_SECOND = MessagesSettings.rcm("{PRFX} Ping per second: <aqua>{COUNT}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage BLOCKED_PER_SECOND = MessagesSettings.rcm("{PRFX} Blocked per second: <aqua>{COUNT}<dark_gray>/<aqua>{MAX}");
            public ReadyComponentMessage TOTAL_CONNECTIONS = MessagesSettings.rcm("{PRFX} Total connections: <aqua>{COUNT}");
            public ReadyComponentMessage TOTAL_BLOCKED = MessagesSettings.rcm("{PRFX} Total blocked: <aqua>{COUNT}");
            public ReadyComponentMessage UPSTREAM_OPENED_CONNECTIONS = MessagesSettings.rcm("{PRFX} Upstream opened connections: <aqua>{COUNT}");
            public ReadyComponentMessage DOWNSTREAM_OPENED_CONNECTIONS = MessagesSettings.rcm("{PRFX} Downstream opened connections: <aqua>{COUNT}");
            public ReadyComponentMessage UPSTREAM_NETWORK = MessagesSettings.rcm("{PRFX} Upstream network: ");
            public ReadyComponentMessage DOWNSTREAM_NETWORK = MessagesSettings.rcm("{PRFX} Downstream network: ");
            public ReadyComponentMessage INPUT_PACKETS_PER_SECOND = MessagesSettings.rcm("{PRFX} Input packets per second: <aqua>{COUNT}");
            public ReadyComponentMessage INPUT_BYTES_PER_SECOND = MessagesSettings.rcm("{PRFX} Input bytes per second: <aqua>{COUNT}");
            public ReadyComponentMessage OUTPUT_PACKETS_PER_SECOND = MessagesSettings.rcm("{PRFX} Output packets per second: <aqua>{COUNT}");
            public ReadyComponentMessage OUTPUT_BYTES_PER_SECOND = MessagesSettings.rcm("{PRFX} Output bytes per second: <aqua>{COUNT}");
            public ReadyComponentMessage TOTAL_INPUT_PACKETS = MessagesSettings.rcm("{PRFX} Total input packets: <aqua>{COUNT}");
            public ReadyComponentMessage TOTAL_INPUT_BYTES = MessagesSettings.rcm("{PRFX} Total input bytes: <aqua>{COUNT}");
            public ReadyComponentMessage TOTAL_OUTPUT_PACKETS = MessagesSettings.rcm("{PRFX} Total output packets: <aqua>{COUNT}");
            public ReadyComponentMessage TOTAL_OUTPUT_BYTES = MessagesSettings.rcm("{PRFX} Total output bytes: <aqua>{COUNT}");
            public ReadyComponentMessage YEARS = MessagesSettings.rcm("years");
            public ReadyComponentMessage MONTHS = MessagesSettings.rcm("months");
            public ReadyComponentMessage WEEKS = MessagesSettings.rcm("weeks");
            public ReadyComponentMessage DAYS = MessagesSettings.rcm("days");
            public ReadyComponentMessage HOURS = MessagesSettings.rcm("hours");
            public ReadyComponentMessage MINUTES = MessagesSettings.rcm("minutes");
            public ReadyComponentMessage SECONDS = MessagesSettings.rcm("seconds");
            @NewLine
            @Comment(value={@CommentValue(value="Translation of each group of abstract objects for pick captcha."), @CommentValue(value="Useful if you want to have a different name for an abstract object for each language."), @CommentValue(value="Usage example: a client using Russian will see not \"cat\" but \"\u043a\u043e\u0448\u043a\u0430\""), @CommentValue(value="Default values are just example.")})
            @MapType(value=LinkedHashMap.class)
            public Map<String, String> PICK_CAPTCHA_TYPES = new LinkedHashMap<String, String>();

            public NULLCORDX() {
                this.PICK_CAPTCHA_TYPES.put("cat", "cat");
            }
        }

        public static class BUNGEECORD {
            public ReadyComponentMessage ALERT = MessagesSettings.rcm("<dark_gray>[<dark_red>Alert<dark_gray>] <reset>");
            public ReadyComponentMessage ALREADY_CONNECTED = MessagesSettings.rcm("<red>You are already connected to this server!");
            public ReadyComponentMessage ALREADY_CONNECTED_PROXY = MessagesSettings.rcm("<red>You are already connected to this proxy!");
            public ReadyComponentMessage ALREADY_CONNECTING = MessagesSettings.rcm("<red>Already connecting to this server!");
            public ReadyComponentMessage COMMAND_LIST = MessagesSettings.rcm("<green>[{SERVER}] <yellow>({COUNT}): <reset>{PLAYERS}");
            public ReadyComponentMessage CONNECT_KICK = MessagesSettings.rcm("<red>Kicked whilst connecting to {TARGET}: {REASON}");
            public ReadyComponentMessage CURRENT_SERVER = MessagesSettings.rcm("<gold>You are currently connected to {SERVER}.");
            public ReadyComponentMessage FALLBACK_KICK = MessagesSettings.rcm("<red>Could not connect to a default or fallback server. Incorrectly configured address/port/firewall? {CAUSE}");
            public ReadyComponentMessage FALLBACK_LOBBY = MessagesSettings.rcm("<red>Could not connect to target server, you have been moved to a fallback server.");
            public ReadyComponentMessage LOST_CONNECTION = MessagesSettings.rcm("<red>Proxy lost connection to server.");
            public ReadyComponentMessage MOJANG_FAIL = MessagesSettings.rcm("<red>Error occurred while contacting login servers, are they down?");
            public ReadyComponentMessage NO_PERMISSION = MessagesSettings.rcm("<red>You do not have permission to execute this command!");
            public ReadyComponentMessage NO_SERVER = MessagesSettings.rcm("<red>The specified server does not exist.");
            public ReadyComponentMessage NO_SERVER_PERMISSION = MessagesSettings.rcm("<red>You don''t have permission to access this server.");
            public ReadyComponentMessage OUTDATED_CLIENT = MessagesSettings.rcm("<red>Outdated client! Please use {VERSION}");
            public ReadyComponentMessage OUTDATED_SERVER = MessagesSettings.rcm("<red>Outdated server! I''m still on {VERSION}");
            public ReadyComponentMessage PROXY_FULL = MessagesSettings.rcm("<red>Server is full!");
            public ReadyComponentMessage RESTART = MessagesSettings.rcm("<red>The proxy server is restarting");
            public ReadyComponentMessage SERVER_LIST = MessagesSettings.rcm("<gold>You may connect to the following servers at this time: ");
            public ReadyComponentMessage SERVER_WENT_DOWN = MessagesSettings.rcm("<red>The server you were previously on went down, you have been connected to a fallback server");
            public ReadyComponentMessage TOTAL_PLAYERS = MessagesSettings.rcm("Total players online: {COUNT}");
            public ReadyComponentMessage NAME_INVALID = MessagesSettings.rcm("<red>Username contains invalid characters.");
            public ReadyComponentMessage PING_CANNOT_CONNECT = MessagesSettings.rcm("<red>Could not request status from target server.");
            public ReadyComponentMessage OFFLINE_MODE_PLAYER = MessagesSettings.rcm("<red>Not authenticated with Minecraft.net");
            public ReadyComponentMessage SECURE_PROFILE_REQUIRED = MessagesSettings.rcm("<red>A secure profile is required to join this server.");
            public ReadyComponentMessage SECURE_PROFILE_EXPIRED = MessagesSettings.rcm("<red>Secure profile expired.");
            public ReadyComponentMessage SECURE_PROFILE_INVALID = MessagesSettings.rcm("<red>Secure profile invalid.");
            public ReadyComponentMessage SECURE_PROFILE_UNSUPPORTED = MessagesSettings.rcm("<red>Outdated client, secure profile not supported. Please use 1.19 or newer.");
            public ReadyComponentMessage MESSAGE_NEEDED = MessagesSettings.rcm("<red>You must supply a message.");
            public ReadyComponentMessage ERROR_OCCURRED_PLAYER = MessagesSettings.rcm("<red>An error occurred while parsing your message. (Hover for details)");
            public ReadyComponentMessage ERROR_OCCURRED_CONSOLE = MessagesSettings.rcm("<red>An error occurred while parsing your message: {ERROR}");
            public ReadyComponentMessage ERROR_OCCURRED_CONNECTION = MessagesSettings.rcm("<red>An error has occurred in your connection");
            public ReadyComponentMessage CLICK_TO_CONNECT = MessagesSettings.rcm("Click to connect to the server");
            public ReadyComponentMessage USERNAME_NEEDED = MessagesSettings.rcm("<red>Please follow this command by a username.");
            public ReadyComponentMessage USER_NOT_ONLINE = MessagesSettings.rcm("<red>That user is not online.");
            public ReadyComponentMessage USER_ONLINE_AT = MessagesSettings.rcm("<green>{PLAYER} <reset>is online at {SERVER}");
            public ReadyComponentMessage SEND_CMD_USAGE = MessagesSettings.rcm("<red>Not enough arguments, usage: /send <server|player|all|current> <target>");
            public ReadyComponentMessage PLAYER_ONLY = MessagesSettings.rcm("<red>Only in game players can use this command!");
            public ReadyComponentMessage YOU_GOT_SUMMONED = MessagesSettings.rcm("<gold>Summoned to {TARGET} by {SENDER}");
            public ReadyComponentMessage COMMAND_PERMS_GROUPS = MessagesSettings.rcm("<gold>You have the following groups: {GROUPS}");
            public ReadyComponentMessage COMMAND_PERMS_PERMISSION = MessagesSettings.rcm("<blue>- {PERMISSION}");
            public ReadyComponentMessage COMMAND_IP = MessagesSettings.rcm("<blue>IP of {TARGET} is {ADDRESS}");
            public ReadyComponentMessage ILLEGAL_CHAT_CHARACTERS = MessagesSettings.rcm("<red>Illegal characters in chat ({UNICODE})");
            public ReadyComponentMessage KICK_MESSAGE = MessagesSettings.rcm("<red>You have been kicked off the proxy.");
            public ReadyComponentMessage NAME_TOO_LONG = MessagesSettings.rcm("<red>Name too long!");
            public ReadyComponentMessage CHAT_SPAM = MessagesSettings.rcm("<red>You have been kicked for spam.");
            public ReadyComponentMessage ERROR_COMMAND_EXECUTE = MessagesSettings.rcm("<red>An internal error occurred whilst executing this command, please check the console log for details.");
            public ReadyComponentMessage COMMAND_NOT_FOUND = MessagesSettings.rcm("<red>Command not found.");
            public ReadyComponentMessage COMMAND_PLUGINS = MessagesSettings.rcm("<gray>Plugins (<green>{COUNT}<gray>): ");
            public ReadyComponentMessage COMMAND_SEND_PLAYERS = MessagesSettings.rcm("<dark_aqua>Attempting to send {COUNT} players to {TARGET}");
            public ReadyComponentMessage COMMAND_SEND_RESULTS = MessagesSettings.rcm("<green><bold>Send Results:");
            public ReadyComponentMessage CHAT_MESSAGE_EMPTY = MessagesSettings.rcm("<red>Chat message is empty.");
            public ReadyComponentMessage REJECT_TRANSFER = MessagesSettings.rcm("<red>Your transfer was rejected.");
            @Transient
            private Map<String, ReadyComponentMessage> messages = new HashMap<String, ReadyComponentMessage>();

            public void loadMessages() {
                try {
                    HashMap<String, ReadyComponentMessage> messages = new HashMap<String, ReadyComponentMessage>();
                    for (Field field : this.getClass().getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(this);
                        if (!(object instanceof ReadyComponentMessage)) continue;
                        ReadyComponentMessage readyComponentMessage = (ReadyComponentMessage)object;
                        String name = field.getName().toLowerCase(Locale.ROOT);
                        messages.put(name, readyComponentMessage);
                    }
                    this.messages = messages;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public ReadyComponentMessage getComponentMessage(String translate) {
                return this.messages.get(translate);
            }
        }
    }
}

