/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.blacklist;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import io.netty.buffer.ByteBuf;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.antibot.captcha.tasks.CacheCleanupUtils;
import net.shieldcommunity.nullcordx.blacklist.BlacklistManager;
import net.shieldcommunity.nullcordx.blacklist.ProxyList;
import net.shieldcommunity.nullcordx.cache.CachedPacket;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;
import net.shieldcommunity.nullcordx.utils.HttpUtils;
import net.shieldcommunity.nullcordx.utils.IOUtils;
import net.shieldcommunity.nullcordx.utils.InetAddressSet;
import net.shieldcommunity.nullcordx.utils.InetSocketUtil;
import org.apache.http.message.BasicNameValuePair;

@Singleton
public class ProxyBlacklistManager
extends ManagerComponent {
    private static final URI API_ENTRYPOINT = URI.create("http://47.206.114.248:23446/api/proxy/database");
    private static final File CACHE_DIRECTORY = new File("NullCordX" + File.separator + "cache" + File.separator + "proxy");
    private static final Gson GSON = new Gson();
    private InetAddressSet blacklistedProxies = null;
    private BlacklistManager blacklistManager = null;
    private ScheduledExecutorService timer = null;

    @Inject
    public ProxyBlacklistManager(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "ProxyBlacklistManager");
    }

    public void load(ForkJoinPool executor, BlacklistManager blacklistManager) {
        this.blacklistManager = blacklistManager;
        super.load(executor);
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        if (ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.MODE == -1) {
            this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
            return;
        }
        this.timer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-ProxyBlacklistUpdater-%d").setPriority(1).build());
        int time = ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.UPDATE_TIME;
        if (time <= 0) {
            time = 1;
        }
        this.checkProxy(true);
        this.timer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

            @Override
            public void doTask() {
                ProxyBlacklistManager.this.checkProxy(false);
            }
        }, time, time, TimeUnit.SECONDS);
    }

    @Override
    protected void onUnload() {
        if (this.timer != null) {
            this.timer.shutdownNow();
        }
        this.timer = null;
    }

    public boolean isBlacklisted(InetAddress address) {
        if (this.blacklistedProxies == null) {
            return false;
        }
        if (!this.canBlackList()) {
            return false;
        }
        return this.blacklistedProxies.contains(address);
    }

    private boolean canBlackList() {
        int mode = ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.MODE;
        if (mode == 0) {
            return true;
        }
        if (mode == 1) {
            return this.nullCordX.isUnderBotAttack() || this.nullCordX.isUnderPingAttack() || this.nullCordX.isUnderSpamAttack();
        }
        if (mode == 2) {
            return this.nullCordX.isUnderBotAttack();
        }
        if (mode == 3) {
            return this.nullCordX.isUnderSpamAttack();
        }
        return false;
    }

    private void checkProxy(boolean startup) {
        if (this.isProxyCacheOutOfDate()) {
            InetAddressSet inetAddressSet;
            this.logger.log(Level.INFO, "The proxy list cache is out of date or not found! Updating...");
            this.blacklistedProxies = inetAddressSet = this.createProxyList(ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.LIST, ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.USE_SHIELDCOMMUNITY_DATABASE);
            this.saveProxyCache(inetAddressSet);
            CacheCleanupUtils.doCleanup(this.logger, CACHE_DIRECTORY, new HashSet<String>(Collections.singletonList(this.getCurrentCacheName())), (logger, count) -> logger.log(Level.INFO, "Deleted " + count + " outdated cached proxies files."));
            return;
        }
        if (!startup) {
            return;
        }
        this.loadProxyCache();
    }

    private String getCurrentCacheName() {
        int name = ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.hashCode();
        return name + ".binz";
    }

    private File getCurrentCacheFile() {
        return new File(CACHE_DIRECTORY, this.getCurrentCacheName());
    }

    private boolean isProxyCacheOutOfDate() {
        File file = this.getCurrentCacheFile();
        if (!file.exists()) {
            return true;
        }
        return System.currentTimeMillis() - file.lastModified() > TimeUnit.SECONDS.toMillis(ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.MAX_CACHE_TIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProxyCache() {
        try {
            this.logger.log(Level.INFO, "Loading blacklisted proxy list cache...");
            byte[] bytes = Files.readAllBytes(this.getCurrentCacheFile().toPath());
            ByteBuf compressedBuffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
            try {
                compressedBuffer.writeBytes(bytes);
                ByteBuf decompressedBuffer = IOUtils.decompress(compressedBuffer);
                try {
                    InetAddressSet inetAddressSet = new InetAddressSet();
                    int count = decompressedBuffer.readInt();
                    for (int i = 0; i < count; ++i) {
                        int address = decompressedBuffer.readInt();
                        inetAddressSet.add(address);
                    }
                    this.blacklistedProxies = inetAddressSet;
                    this.logger.log(Level.INFO, "Blacklisted proxy list cache successfully loaded with " + this.blacklistedProxies.size() + " proxies!");
                }
                finally {
                    CachedPacket.releaseByteBufSafe(decompressedBuffer);
                }
            }
            finally {
                CachedPacket.releaseByteBufSafe(compressedBuffer);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to load blacklisted proxy list cache", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProxyCache(InetAddressSet inetAddressSet) {
        ByteBuf decompressedBuffer = IOUtils.getByteBufAllocatorBySettings().heapBuffer();
        try {
            this.logger.log(Level.INFO, "Saving blacklisted proxy list to the cache...");
            int count = inetAddressSet.size();
            decompressedBuffer.writeInt(count);
            for (int address : inetAddressSet) {
                decompressedBuffer.writeInt(address);
            }
            CACHE_DIRECTORY.mkdirs();
            ByteBuf compressedBuffer = IOUtils.compress(decompressedBuffer);
            try {
                try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(this.getCurrentCacheFile().toPath(), new OpenOption[0]));){
                    int size = compressedBuffer.readableBytes();
                    for (int i = 0; i < size; ++i) {
                        outputStream.write(compressedBuffer.readByte());
                    }
                }
                this.logger.log(Level.INFO, "Blacklisted proxy list successfully saved to the cache.");
            }
            finally {
                CachedPacket.releaseByteBufSafe(compressedBuffer);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to save blacklisted proxy list cache", e);
        }
        finally {
            CachedPacket.releaseByteBufSafe(decompressedBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddressSet createProxyList(List<String> urls, boolean shieldcommunityDatabase) {
        long start = System.currentTimeMillis();
        this.logger.log(Level.INFO, "Downloading blacklisted proxy list...");
        ExecutorService executor = Executors.newFixedThreadPool(ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.THREAD_POOL_SIZE, new ThreadFactoryBuilder().setNameFormat("NullCordX-ProxyDownloader-%d").setPriority(1).build());
        InetAddressSet tmp = new InetAddressSet();
        ArrayList<Callable<InetAddressSet>> tasks = new ArrayList<Callable<InetAddressSet>>();
        if (shieldcommunityDatabase) {
            tasks.add(this.extractShieldcommunityProxies());
        }
        tasks.addAll(this.createExtractTasks(urls));
        try {
            List futures = executor.invokeAll(tasks);
            for (Future future : futures) {
                tmp.addAll((Collection)future.get());
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Failed to invoke", e);
        }
        finally {
            executor.shutdownNow();
        }
        long end = System.currentTimeMillis();
        this.logger.log(Level.INFO, "Blacklisted proxy list downloaded in " + (end - start) + "ms with " + tmp.size() + " addresses!");
        return tmp;
    }

    private List<Callable<InetAddressSet>> createExtractTasks(List<String> urls) {
        ArrayList<Callable<InetAddressSet>> tasks = new ArrayList<Callable<InetAddressSet>>();
        for (String url : urls) {
            tasks.add(() -> {
                InetAddressSet data = new InetAddressSet();
                try {
                    this.logger.log(Level.INFO, "Extracting a list of addresses from url: '" + url + "'");
                    data = this.getProxyListFromURL(url);
                    this.logger.log(Level.INFO, "Successfully extracted " + data.size() + " addresses from url: '" + url + "'");
                }
                catch (Exception e) {
                    if (ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) {
                        this.logger.log(Level.SEVERE, "Error when trying to extract proxy list from url '" + url + "'", e);
                    }
                    this.logger.log(Level.SEVERE, "Error when trying to extract proxy list from url '" + url + "': " + e.getMessage());
                }
                return data;
            });
        }
        return tasks;
    }

    private InetAddressSet getProxyListFromURL(String url) throws Exception {
        URLConnection urlConnection = new URL(url).openConnection();
        if (urlConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)urlConnection;
            int timeout = ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.CONNECTION_TIMEOUT;
            if (timeout <= 0) {
                timeout = 1;
            }
            httpURLConnection.setConnectTimeout(timeout);
            httpURLConnection.setReadTimeout(timeout);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(HttpUtils.getInputStream(urlConnection), StandardCharsets.UTF_8));){
            HttpURLConnection httpURLConnection;
            if (urlConnection instanceof HttpURLConnection && (httpURLConnection = (HttpURLConnection)urlConnection).getResponseCode() != 200) {
                throw new IOException("Expected response code 200 (HTTP_OK) but received: " + httpURLConnection.getResponseCode());
            }
            List<String> values = reader.lines().toList();
            InetAddressSet newValues = new InetAddressSet();
            for (String value : values) {
                InetAddress parsedAddress;
                String[] split = value.split(":");
                String ip = value;
                if (split.length == 2) {
                    ip = split[0];
                }
                if ((parsedAddress = InetSocketUtil.getAddressSafe(ip)) == null || this.blacklistManager == null || this.blacklistManager.isNoBlacklisted(parsedAddress)) continue;
                newValues.add(parsedAddress);
            }
            InetAddressSet inetAddressSet = newValues;
            return inetAddressSet;
        }
    }

    private Callable<InetAddressSet> extractShieldcommunityProxies() {
        return () -> {
            InetAddressSet data = new InetAddressSet();
            try {
                this.logger.log(Level.INFO, "Extracting a list of addresses from shieldcommunity database");
                try (HttpUtils.HttpByteArrayInputStream inputStream = NullCordXImpl.getBUF_UTIL().makeRequest(API_ENTRYPOINT, ConfigSettings.IMP.PROTECTION.BLACKLIST.PROXY_LIST.CONNECTION_TIMEOUT, new BasicNameValuePair[0]);){
                    int code = inputStream.getCode();
                    if (code != 200) {
                        throw new IOException("Expected response code 200 (HTTP_OK) but received: " + code + ": '" + inputStream.getTextResponse() + "'");
                    }
                    ByteBuf inputBuf = IOUtils.getByteBufAllocatorBySettings().directBuffer();
                    try {
                        int byteData;
                        while ((byteData = inputStream.read()) != -1) {
                            inputBuf.writeByte(byteData);
                        }
                        ByteBuf outputBuf = IOUtils.decompress(inputBuf);
                        try {
                            byte[] jsonStringBytes = new byte[outputBuf.readableBytes()];
                            outputBuf.readBytes(jsonStringBytes);
                            String jsonString = new String(jsonStringBytes, StandardCharsets.UTF_8);
                            ProxyList proxyList = GSON.fromJson(jsonString, ProxyList.class);
                            for (String ip : proxyList.getProxies()) {
                                InetAddress parsedAddress = InetSocketUtil.getAddressSafe(ip);
                                if (parsedAddress == null || this.blacklistManager == null || this.blacklistManager.isNoBlacklisted(parsedAddress)) continue;
                                data.add(parsedAddress);
                            }
                            this.logger.log(Level.INFO, "Successfully extracted " + data.size() + " addresses from shieldcommunity database.");
                        }
                        finally {
                            CachedPacket.releaseByteBufSafe(outputBuf);
                        }
                    }
                    finally {
                        CachedPacket.releaseByteBufSafe(inputBuf);
                    }
                }
            }
            catch (Exception e) {
                if (ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) {
                    this.logger.log(Level.SEVERE, "Error when trying to extract proxy list from shieldcommunity database", e);
                }
                this.logger.log(Level.SEVERE, "Error when trying to extract proxy list from shieldcommunity database: " + e.getMessage());
            }
            return data;
        };
    }
}

