/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;

public class CachedMessagePacket
implements ByteBufPacket {
    private final ByteBufPacket jsonMessage;
    private final ByteBufPacket jsonMessageLegacy;
    private final ByteBufPacket actionBarLegacy;

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        if (protocol <= 578) {
            if (this.actionBarLegacy != null) {
                return this.actionBarLegacy.getByteBufByProtocol(protocol);
            }
            return this.jsonMessageLegacy.getByteBufByProtocol(protocol);
        }
        return this.jsonMessage.getByteBufByProtocol(protocol);
    }

    @Override
    public void release() {
        if (this.jsonMessage != null) {
            this.jsonMessage.release();
        }
        if (this.jsonMessageLegacy != null) {
            this.jsonMessageLegacy.release();
        }
        if (this.actionBarLegacy != null) {
            this.actionBarLegacy.release();
        }
    }

    public CachedMessagePacket(ByteBufPacket jsonMessage, ByteBufPacket jsonMessageLegacy, ByteBufPacket actionBarLegacy) {
        this.jsonMessage = jsonMessage;
        this.jsonMessageLegacy = jsonMessageLegacy;
        this.actionBarLegacy = actionBarLegacy;
    }

    public static class CachedActionBarLegacy
    implements ByteBufPacket {
        private final ByteBufPacket jsonPlainMessageLegacy;
        private final ByteBufPacket titleWithActionBar;

        @Override
        public ByteBuf getByteBufByProtocol(int protocol) {
            if (protocol >= 47 && protocol <= 210) {
                return this.jsonPlainMessageLegacy.getByteBufByProtocol(protocol);
            }
            return this.titleWithActionBar.getByteBufByProtocol(protocol);
        }

        @Override
        public void release() {
            if (this.jsonPlainMessageLegacy != null) {
                this.jsonPlainMessageLegacy.release();
            }
            if (this.titleWithActionBar != null) {
                this.titleWithActionBar.release();
            }
        }

        public CachedActionBarLegacy(ByteBufPacket jsonPlainMessageLegacy, ByteBufPacket titleWithActionBar) {
            this.jsonPlainMessageLegacy = jsonPlainMessageLegacy;
            this.titleWithActionBar = titleWithActionBar;
        }
    }
}

