/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.cache.CachedChangeableMotd;
import net.shieldcommunity.nullcordx.cache.CachedModernAndLegacyPacket;
import net.shieldcommunity.nullcordx.cache.CachedMotd;
import net.shieldcommunity.nullcordx.cache.CachedMotdByAddress;
import net.shieldcommunity.nullcordx.cache.MotdCacheType;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Cache;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Caffeine;
import net.shieldcommunity.nullcordx.libs.benmanes.caffeine.cache.Expiry;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;
import net.shieldcommunity.nullcordx.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.shieldcommunity.nullcordx.libs.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.shieldcommunity.nullcordx.tasks.SafeScheduledTask;
import net.shieldcommunity.nullcordx.utils.dummy.DummyInitialHandler;

@Singleton
public class CachedMotdManager
extends ManagerComponent {
    private Cache<InetAddress, CachedMotdByAddress> cachedMotdByAddress = null;
    private ScheduledExecutorService timer = null;
    private Int2ObjectMap<CachedChangeableMotd> motdByProtocols = null;
    private Favicon favicon;
    private MotdCacheType type;

    @Inject
    public CachedMotdManager(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "CachedMotdManager");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        int mode = MotdSettings.IMP.MOTD.MODE;
        switch (mode) {
            case 0: {
                this.type = MotdCacheType.CACHE_PLUGINS;
                break;
            }
            case 1: {
                this.type = MotdCacheType.FULL_CUSTOM;
                break;
            }
            case 2: {
                this.type = MotdCacheType.CACHE_PLUGINS_GLOBAL;
                break;
            }
            default: {
                this.type = MotdCacheType.DISABLED;
            }
        }
        if (this.type == MotdCacheType.DISABLED) {
            this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
            return;
        }
        this.logger.info("Using " + this.type.name() + " type cache for motd");
        int cacheTimeFinal = MotdSettings.IMP.MOTD.MAX_CACHE_TIME;
        this.timer = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("NullCordX-CachedMotdUpdater-%d").build());
        if (this.type == MotdCacheType.CACHE_PLUGINS) {
            this.cachedMotdByAddress = Caffeine.newBuilder().executor(NullCordXImpl.GLOBAL_CACHE_EXECUTOR).scheduler(NullCordXImpl.GLOBAL_CACHE_SCHEDULER).removalListener((key, value, cause) -> value.release()).expireAfter(new Expiry<InetAddress, CachedMotdByAddress>(){

                @Override
                public long expireAfterCreate(InetAddress key, CachedMotdByAddress value, long currentTime) {
                    return TimeUnit.MILLISECONDS.toNanos(MotdSettings.IMP.MOTD.MAX_CACHE_TIME);
                }

                @Override
                public long expireAfterUpdate(InetAddress key, CachedMotdByAddress value, long currentTime, long currentDuration) {
                    return 0L;
                }

                @Override
                public long expireAfterRead(InetAddress key, CachedMotdByAddress value, long currentTime, long currentDuration) {
                    return 0L;
                }
            }).initialCapacity(1000).build();
        } else if (this.type == MotdCacheType.FULL_CUSTOM) {
            File fav;
            Favicon favicon = null;
            String faviconPath = MotdSettings.IMP.MOTD.CUSTOM.FAVICON_PATH;
            if (!faviconPath.isEmpty() && (fav = new File("NullCordX", faviconPath)).exists()) {
                try {
                    float compressionLevel = (float)MotdSettings.IMP.MOTD.CUSTOM.FAVICON_COMPRESSION_LEVEL;
                    favicon = compressionLevel < 0.0f ? Favicon.create(ImageIO.read(fav)) : Favicon.create(Files.newInputStream(fav.toPath(), new OpenOption[0]), compressionLevel);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, "Could not load favicon image", e);
                }
            }
            this.favicon = favicon;
            this.motdByProtocols = CachedMotdManager.createChangeableMod();
            this.reCreateCachedCustomMotd(0);
            this.timer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){
                private int oldOnline;
                {
                    this.oldOnline = 0;
                }

                @Override
                public void doTask() {
                    int online = BungeeCord.getInstance().fakeOnlineCount(true);
                    if (this.oldOnline == online) {
                        return;
                    }
                    this.oldOnline = online;
                    CachedMotdManager.this.reCreateCachedCustomMotd(online);
                }
            }, cacheTimeFinal, cacheTimeFinal, TimeUnit.MILLISECONDS);
        } else if (this.type == MotdCacheType.CACHE_PLUGINS_GLOBAL) {
            this.motdByProtocols = CachedMotdManager.createChangeableMod();
            this.reCreateCachedPluginsGlobalMotd();
            this.timer.scheduleWithFixedDelay(new SafeScheduledTask(this.logger){

                @Override
                public void doTask() {
                    CachedMotdManager.this.reCreateCachedPluginsGlobalMotd();
                }
            }, cacheTimeFinal, cacheTimeFinal, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void onUnload() {
        if (this.timer != null) {
            try {
                this.timer.shutdown();
                this.timer.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                this.logger.log(Level.SEVERE, "Failed to terminate timer", e);
            }
            this.timer = null;
        }
        if (this.cachedMotdByAddress != null) {
            this.cachedMotdByAddress.invalidateAll();
            this.cachedMotdByAddress = null;
        }
        if (this.motdByProtocols != null) {
            for (CachedChangeableMotd packet : this.motdByProtocols.values()) {
                if (packet == null) continue;
                packet.release();
            }
            this.motdByProtocols = null;
        }
    }

    public void reload(ForkJoinPool executor) {
        this.onUnload();
        this.onLoad(executor);
    }

    private void reCreateCachedCustomMotd(int onlinePlayers) {
        Int2ObjectMap<CachedChangeableMotd> motdByProtocols = this.motdByProtocols;
        if (motdByProtocols == null) {
            return;
        }
        int dynamicMaxPlayers = MotdSettings.IMP.MOTD.CUSTOM.DYNAMIC_MAX_PLAYERS_COUNT;
        int maxPlayers = dynamicMaxPlayers > -1 ? onlinePlayers + dynamicMaxPlayers : MotdSettings.IMP.MOTD.CUSTOM.MAX_PLAYERS;
        List<ReadyComponentMessage> playerInfoConfig = MotdSettings.IMP.MOTD.CUSTOM.PLAYER_INFO;
        ServerPing.PlayerInfo[] playerInfo = null;
        if (playerInfoConfig != null && !playerInfoConfig.isEmpty()) {
            playerInfo = new ServerPing.PlayerInfo[playerInfoConfig.size()];
            int i = 0;
            for (ReadyComponentMessage player : playerInfoConfig) {
                playerInfo[i] = new ServerPing.PlayerInfo(this.replacePlaceholders(player.toLegacyText(), onlinePlayers, maxPlayers), UUID.randomUUID());
                ++i;
            }
        }
        String brandName = this.replacePlaceholders(MotdSettings.IMP.MOTD.CUSTOM.NAME, onlinePlayers, maxPlayers).toLegacyText();
        ReadyComponentMessage readyComponentMessage = this.replacePlaceholders(MotdSettings.IMP.MOTD.CUSTOM.MOTD, onlinePlayers, maxPlayers);
        BaseComponent motdLegacy = ComponentSerializer.deserialize((String)GsonComponentSerializer.colorDownsamplingGson().serialize(readyComponentMessage.getComponent()));
        for (CachedChangeableMotd cachedChangeableMotd : motdByProtocols.values()) {
            int protocol = cachedChangeableMotd.getProtocol();
            int configuredProtocol = MotdSettings.IMP.MOTD.PROTOCOL_VERSION;
            if (configuredProtocol == -1) {
                configuredProtocol = protocol;
            }
            CachedModernAndLegacyPacket<CachedMotd> motd = CachedMotdManager.createCachedMotd(onlinePlayers, maxPlayers, playerInfo, brandName, configuredProtocol, readyComponentMessage, motdLegacy, this.favicon);
            CachedModernAndLegacyPacket<CachedMotd> motdWithoutFavicon = CachedMotdManager.createCachedMotd(onlinePlayers, maxPlayers, playerInfo, brandName, configuredProtocol, readyComponentMessage, motdLegacy, null);
            cachedChangeableMotd.setMotd(motd);
            cachedChangeableMotd.setMotdWithoutFavicon(motdWithoutFavicon);
        }
    }

    private ReadyComponentMessage replacePlaceholders(ReadyComponentMessage readyComponentMessage, int online, int maxPlayers) {
        return readyComponentMessage.replace("player_online", "" + online).replace("player_online_max", "" + maxPlayers);
    }

    private String replacePlaceholders(String text, int online, int maxPlayers) {
        return text.replace("{PLAYER_ONLINE}", "" + online).replace("{PLAYER_ONLINE_MAX}", "" + maxPlayers);
    }

    private void reCreateCachedPluginsGlobalMotd() {
        Int2ObjectMap<CachedChangeableMotd> motdByProtocols = this.motdByProtocols;
        if (motdByProtocols == null) {
            return;
        }
        for (CachedChangeableMotd cachedChangeableMotd : motdByProtocols.values()) {
            int protocol = cachedChangeableMotd.getProtocol();
            int configuredProtocol = MotdSettings.IMP.MOTD.PROTOCOL_VERSION;
            if (configuredProtocol == -1) {
                configuredProtocol = protocol;
            }
            int finalConfiguredProtocol = configuredProtocol;
            ServerPing result = CachedMotdManager.createDefaultServerPing(configuredProtocol);
            Callback<ProxyPingEvent> callback = (pingResult, error) -> {
                ServerPing serverPing = pingResult.getResponse();
                if (serverPing == null) {
                    serverPing = result;
                }
                int onlinePlayers = serverPing.getPlayers().getOnline();
                int maxPlayers = serverPing.getPlayers().getMax();
                ServerPing.PlayerInfo[] playerInfo = serverPing.getPlayers().getSample();
                String brandName = serverPing.getVersion().getName();
                Favicon favicon = serverPing.getFaviconObject();
                TextComponent motdText = new TextComponent(new BaseComponent[]{serverPing.getDescriptionComponent()});
                CachedModernAndLegacyPacket<CachedMotd> motd = CachedMotdManager.createCachedMotd(onlinePlayers, maxPlayers, playerInfo, brandName, finalConfiguredProtocol, motdText, motdText, favicon);
                CachedModernAndLegacyPacket<CachedMotd> motdWithoutFavicon = CachedMotdManager.createCachedMotd(onlinePlayers, maxPlayers, playerInfo, brandName, finalConfiguredProtocol, motdText, motdText, null);
                cachedChangeableMotd.setMotd(motd);
                cachedChangeableMotd.setMotdWithoutFavicon(motdWithoutFavicon);
            };
            BungeeCord.getInstance().getPluginManager().callEvent(new ProxyPingEvent(new DummyInitialHandler(BungeeCord.getInstance(), configuredProtocol), result, callback));
        }
    }

    public CachedChangeableMotd getMotdByProtocol(int protocol) {
        if (this.motdByProtocols == null) {
            return null;
        }
        return (CachedChangeableMotd)this.motdByProtocols.get(protocol);
    }

    public CachedMotdByAddress getCachedMotdByIp(InetAddress address) {
        if (this.cachedMotdByAddress == null) {
            return null;
        }
        return this.cachedMotdByAddress.getIfPresent(address);
    }

    public CachedMotdByAddress addAndGetCachedMotdByIp(InetAddress address, ServerPing serverPing) {
        if (this.cachedMotdByAddress == null) {
            return null;
        }
        return this.cachedMotdByAddress.get(address, value -> new CachedMotdByAddress(serverPing, address));
    }

    private static Int2ObjectMap<CachedChangeableMotd> createChangeableMod() {
        Int2ObjectOpenHashMap<CachedChangeableMotd> tmp = new Int2ObjectOpenHashMap<CachedChangeableMotd>();
        for (int protocol : ProtocolConstants.SUPPORTED_VERSION_IDS_CHANGED) {
            tmp.put(protocol, new CachedChangeableMotd(protocol));
        }
        return tmp;
    }

    private static CachedModernAndLegacyPacket<CachedMotd> createCachedMotd(int onlinePlayers, int maxPlayers, ServerPing.PlayerInfo[] playerInfo, String name, int protocol, BaseComponent motdModern, BaseComponent motdLegacy, Favicon favicon) {
        ServerPing pingModern = new ServerPing(new ServerPing.Protocol(name, protocol), new ServerPing.Players(maxPlayers, onlinePlayers, playerInfo), motdModern, favicon);
        ServerPing pingLegacy = new ServerPing(new ServerPing.Protocol(name, protocol), new ServerPing.Players(maxPlayers, onlinePlayers, playerInfo), motdLegacy, favicon);
        CachedMotd modernMotd = new CachedMotd(pingModern);
        CachedMotd legacyMotd = new CachedMotd(pingLegacy);
        return new CachedModernAndLegacyPacket<CachedMotd>(modernMotd, legacyMotd);
    }

    private static ServerPing createDefaultServerPing(int protocol) {
        BungeeCord bungee = BungeeCord.getInstance();
        ListenerInfo listener = bungee.getConfig().getListenersList().get(0);
        return new ServerPing(new ServerPing.Protocol(bungee.getNameWithVersion(), protocol), new ServerPing.Players(listener.getMaxPlayers(), bungee.fakeOnlineCount(true), null), listener.getMotd(), bungee.getConfig().getFaviconObject());
    }

    public MotdCacheType getType() {
        return this.type;
    }
}

