/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import io.netty.buffer.ByteBuf;
import net.shieldcommunity.nullcordx.api.cache.ByteBufPacket;
import net.shieldcommunity.nullcordx.api.cache.CachedSpawnEntityItemFramePacket;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBounding;
import net.shieldcommunity.nullcordx.api.utils.location.AxisAlignedBoundingBox;
import net.shieldcommunity.nullcordx.api.utils.location.AxisType;
import net.shieldcommunity.nullcordx.api.utils.location.DirectionType;
import net.shieldcommunity.nullcordx.api.utils.location.Vector3D;

public class CachedSpawnEntityItemFramePacketImpl
implements CachedSpawnEntityItemFramePacket {
    private static final int WIDTH = 12;
    private static final int HEIGHT = 12;
    private final ByteBufPacket packet;
    private final int entityId;
    private final int mapId;
    private final double x;
    private final double y;
    private final double z;
    private final DirectionType direction;
    private final AxisAlignedBounding axisAlignedBounding;

    public CachedSpawnEntityItemFramePacketImpl(ByteBufPacket packet, int entityId, int mapId, double x, double y, double z, DirectionType direction) {
        this.packet = packet;
        this.entityId = entityId;
        this.mapId = mapId;
        this.x = x;
        this.y = y;
        this.z = z;
        this.direction = direction;
        this.axisAlignedBounding = CachedSpawnEntityItemFramePacketImpl.calculateBoundingBox(x, y, z, direction);
    }

    @Override
    public ByteBuf getByteBufByProtocol(int protocol) {
        return this.packet.getByteBufByProtocol(protocol);
    }

    @Override
    public void release() {
        this.packet.release();
    }

    private static AxisAlignedBoundingBox calculateBoundingBox(double x, double y, double z, DirectionType direction) {
        double minX = x + 0.5 - direction.getX() * 0.46875;
        double minY = y + 0.5 - direction.getY() * 0.46875;
        double minZ = z + 0.5 - direction.getZ() * 0.46875;
        double maxX = 12.0;
        double maxY = 12.0;
        double maxZ = 12.0;
        AxisType axisType = direction.getAxisType();
        switch (axisType) {
            case X: {
                maxX = 1.0;
                break;
            }
            case Y: {
                maxY = 1.0;
                break;
            }
            case Z: {
                maxZ = 1.0;
            }
        }
        return new AxisAlignedBoundingBox(Vector3D.of(minX - (maxX /= 32.0), minY - (maxY /= 32.0), minZ - (maxZ /= 32.0)), Vector3D.of(minX + maxX, minY + maxY, minZ + maxZ));
    }

    @Override
    public ByteBufPacket getPacket() {
        return this.packet;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    public DirectionType getDirection() {
        return this.direction;
    }

    @Override
    public AxisAlignedBounding getAxisAlignedBounding() {
        return this.axisAlignedBounding;
    }
}

