/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.cache;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;

public class PerRaCStorage<T> {
    private final T[][] data;
    private final int minRows;
    private final int maxRows;
    private final int minColumns;
    private final int maxColumns;

    public PerRaCStorage(Class<T> clazz, int minRows, int maxRows, int minColumns, int maxColumns) {
        if (minRows > maxRows) {
            throw new IllegalArgumentException("minRows: " + minRows + " > maxRows: " + maxRows);
        }
        if (minColumns > maxColumns) {
            throw new IllegalArgumentException("minColumns: " + minColumns + " > maxColumns: " + maxColumns);
        }
        this.minRows = minRows;
        this.maxRows = maxRows;
        this.minColumns = minColumns;
        this.maxColumns = maxColumns;
        this.data = (Object[][])Array.newInstance(clazz, maxRows, maxColumns);
    }

    public void loadNow(ForkJoinPool executor, LoadHandler<T> handler) {
        this.loadAt(this.minRows, this.maxRows, this.minColumns, this.maxColumns, executor, handler);
    }

    public List<StorageComputeTask> createTasks(int minRows, int maxRows, int minColumns, int maxColumns, LoadHandler<T> handler) {
        ArrayList<StorageComputeTask> tasks = new ArrayList<StorageComputeTask>();
        tasks.add(new StorageComputeTask(1, 1, handler));
        for (int i = minRows; i <= maxRows; ++i) {
            for (int j = minColumns; j <= maxColumns; ++j) {
                T value = this.getDataByRaC(i, j);
                if (value != null || i == 1 && j == 1) continue;
                tasks.add(new StorageComputeTask(i, j, handler));
            }
        }
        return tasks;
    }

    public void loadFutureTasks(List<StorageComputeTask> tasks) {
        try {
            for (StorageComputeTask data : tasks) {
                StorageData cd2 = (StorageData)data.get();
                this.setData(cd2.getRows(), cd2.getColumns(), cd2.getData());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void loadAt(int minRows, int maxRows, int minColumns, int maxColumns, ForkJoinPool executor, LoadHandler<T> handler) {
        List<StorageComputeTask> tasks = this.createTasks(minRows, maxRows, minColumns, maxColumns, handler);
        for (StorageComputeTask task : tasks) {
            executor.execute(task);
        }
        this.loadFutureTasks(tasks);
    }

    public void setData(int rows, int columns, T value) {
        this.checkBounds(rows, columns);
        this.data[rows - 1][columns - 1] = value;
    }

    public T getDataByRaCWithPixels(int width, int height) {
        return this.getDataByRaC(width / 128, height / 128);
    }

    public T getDataByRaC(int rows, int columns) {
        this.checkBounds(rows, columns);
        return this.data[rows - 1][columns - 1];
    }

    public List<T> getAllData() {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T[] subData : this.data) {
            if (subData == null) continue;
            for (T value : subData) {
                if (value == null) continue;
                tmp.add(value);
            }
        }
        return tmp;
    }

    private void checkBounds(int rows, int columns) {
        if (rows < 1 || columns < 1) {
            throw new IndexOutOfBoundsException("rows: " + rows + " < 1 || columns: " + columns + " < 1");
        }
        if (rows > this.maxRows || columns > this.maxColumns) {
            throw new IndexOutOfBoundsException("rows: " + rows + " > " + this.maxRows + " || columns: " + columns + " > " + this.maxRows);
        }
    }

    public static interface LoadHandler<T> {
        public T load(int var1, int var2);
    }

    public class StorageComputeTask
    extends RecursiveTask<StorageData> {
        private final int row;
        private final int column;
        private final LoadHandler<T> loadHandler;

        @Override
        protected StorageData compute() {
            return new StorageData(this.loadHandler.load(this.row, this.column), this.row, this.column);
        }

        public StorageComputeTask(int row, int column, LoadHandler<T> loadHandler) {
            this.row = row;
            this.column = column;
            this.loadHandler = loadHandler;
        }
    }

    public final class StorageData {
        private final T data;
        private final int rows;
        private final int columns;

        public StorageData(T data, int rows, int columns) {
            this.data = data;
            this.rows = rows;
            this.columns = columns;
        }

        public T getData() {
            return this.data;
        }

        public int getRows() {
            return this.rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StorageData)) {
                return false;
            }
            StorageData other = (StorageData)o;
            if (this.getRows() != other.getRows()) {
                return false;
            }
            return this.getColumns() == other.getColumns();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRows();
            result = result * 59 + this.getColumns();
            return result;
        }

        public String toString() {
            return "PerRaCStorage.StorageData(data=" + this.getData() + ", rows=" + this.getRows() + ", columns=" + this.getColumns() + ")";
        }
    }
}

