/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class CommandNode<T, D> {
    protected final CommandNode<T, D> rootNode;
    protected final String name;
    protected final List<String> aliases;
    protected final Map<String, CommandNode<T, D>> nodes = new LinkedHashMap<String, CommandNode<T, D>>();
    protected final Map<String, CommandNode<T, D>> withAliasesNodes = new LinkedHashMap<String, CommandNode<T, D>>();

    public CommandNode(CommandNode<T, D> rootNode, String name) {
        this(rootNode, name, Collections.emptyList());
    }

    public void execute(T sender, String[] args) {
        if (!this.hasPermission(sender)) {
            this.onPermissionFailedExecute(sender, args);
            return;
        }
        if (args.length == 0) {
            this.onExecuteSafe(sender, args);
            return;
        }
        CommandNode<T, D> nextNode = this.withAliasesNodes.get(args[0].toLowerCase(Locale.ROOT));
        if (nextNode == null) {
            this.onExecuteSafe(sender, args);
            return;
        }
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        nextNode.execute(sender, newArgs);
    }

    public void onExecuteSafe(T sender, String[] args) {
        try {
            this.onExecute(sender, args);
        }
        catch (Exception e) {
            this.onExecuteException(sender, args, e);
        }
    }

    public Collection<String> suggest(T sender, String[] args) {
        if (!this.hasPermission(sender)) {
            return this.onPermissionFailedSuggest(sender, args);
        }
        if (args.length == 0) {
            return this.onSuggestSafe(sender, args);
        }
        CommandNode<T, D> nextNode = this.withAliasesNodes.get(args[0].toLowerCase(Locale.ROOT));
        if (nextNode == null) {
            return this.onSuggestSafe(sender, args);
        }
        String[] newArgs = Arrays.copyOfRange(args, 1, args.length);
        return nextNode.suggest(sender, newArgs);
    }

    public Collection<String> onSuggestSafe(T sender, String[] args) {
        try {
            return this.onSuggest(sender, args);
        }
        catch (Exception e) {
            return this.onSuggestException(sender, args, e);
        }
    }

    public void addNode(CommandNode<T, D> node) {
        this.nodes.put(node.getName().toLowerCase(Locale.ROOT), node);
        this.withAliasesNodes.put(node.getName().toLowerCase(Locale.ROOT), node);
        for (String alias : node.getAliases()) {
            this.withAliasesNodes.put(alias.toLowerCase(Locale.ROOT), node);
        }
    }

    public List<D> getDescriptionList(T sender) {
        List<D> descs;
        ArrayList<D> tmp = new ArrayList<D>();
        if (this.hasPermission(sender) && (descs = this.getDescription(sender)) != null) {
            tmp.addAll(descs);
        }
        for (CommandNode<T, D> node : this.nodes.values()) {
            tmp.addAll(node.getDescriptionList(sender));
        }
        return tmp;
    }

    public Collection<D> getDescriptionListFromRoot(T sender) {
        if (this.rootNode == null) {
            return this.getDescriptionList(sender);
        }
        return this.rootNode.getDescriptionList(sender);
    }

    public boolean hasPermission(T sender) {
        return true;
    }

    public Collection<String> onSuggest(T sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        HashSet<String> matches = new HashSet<String>();
        String search = args[0].toLowerCase(Locale.ROOT);
        for (Map.Entry<String, CommandNode<T, D>> entry : this.withAliasesNodes.entrySet()) {
            if (!entry.getValue().hasPermission(sender) || !entry.getKey().toLowerCase(Locale.ROOT).startsWith(search)) continue;
            matches.add(entry.getKey());
        }
        return matches;
    }

    public abstract List<D> getDescription(T var1);

    public abstract void onExecute(T var1, String[] var2);

    public abstract void onExecuteException(T var1, String[] var2, Exception var3);

    public abstract Collection<String> onSuggestException(T var1, String[] var2, Exception var3);

    public abstract void onPermissionFailedExecute(T var1, String[] var2);

    public abstract Collection<String> onPermissionFailedSuggest(T var1, String[] var2);

    public CommandNode(CommandNode<T, D> rootNode, String name, List<String> aliases) {
        this.rootNode = rootNode;
        this.name = name;
        this.aliases = aliases;
    }

    public CommandNode<T, D> getRootNode() {
        return this.rootNode;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public Map<String, CommandNode<T, D>> getNodes() {
        return this.nodes;
    }

    public Map<String, CommandNode<T, D>> getWithAliasesNodes() {
        return this.withAliasesNodes;
    }
}

