/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.utils.TimeUtil;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;
import net.shieldcommunity.nullcordx.config.AntibotSettings;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.MotdSettings;
import net.shieldcommunity.nullcordx.statistics.NetworkStatisticsImpl;
import net.shieldcommunity.nullcordx.statistics.StatisticsManagerImpl;

public class CommonStatsCommand
extends CommandNodeBungee {
    public CommonStatsCommand(CommandNodeBungee root, String permission) {
        super(root, "stats", Arrays.asList("stat", "info"), permission);
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.COMMON_STATS_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 0) {
            this.sendCurrentHelp(sender);
            return;
        }
        this.sendStatistics(sender);
    }

    public void sendStatistics(CommandSender sender) {
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        String uptimeDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date(BungeeCord.UPTIME));
        sender.sendMessage(SEP);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PROXY_UPTIME.replace("uptime_data", uptimeDate).replace("uptime_time", TimeUtil.formatTime((System.currentTimeMillis() - BungeeCord.UPTIME) / 1000L, this.getMessagesSettings(sender))));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.UNDER_BOT_ATTACK.replace("mode", "" + nullCordX.isUnderBotAttack()));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.UNDER_PING_ATTACK.replace("mode", "" + nullCordX.isUnderPingAttack()));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.UNDER_SPAM_ATTACK.replace("mode", "" + nullCordX.isUnderSpamAttack()));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.BOT_COUNTER.replace("count", nf.format(nullCordX.getStatisticsManager().getBotCounter())).replace("threshold", nf.format(AntibotSettings.IMP.ANTIBOT.BOT_ATTACK_DETECTION.BOT_THRESHOLD)).replace("max", nf.format(nullCordX.getStatisticsManager().getBotCounterEver())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PING_COUNTER.replace("count", nf.format(nullCordX.getStatisticsManager().getPingCounter())).replace("threshold", nf.format(MotdSettings.IMP.MOTD.PING_ATTACK_DETECTION.PING_THRESHOLD)).replace("max", nf.format(nullCordX.getStatisticsManager().getPingCounterEver())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.SPAM_COUNTER.replace("count", nf.format(nullCordX.getStatisticsManager().getSpamCounter())).replace("threshold", nf.format(ConfigSettings.IMP.PROTECTION.SPAM_ATTACK_DETECTION.SPAM_THRESHOLD)).replace("max", nf.format(nullCordX.getStatisticsManager().getSpamCounterEver())));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.ONLINE_ON_CHECKING.replace("count", nf.format(nullCordX.getUserManager().getAllCheckingUsers().size())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONNECTION_PER_SECOND.replace("count", nf.format(nullCordX.getStatisticsManager().getConnectionsPerSecond())).replace("max", nf.format(nullCordX.getStatisticsManager().getConnectionsPerSecondEver())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.PING_PER_SECOND.replace("count", nf.format(nullCordX.getStatisticsManager().getPingsPerSecond())).replace("max", nf.format(nullCordX.getStatisticsManager().getPingsPerSecondEver())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.BLOCKED_PER_SECOND.replace("count", nf.format(nullCordX.getStatisticsManager().getBlockedConnectionsPerSecond())).replace("max", nf.format(nullCordX.getStatisticsManager().getBlockedConnectionsPerSecondEver())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_CONNECTIONS.replace("count", nf.format(nullCordX.getStatisticsManager().getTotalConnections())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_BLOCKED.replace("count", nf.format(nullCordX.getStatisticsManager().getTotalBlocked())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.UPSTREAM_OPENED_CONNECTIONS.replace("count", nf.format(nullCordX.getStatisticsManager().getOpenedUpstreamConnections())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.DOWNSTREAM_OPENED_CONNECTIONS.replace("count", nf.format(nullCordX.getStatisticsManager().getOpenedDownstreamConnections())));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.UPSTREAM_NETWORK);
        this.sendNetworkStatistics(sender, nf, nullCordX.getStatisticsManager().getUpstreamNetworkStatistics());
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.DOWNSTREAM_NETWORK);
        this.sendNetworkStatistics(sender, nf, nullCordX.getStatisticsManager().getDownstreamNetworkStatistics());
        sender.sendMessage(SEP);
    }

    private void sendNetworkStatistics(CommandSender sender, NumberFormat nf, NetworkStatisticsImpl networkStatistics) {
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.INPUT_PACKETS_PER_SECOND.replace("count", nf.format(networkStatistics.getChannelReadPacketsPerSecond())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.INPUT_BYTES_PER_SECOND.replace("count", StatisticsManagerImpl.bytesIntoHumanReadable(networkStatistics.getChannelReadBytesPerSecond())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.OUTPUT_PACKETS_PER_SECOND.replace("count", nf.format(networkStatistics.getChannelWritePacketsPerSecond())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.OUTPUT_BYTES_PER_SECOND.replace("count", StatisticsManagerImpl.bytesIntoHumanReadable(networkStatistics.getChannelWriteBytesPerSecond())));
        sender.sendMessage(" ");
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_INPUT_PACKETS.replace("count", nf.format(networkStatistics.getTotalChannelReadPackets())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_INPUT_BYTES.replace("count", StatisticsManagerImpl.bytesIntoHumanReadable(networkStatistics.getTotalChannelReadBytes())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_OUTPUT_PACKETS.replace("count", nf.format(networkStatistics.getTotalChannelWritePackets())));
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.TOTAL_OUTPUT_BYTES.replace("count", StatisticsManagerImpl.bytesIntoHumanReadable(networkStatistics.getTotalChannelWriteBytes())));
    }
}

