/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.commands.proxy.console;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.api.database.WhitelistedUserData;
import net.shieldcommunity.nullcordx.chat.modern.ReadyComponentMessage;
import net.shieldcommunity.nullcordx.commands.CommandNodeBungee;

public class ConsoleWhiteListRemoveCommand
extends CommandNodeBungee {
    public ConsoleWhiteListRemoveCommand(CommandNodeBungee root) {
        super(root, "remove");
    }

    @Override
    public List<ReadyComponentMessage> getDescription(CommandSender sender) {
        return Collections.singletonList(this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.CONSOLE_WHITELIST_REMOVE_DESCRIPTION);
    }

    @Override
    public void onExecute(CommandSender sender, String[] args) {
        if (args.length != 1) {
            this.sendCurrentHelp(sender);
            return;
        }
        String name = args[0];
        NullCordXImpl nullCordX = BungeeCord.getInstance().getNullCordX();
        WhitelistedUserData whitelistedUserData = nullCordX.getUserManager().getWhitelistedUser(name);
        if (whitelistedUserData == null) {
            sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.WHITELIST_NOT_FOUND.replace("user", name));
            return;
        }
        nullCordX.getUserManager().removePlayerFromWhitelist(name);
        sender.sendMessage((BaseComponent)this.getMessagesSettings((CommandSender)sender).MESSAGES.NULLCORDX.WHITELIST_REMOVED.replace("user", name));
    }

    @Override
    public Collection<String> onSuggest(CommandSender sender, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        HashSet<String> matches = new HashSet<String>();
        String search = args[0].toLowerCase();
        for (WhitelistedUserData player : BungeeCord.getInstance().getNullCordX().getUserManager().getAllWhitelistedPlayers()) {
            if (!player.getName().toLowerCase().startsWith(search)) continue;
            matches.add(player.getName());
        }
        return matches;
    }
}

