/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.bungee;

import java.nio.file.Paths;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class WaterfallSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.SNAKE_CASE).registerSerializer(new ReadyComponentMessageSerializer()).build();
    @Transient
    public static final WaterfallSettings IMP = new WaterfallSettings();
    @Comment(value={@CommentValue(value="Should the proxy log InitialHandler connections?")})
    public boolean LOG_INITIAL_HANDLER_CONNECTIONS = false;
    @NewLine
    @Comment(value={@CommentValue(value="What supported versions of the game will the proxy send to the client")})
    public String GAME_VERSION = null;
    @NewLine
    @Comment(value={@CommentValue(value="Whether we use Netty's async DNS resolver for the HttpClient")})
    public boolean USE_NETTY_DNS_RESOLVER = true;
    public THROTTLING THROTTLING = new THROTTLING();
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy disable the tab limiter for versions 1.13+?")})
    public boolean DISABLE_MODERN_TAB_LIMITER = false;
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy disable entity metadata rewrite?"), @CommentValue(value="If enabled, the proxy will try to get rid of conflicting entity IDs by sending respawn and join packets."), @CommentValue(value="This may increase performance but may break plugins or mods support.")})
    public boolean DISABLE_ENTITY_METADATA_REWRITE = true;
    @NewLine
    @Comment(value={@CommentValue(value="How many channels there can be between server and player, typically used by mods or some plugins.")})
    public int REGISTERED_PLUGIN_CHANNELS_LIMIT = 128;
    @NewLine
    @Comment(value={@CommentValue(value="How long the maximum channel name can be, only reason to change it would be broken mods.")})
    public int PLUGIN_CHANNEL_NAME_LIMIT = 128;
    @NewLine
    @Comment(value={@CommentValue(value="Should the proxy disable tab list rewrite?")})
    public boolean DISABLE_TAB_LIST_REWRITE = true;
    @NewLine
    @Comment(value={@CommentValue(value="What type of forwarding mode should the proxy use?"), @CommentValue(value="Available modes:"), @CommentValue, @CommentValue(value="bungeecord_legacy - The proxy only sends uuid, properties and ip address."), @CommentValue(value="Outdated and not secure, use it if you are absolutely sure that your backend servers do not have access from the outside."), @CommentValue, @CommentValue(value="bungeeguard - The proxy sends a secret along with the uuid, properties and ip address, which is compared on the server."), @CommentValue(value="This method is preferable and works on all versions of the game."), @CommentValue, @CommentValue(value="velocity_modern - The proxy sends a hash based on the secret along with the uuid, properties and ip address."), @CommentValue(value="This method is the most preferable, but it only works starting from game version 1.13.")})
    public String FORWARDING_MODE = "bungeecord_legacy";
    @NewLine
    @Comment(value={@CommentValue(value="What secret key should be used for BungeeGuard or Velocity forwarding?")})
    public String FORWARDING_SECRET = null;
    public long CONFIG_VERSION = 1L;

    public WaterfallSettings() {
        super(Paths.get("waterfall.yml", new String[0]), CONFIG);
    }

    @NewLine
    @Comment(value={@CommentValue(value="Configuration for throttling")})
    public static class THROTTLING {
        @Comment(value={@CommentValue(value="How often tab-complete packets can be sent in milliseconds.")})
        public int TAB_COMPLETE = 25;
    }
}

