/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.captcha;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.config.FilePaths;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.captcha.GlowingCircle;
import net.shieldcommunity.nullcordx.config.captcha.ImageOffset;
import net.shieldcommunity.nullcordx.config.serializers.FilePathsSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class AnimatedHandCaptchaSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new FilePathsSerializer()).build();
    @Transient
    public static final AnimatedHandCaptchaSettings IMP = new AnimatedHandCaptchaSettings();
    public ANIMATED_HAND_CAPTCHA ANIMATED_HAND_CAPTCHA = new ANIMATED_HAND_CAPTCHA();
    public long CONFIG_VERSION = 1L;

    public AnimatedHandCaptchaSettings() {
        super(Paths.get("NullCordX/captcha/animated-hand-captcha.yml", new String[0]), CONFIG);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnimatedHandCaptchaSettings)) {
            return false;
        }
        AnimatedHandCaptchaSettings other = (AnimatedHandCaptchaSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.CONFIG_VERSION != other.CONFIG_VERSION) {
            return false;
        }
        ANIMATED_HAND_CAPTCHA this$ANIMATED_HAND_CAPTCHA = this.ANIMATED_HAND_CAPTCHA;
        ANIMATED_HAND_CAPTCHA other$ANIMATED_HAND_CAPTCHA = other.ANIMATED_HAND_CAPTCHA;
        return !(this$ANIMATED_HAND_CAPTCHA == null ? other$ANIMATED_HAND_CAPTCHA != null : !((Object)this$ANIMATED_HAND_CAPTCHA).equals(other$ANIMATED_HAND_CAPTCHA));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnimatedHandCaptchaSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.CONFIG_VERSION;
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        ANIMATED_HAND_CAPTCHA $ANIMATED_HAND_CAPTCHA = this.ANIMATED_HAND_CAPTCHA;
        result = result * 59 + ($ANIMATED_HAND_CAPTCHA == null ? 43 : ((Object)$ANIMATED_HAND_CAPTCHA).hashCode());
        return result;
    }

    @Comment(value={@CommentValue(value="Configuration for animated hand captcha")})
    public static class ANIMATED_HAND_CAPTCHA {
        @Comment(value={@CommentValue(value="How many animated hand captcha images to generate. A large number can take up a lot of RAM."), @CommentValue(value="If network_compression_threshold is -1 or the packet compression level is too low, the animated hand captcha can take up a lot of RAM."), @CommentValue(value="A large number of animated hand captcha is more difficult for an attacker to remember to solve on their own.")})
        public int IMAGES_COUNT = 600;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for render layers groups."), @CommentValue, @CommentValue(value="What is it and how does it work?"), @CommentValue(value="Render layer groups are the sequence of drawing elements on an image."), @CommentValue(value="For example, to draw a background image and glyphs on it, you first need to draw the background and then the glyphs,"), @CommentValue(value="if you do otherwise, the background will redraw the glyphs and you will not see them."), @CommentValue, @CommentValue(value="Why are these groups?"), @CommentValue(value="Each group is drawn separately to then merge them into one."), @CommentValue(value="This approach will allow, for example, to make specific glyphs with a gradient without affecting the background, since it is in a different group."), @CommentValue, @CommentValue(value="Use this character to separate layer: '>'"), @CommentValue(value="To create a new group just make a new element. For example: - \"Code>Curve\" "), @CommentValue, @CommentValue(value="See render-layer-templates to see or customize the current layer templates."), @CommentValue(value="You can add as many layers as you want and in any order you want.")})
        @CollectionType(value=ArrayList.class)
        public List<String> RENDER_LAYER_GROUPS = Arrays.asList("Hand-image>Ripple>Mirror", "Code>Curve>Hand-gradient>Ripple");
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for post renders layers."), @CommentValue, @CommentValue(value="Same as render-layers-group, except that all specified layers will be applied to the rendered image after all groups have been merged."), @CommentValue(value="Useful if you need to overlay ripple or dithering on the finished image and not on each group separately."), @CommentValue(value="Disabled if empty.")})
        public String POST_RENDER = "Dithering";
        @NewLine
        @Comment(value={@CommentValue(value="Path to gif files (.gif file)"), @CommentValue(value="You can specify the path to the directory where all the gifs are located. The generator will try to load all the gifs.")})
        public FilePaths GIFS_PATH = new FilePaths(Collections.emptyList());
        @NewLine
        @Comment(value={@CommentValue(value="Delay between frames in milliseconds.")})
        public int ANIMATION_DELAY = 100;
        @NewLine
        @Comment(value={@CommentValue(value="Should the gif be animated in reverse?")})
        public boolean REVERSE_ANIMATION = false;
        @NewLine
        @Comment(value={@CommentValue(value="Should the animation animate backwards when reaching the end of the animation?"), @CommentValue(value="It will create a continuous animation effect.")})
        public boolean REVERSE_REPLAY_CYCLE = false;
        @NewLine
        @Comment(value={@CommentValue(value="How many times does the generator need to rotate the random frames? 0 - to disable."), @CommentValue(value="This option rotates each image chunk of the animated frame in the generated specified direction."), @CommentValue(value="The difference between this parameter and the rotation-framed layer is that this parameter saves the rotation of a piece of the image for each frame of the animation, which cannot be done with the rotation layer.")})
        public int RANDOM_FRAME_ROTATE_COUNT = 0;
        @NewLine
        @Comment(value={@CommentValue(value="How many frames should a GIF have? The more frames the better, but it consumes a lot of traffic and a lot of time to generate."), @CommentValue(value="This parameter is used only if GIF images for the generator are not specified.")})
        public int FRAMES_COUNT = 10;
        public IMAGE_OFFSET IMAGE_OFFSET = new IMAGE_OFFSET();
        public GLOWING_CIRCLE GLOWING_CIRCLE = new GLOWING_CIRCLE();

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ANIMATED_HAND_CAPTCHA)) {
                return false;
            }
            ANIMATED_HAND_CAPTCHA other = (ANIMATED_HAND_CAPTCHA)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.IMAGES_COUNT != other.IMAGES_COUNT) {
                return false;
            }
            if (this.ANIMATION_DELAY != other.ANIMATION_DELAY) {
                return false;
            }
            if (this.REVERSE_ANIMATION != other.REVERSE_ANIMATION) {
                return false;
            }
            if (this.REVERSE_REPLAY_CYCLE != other.REVERSE_REPLAY_CYCLE) {
                return false;
            }
            if (this.RANDOM_FRAME_ROTATE_COUNT != other.RANDOM_FRAME_ROTATE_COUNT) {
                return false;
            }
            if (this.FRAMES_COUNT != other.FRAMES_COUNT) {
                return false;
            }
            List<String> this$RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            List<String> other$RENDER_LAYER_GROUPS = other.RENDER_LAYER_GROUPS;
            if (this$RENDER_LAYER_GROUPS == null ? other$RENDER_LAYER_GROUPS != null : !((Object)this$RENDER_LAYER_GROUPS).equals(other$RENDER_LAYER_GROUPS)) {
                return false;
            }
            String this$POST_RENDER = this.POST_RENDER;
            String other$POST_RENDER = other.POST_RENDER;
            if (this$POST_RENDER == null ? other$POST_RENDER != null : !this$POST_RENDER.equals(other$POST_RENDER)) {
                return false;
            }
            FilePaths this$GIFS_PATH = this.GIFS_PATH;
            FilePaths other$GIFS_PATH = other.GIFS_PATH;
            if (this$GIFS_PATH == null ? other$GIFS_PATH != null : !((Object)this$GIFS_PATH).equals(other$GIFS_PATH)) {
                return false;
            }
            IMAGE_OFFSET this$IMAGE_OFFSET = this.IMAGE_OFFSET;
            IMAGE_OFFSET other$IMAGE_OFFSET = other.IMAGE_OFFSET;
            if (this$IMAGE_OFFSET == null ? other$IMAGE_OFFSET != null : !((Object)this$IMAGE_OFFSET).equals(other$IMAGE_OFFSET)) {
                return false;
            }
            GLOWING_CIRCLE this$GLOWING_CIRCLE = this.GLOWING_CIRCLE;
            GLOWING_CIRCLE other$GLOWING_CIRCLE = other.GLOWING_CIRCLE;
            return !(this$GLOWING_CIRCLE == null ? other$GLOWING_CIRCLE != null : !((Object)this$GLOWING_CIRCLE).equals(other$GLOWING_CIRCLE));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ANIMATED_HAND_CAPTCHA;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.IMAGES_COUNT;
            result = result * 59 + this.ANIMATION_DELAY;
            result = result * 59 + (this.REVERSE_ANIMATION ? 79 : 97);
            result = result * 59 + (this.REVERSE_REPLAY_CYCLE ? 79 : 97);
            result = result * 59 + this.RANDOM_FRAME_ROTATE_COUNT;
            result = result * 59 + this.FRAMES_COUNT;
            List<String> $RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            result = result * 59 + ($RENDER_LAYER_GROUPS == null ? 43 : ((Object)$RENDER_LAYER_GROUPS).hashCode());
            String $POST_RENDER = this.POST_RENDER;
            result = result * 59 + ($POST_RENDER == null ? 43 : $POST_RENDER.hashCode());
            FilePaths $GIFS_PATH = this.GIFS_PATH;
            result = result * 59 + ($GIFS_PATH == null ? 43 : ((Object)$GIFS_PATH).hashCode());
            IMAGE_OFFSET $IMAGE_OFFSET = this.IMAGE_OFFSET;
            result = result * 59 + ($IMAGE_OFFSET == null ? 43 : ((Object)$IMAGE_OFFSET).hashCode());
            GLOWING_CIRCLE $GLOWING_CIRCLE = this.GLOWING_CIRCLE;
            result = result * 59 + ($GLOWING_CIRCLE == null ? 43 : ((Object)$GLOWING_CIRCLE).hashCode());
            return result;
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for image offset")})
        public static class IMAGE_OFFSET
        implements ImageOffset {
            @Comment(value={@CommentValue(value="Should the generator randomly move the image sideways in each frame?")})
            public boolean ENABLED = true;
            @NewLine
            @Comment(value={@CommentValue(value="By how many pixels in the X direction should the image be shifted in the next frame?")})
            public int ANIMATION_X_MULTIPLICATION = 4;
            @NewLine
            @Comment(value={@CommentValue(value="By how many pixels in the Y direction should the image be shifted in the next frame?")})
            public int ANIMATION_Y_MULTIPLICATION = 4;
            @NewLine
            @Comment(value={@CommentValue(value="After how many frames should the generator randomly change direction?")})
            public int ANIMATION_ITERATION_CHANGE = 5;

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IMAGE_OFFSET)) {
                    return false;
                }
                IMAGE_OFFSET other = (IMAGE_OFFSET)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isENABLED() != other.isENABLED()) {
                    return false;
                }
                if (this.getANIMATION_X_MULTIPLICATION() != other.getANIMATION_X_MULTIPLICATION()) {
                    return false;
                }
                if (this.getANIMATION_Y_MULTIPLICATION() != other.getANIMATION_Y_MULTIPLICATION()) {
                    return false;
                }
                return this.getANIMATION_ITERATION_CHANGE() == other.getANIMATION_ITERATION_CHANGE();
            }

            protected boolean canEqual(Object other) {
                return other instanceof IMAGE_OFFSET;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isENABLED() ? 79 : 97);
                result = result * 59 + this.getANIMATION_X_MULTIPLICATION();
                result = result * 59 + this.getANIMATION_Y_MULTIPLICATION();
                result = result * 59 + this.getANIMATION_ITERATION_CHANGE();
                return result;
            }

            @Override
            public boolean isENABLED() {
                return this.ENABLED;
            }

            @Override
            public int getANIMATION_X_MULTIPLICATION() {
                return this.ANIMATION_X_MULTIPLICATION;
            }

            @Override
            public int getANIMATION_Y_MULTIPLICATION() {
                return this.ANIMATION_Y_MULTIPLICATION;
            }

            @Override
            public int getANIMATION_ITERATION_CHANGE() {
                return this.ANIMATION_ITERATION_CHANGE;
            }
        }

        @NewLine
        @Comment(value={@CommentValue(value="Configuration for glowing circle generator")})
        public static class GLOWING_CIRCLE
        implements GlowingCircle {
            @Comment(value={@CommentValue(value="Should the generator generate a gif image based on the generated layers, in which everything will be filled with color except for certain areas that will move to the sides?"), @CommentValue(value="This will make it much harder for attackers to solve the captcha, as the attacker will need to parse EVERY frame in the animation in order to read the code and solve the captcha.")})
            public boolean ENABLED = false;
            @NewLine
            @Comment(value={@CommentValue(value="Should the generator create a circle that moves horizontally from the beginning to the end of the image?")})
            public boolean MAIN_CIRCLE = true;
            @NewLine
            @Comment(value={@CommentValue(value="How many small random circles should be generated? 0 - to disable.")})
            public int SMALL_CIRCLES_COUNT = 3;
            @NewLine
            @Comment(value={@CommentValue(value="How many degrees should the generator rotate the image each frame? 0 - to disable.")})
            public int RANDOM_ROTATION_DEGREES = 0;
            @NewLine
            @Comment(value={@CommentValue(value="What render layers should be on the shadow background?"), @CommentValue(value="Disabled if empty.")})
            @CollectionType(value=ArrayList.class)
            public List<String> SHADOW_RENDER_LAYERS = Collections.emptyList();

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof GLOWING_CIRCLE)) {
                    return false;
                }
                GLOWING_CIRCLE other = (GLOWING_CIRCLE)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.isENABLED() != other.isENABLED()) {
                    return false;
                }
                if (this.isMAIN_CIRCLE() != other.isMAIN_CIRCLE()) {
                    return false;
                }
                if (this.getSMALL_CIRCLES_COUNT() != other.getSMALL_CIRCLES_COUNT()) {
                    return false;
                }
                if (this.getRANDOM_ROTATION_DEGREES() != other.getRANDOM_ROTATION_DEGREES()) {
                    return false;
                }
                List<String> this$SHADOW_RENDER_LAYERS = this.getSHADOW_RENDER_LAYERS();
                List<String> other$SHADOW_RENDER_LAYERS = other.getSHADOW_RENDER_LAYERS();
                return !(this$SHADOW_RENDER_LAYERS == null ? other$SHADOW_RENDER_LAYERS != null : !((Object)this$SHADOW_RENDER_LAYERS).equals(other$SHADOW_RENDER_LAYERS));
            }

            protected boolean canEqual(Object other) {
                return other instanceof GLOWING_CIRCLE;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + (this.isENABLED() ? 79 : 97);
                result = result * 59 + (this.isMAIN_CIRCLE() ? 79 : 97);
                result = result * 59 + this.getSMALL_CIRCLES_COUNT();
                result = result * 59 + this.getRANDOM_ROTATION_DEGREES();
                List<String> $SHADOW_RENDER_LAYERS = this.getSHADOW_RENDER_LAYERS();
                result = result * 59 + ($SHADOW_RENDER_LAYERS == null ? 43 : ((Object)$SHADOW_RENDER_LAYERS).hashCode());
                return result;
            }

            @Override
            public boolean isENABLED() {
                return this.ENABLED;
            }

            @Override
            public boolean isMAIN_CIRCLE() {
                return this.MAIN_CIRCLE;
            }

            @Override
            public int getSMALL_CIRCLES_COUNT() {
                return this.SMALL_CIRCLES_COUNT;
            }

            @Override
            public int getRANDOM_ROTATION_DEGREES() {
                return this.RANDOM_ROTATION_DEGREES;
            }

            @Override
            public List<String> getSHADOW_RENDER_LAYERS() {
                return this.SHADOW_RENDER_LAYERS;
            }
        }
    }
}

