/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.config.captcha;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.shieldcommunity.nullcordx.config.FrameSizes;
import net.shieldcommunity.nullcordx.config.SafeYamlSerializable;
import net.shieldcommunity.nullcordx.config.serializers.FrameSizesSerializer;
import net.shieldcommunity.nullcordx.config.serializers.ReadyComponentMessageSerializer;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.NameStyle;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.SerializerConfig;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CollectionType;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Comment;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.CommentValue;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.NewLine;
import net.shieldcommunity.nullcordx.libs.elytrium.serializer.annotations.Transient;

public class FramedPuzzleSettings
extends SafeYamlSerializable {
    @Transient
    private static final SerializerConfig CONFIG = new SerializerConfig.Builder().setCommentValueIndent(1).setFieldNameStyle(NameStyle.MACRO_CASE).setNodeNameStyle(NameStyle.KEBAB_CASE).registerSerializer(new ReadyComponentMessageSerializer()).registerSerializer(new FrameSizesSerializer()).build();
    @Transient
    public static final FramedPuzzleSettings IMP = new FramedPuzzleSettings();
    public FRAMED_PUZZLE FRAMED_PUZZLE = new FRAMED_PUZZLE();
    public long CONFIG_VERSION = 1L;

    public FramedPuzzleSettings() {
        super(Paths.get("NullCordX/captcha/framed-puzzle.yml", new String[0]), CONFIG);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FramedPuzzleSettings)) {
            return false;
        }
        FramedPuzzleSettings other = (FramedPuzzleSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.CONFIG_VERSION != other.CONFIG_VERSION) {
            return false;
        }
        FRAMED_PUZZLE this$FRAMED_PUZZLE = this.FRAMED_PUZZLE;
        FRAMED_PUZZLE other$FRAMED_PUZZLE = other.FRAMED_PUZZLE;
        return !(this$FRAMED_PUZZLE == null ? other$FRAMED_PUZZLE != null : !((Object)this$FRAMED_PUZZLE).equals(other$FRAMED_PUZZLE));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FramedPuzzleSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $CONFIG_VERSION = this.CONFIG_VERSION;
        result = result * 59 + (int)($CONFIG_VERSION >>> 32 ^ $CONFIG_VERSION);
        FRAMED_PUZZLE $FRAMED_PUZZLE = this.FRAMED_PUZZLE;
        result = result * 59 + ($FRAMED_PUZZLE == null ? 43 : ((Object)$FRAMED_PUZZLE).hashCode());
        return result;
    }

    @Comment(value={@CommentValue(value="Configuration for framed puzzle")})
    public static class FRAMED_PUZZLE {
        @Comment(value={@CommentValue(value="How many framed puzzle images to generate. A large number can take up a lot of RAM."), @CommentValue(value="If network_compression_threshold is -1 or the packet compression level is too low, the framed puzzle can take up a lot of RAM."), @CommentValue(value="A large number of framed puzzle is more difficult for an attacker to remember to solve on their own.")})
        public int IMAGES_COUNT = 500;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for render layers groups."), @CommentValue, @CommentValue(value="What is it and how does it work?"), @CommentValue(value="Render layer groups are the sequence of drawing elements on an image."), @CommentValue(value="For example, to draw a background image and glyphs on it, you first need to draw the background and then the glyphs,"), @CommentValue(value="if you do otherwise, the background will redraw the glyphs and you will not see them."), @CommentValue, @CommentValue(value="Why are these groups?"), @CommentValue(value="Each group is drawn separately to then merge them into one."), @CommentValue(value="This approach will allow, for example, to make specific glyphs with a gradient without affecting the background, since it is in a different group."), @CommentValue, @CommentValue(value="Use this character to separate layer: '>'"), @CommentValue(value="To create a new group just make a new element. For example: - \"Code>Curve\" "), @CommentValue, @CommentValue(value="See render-layer-templates to see or customize the current layer templates."), @CommentValue(value="You can add as many layers as you want and in any order you want.")})
        @CollectionType(value=ArrayList.class)
        public List<String> RENDER_LAYER_GROUPS = Collections.singletonList("Image>Dithering>Ripple>Noise>Mirror");
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for post renders layers."), @CommentValue, @CommentValue(value="Same as render-layers-group, except that all specified layers will be applied to the rendered image after all groups have been merged."), @CommentValue(value="Useful if you need to overlay ripple or dithering on the finished image and not on each group separately."), @CommentValue(value="Disabled if empty.")})
        public String POST_RENDER = "";
        @NewLine
        @Comment(value={@CommentValue(value="What is the chance to rotate images?"), @CommentValue(value="In percent. 1.0 - 100%, 0.0 - 0%, 0.5 - 50%")})
        public double ROTATION_CHANCE = 1.0;
        @NewLine
        @Comment(value={@CommentValue(value="Configuration for frame sizes."), @CommentValue, @CommentValue(value="What specific frame sizes should the generator generate?"), @CommentValue(value="You can specify exact frame sizes, such as 2x2 or 3x3, and the generator will use a random size from those specified."), @CommentValue(value="Also, you can specify as many frames as you like and any size, including any arbitrary size, but please note that there must be a delimiter between the numbers as the 'x' symbol"), @CommentValue(value="For example: 2x2 or 3x2 or 4x4. Please note that the first number is the row of the frame, the second number is its column.")})
        public FrameSizes FRAME_SIZES = new FrameSizes(Arrays.asList("2x2", "2x3", "3x2", "3x3", "3x4", "4x3", "4x4"));

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FRAMED_PUZZLE)) {
                return false;
            }
            FRAMED_PUZZLE other = (FRAMED_PUZZLE)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.IMAGES_COUNT != other.IMAGES_COUNT) {
                return false;
            }
            if (Double.compare(this.ROTATION_CHANCE, other.ROTATION_CHANCE) != 0) {
                return false;
            }
            List<String> this$RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            List<String> other$RENDER_LAYER_GROUPS = other.RENDER_LAYER_GROUPS;
            if (this$RENDER_LAYER_GROUPS == null ? other$RENDER_LAYER_GROUPS != null : !((Object)this$RENDER_LAYER_GROUPS).equals(other$RENDER_LAYER_GROUPS)) {
                return false;
            }
            String this$POST_RENDER = this.POST_RENDER;
            String other$POST_RENDER = other.POST_RENDER;
            if (this$POST_RENDER == null ? other$POST_RENDER != null : !this$POST_RENDER.equals(other$POST_RENDER)) {
                return false;
            }
            FrameSizes this$FRAME_SIZES = this.FRAME_SIZES;
            FrameSizes other$FRAME_SIZES = other.FRAME_SIZES;
            return !(this$FRAME_SIZES == null ? other$FRAME_SIZES != null : !((Object)this$FRAME_SIZES).equals(other$FRAME_SIZES));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FRAMED_PUZZLE;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.IMAGES_COUNT;
            long $ROTATION_CHANCE = Double.doubleToLongBits(this.ROTATION_CHANCE);
            result = result * 59 + (int)($ROTATION_CHANCE >>> 32 ^ $ROTATION_CHANCE);
            List<String> $RENDER_LAYER_GROUPS = this.RENDER_LAYER_GROUPS;
            result = result * 59 + ($RENDER_LAYER_GROUPS == null ? 43 : ((Object)$RENDER_LAYER_GROUPS).hashCode());
            String $POST_RENDER = this.POST_RENDER;
            result = result * 59 + ($POST_RENDER == null ? 43 : $POST_RENDER.hashCode());
            FrameSizes $FRAME_SIZES = this.FRAME_SIZES;
            result = result * 59 + ($FRAME_SIZES == null ? 43 : ((Object)$FRAME_SIZES).hashCode());
            return result;
        }
    }
}

