/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.logging.Level;
import net.shieldcommunity.nullcordx.ManagerComponent;
import net.shieldcommunity.nullcordx.NullCordXImpl;
import net.shieldcommunity.nullcordx.NullCordXLogger;
import net.shieldcommunity.nullcordx.api.database.CachedUserData;
import net.shieldcommunity.nullcordx.config.ConfigSettings;
import net.shieldcommunity.nullcordx.config.SQLSettings;
import net.shieldcommunity.nullcordx.database.Database;
import net.shieldcommunity.nullcordx.database.DatabaseMySQL;
import net.shieldcommunity.nullcordx.database.DatabasePostgreSQL;
import net.shieldcommunity.nullcordx.database.DatabaseSQLite;
import net.shieldcommunity.nullcordx.database.ProxyAddress;
import net.shieldcommunity.nullcordx.database.VerifiedUser;
import net.shieldcommunity.nullcordx.database.WhitelistedUser;
import net.shieldcommunity.nullcordx.libs.google.inject.Inject;
import net.shieldcommunity.nullcordx.libs.google.inject.Singleton;

@Singleton
public class DatabaseRepository
extends ManagerComponent {
    private Database database = null;
    private String tableUsers = "users";
    private String tableWhitelist = "whitelist";
    private String tableProxies = "proxies";

    @Inject
    public DatabaseRepository(NullCordXLogger logger, NullCordXImpl nullCordX) {
        super(logger, nullCordX, "DatabaseRepository");
    }

    @Override
    protected void onLoad(ForkJoinPool executor) {
        block22: {
            block21: {
                block20: {
                    if (!SQLSettings.IMP.SQL.ENABLED) {
                        this.logger.log(Level.INFO, this.componentName + " disabled by configuration!");
                        return;
                    }
                    try {
                        Class.forName("org.sqlite.JDBC");
                    }
                    catch (Exception e) {
                        if (!ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) break block20;
                        this.logger.log(Level.SEVERE, "Failed to find sqlite driver", e);
                    }
                }
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                }
                catch (Exception e) {
                    if (!ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) break block21;
                    this.logger.log(Level.SEVERE, "Failed to find mysql driver", e);
                }
            }
            try {
                Class.forName("net.shieldcommunity.nullcordx.libs.postgresql.Driver");
            }
            catch (Exception e) {
                if (!ConfigSettings.IMP.LOGS.PRINT_NULLCORDX_DEBUG) break block22;
                this.logger.log(Level.SEVERE, "Failed to fine postgresql driver", e);
            }
        }
        String storageType = SQLSettings.IMP.SQL.STORAGE_TYPE.toLowerCase(Locale.ROOT);
        SQLSettings.SQL.CONNECTION s2 = SQLSettings.IMP.SQL.CONNECTION;
        switch (storageType) {
            case "sqlite": {
                this.database = new DatabaseSQLite();
                break;
            }
            case "mysql": {
                this.database = new DatabaseMySQL(s2.HOSTNAME, s2.PORT, s2.DATABASE, s2.USER, s2.PASSWORD, s2.PARAMETERS, s2.POOL_SIZE, s2.CONNECTION_TIMEOUT);
                break;
            }
            case "postgresql": {
                this.database = new DatabasePostgreSQL(s2.HOSTNAME, s2.PORT, s2.DATABASE, s2.USER, s2.PASSWORD, s2.PARAMETERS, s2.POOL_SIZE, s2.CONNECTION_TIMEOUT);
            }
        }
        if (this.database == null) {
            this.database = new DatabaseSQLite();
            this.logger.log(Level.WARNING, "Failed to find database type '" + storageType + "'. Using sqlite.");
        }
        this.tableUsers = SQLSettings.IMP.SQL.USERS_TABLE_NAME;
        this.tableWhitelist = SQLSettings.IMP.SQL.WHITELIST_TABLE_NAME;
        this.tableProxies = SQLSettings.IMP.SQL.PROXIES_TABLE_NAME;
        try {
            long start = System.currentTimeMillis();
            this.logger.log(Level.INFO, "Connecting to " + this.database.getName() + " database...");
            this.database.start();
            this.createUsersTable();
            this.createWhitelistTable();
            this.createProxiesTable();
            long end = System.currentTimeMillis();
            this.logger.log(Level.INFO, this.database.getName() + " successfully connected and loaded in " + (end - start) + "ms");
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Can not connect to database " + this.database.getName() + " or execute sql: ", e);
        }
    }

    @Override
    protected void onUnload() {
        if (this.database != null) {
            try {
                this.database.stop();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error during database closing", e);
            }
        }
        this.database = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createUsersTable() throws SQLException {
        if (this.database == null) {
            return;
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.tableUsers + " (name VARCHAR(16) NOT NULL PRIMARY KEY UNIQUE,ip VARCHAR(16) NOT NULL,last_check BIGINT NOT NULL,last_join BIGINT NOT NULL);";
        Connection connection = this.database.getConnection();
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createWhitelistTable() throws SQLException {
        if (this.database == null) {
            return;
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.tableWhitelist + " (name VARCHAR(16) NOT NULL PRIMARY KEY UNIQUE,time_added BIGINT NOT NULL);";
        Connection connection = this.database.getConnection();
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProxiesTable() throws SQLException {
        if (this.database == null) {
            return;
        }
        String sql = "CREATE TABLE IF NOT EXISTS " + this.tableProxies + " (address VARCHAR(255) NOT NULL PRIMARY KEY UNIQUE,result VARCHAR(255) NOT NULL,time_added BIGINT NOT NULL);";
        Connection connection = this.database.getConnection();
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.executeUpdate();
        }
        finally {
            this.closeQuietly(connection);
        }
    }

    public Future<List<VerifiedUser>> getAllUsersByLastJoin(long until) {
        if (this.database == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.database.getExecutor().submit(() -> {
            Connection connection = this.database.getConnection();
            ArrayList<VerifiedUser> verifiedUsers = new ArrayList<VerifiedUser>();
            try (PreparedStatement statament = connection.prepareStatement("SELECT name, ip, last_check, last_join FROM " + this.tableUsers + " WHERE last_join > " + until + ";");
                 ResultSet set = statament.executeQuery();){
                while (set.next()) {
                    String name = set.getString("name");
                    String ip = set.getString("ip");
                    long lastCheck = set.getLong("last_check");
                    long lastJoin = set.getLong("last_join");
                    verifiedUsers.add(new VerifiedUser(name, ip, lastCheck, lastJoin));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
            return verifiedUsers;
        });
    }

    public Future<List<VerifiedUser>> getAllUsers() {
        if (this.database == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.database.getExecutor().submit(() -> {
            Connection connection = this.database.getConnection();
            ArrayList<VerifiedUser> verifiedUsers = new ArrayList<VerifiedUser>();
            try (PreparedStatement statament = connection.prepareStatement("SELECT name, ip, last_check, last_join FROM " + this.tableUsers + ";");
                 ResultSet set = statament.executeQuery();){
                while (set.next()) {
                    String name = set.getString("name");
                    String ip = set.getString("ip");
                    long lastCheck = set.getLong("last_check");
                    long lastJoin = set.getLong("last_join");
                    verifiedUsers.add(new VerifiedUser(name, ip, lastCheck, lastJoin));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
            return verifiedUsers;
        });
    }

    public Future<List<ProxyAddress>> getAllProxyAddress() {
        if (this.database == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.database.getExecutor().submit(() -> {
            Connection connection = this.database.getConnection();
            ArrayList<ProxyAddress> proxyAddresses = new ArrayList<ProxyAddress>();
            try (PreparedStatement statament = connection.prepareStatement("SELECT address, result, time_added FROM " + this.tableProxies + ";");
                 ResultSet set = statament.executeQuery();){
                while (set.next()) {
                    String ip = set.getString("address");
                    String result = set.getString("result");
                    long timeAdded = set.getLong("time_added");
                    proxyAddresses.add(new ProxyAddress(ip, result, timeAdded));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
            return proxyAddresses;
        });
    }

    public void clearOldUsers(long until) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.tableUsers + " WHERE last_join < " + until + ";");){
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void clearOldProxies(long until) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.tableProxies + " WHERE time_added < " + until + ";");){
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void saveUser(CachedUserData cachedUserData) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("ip", cachedUserData.getIp());
            values.put("last_check", String.valueOf(cachedUserData.getLastCheck()));
            values.put("last_join", String.valueOf(cachedUserData.getLastJoin()));
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + this.tableUsers + " (name, ip, last_check, last_join) VALUES (?, ?, ?, ?) " + this.database.upsertFromValues("name", values) + ";");){
                statement.setString(1, cachedUserData.getName());
                statement.setString(2, cachedUserData.getIp());
                statement.setLong(3, cachedUserData.getLastCheck());
                statement.setLong(4, cachedUserData.getLastJoin());
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void saveProxy(String address, String result, long timeAdded) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("result", result);
            values.put("time_added", String.valueOf(timeAdded));
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + this.tableProxies + " (address, result, time_added) VALUES (?, ?, ?) " + this.database.upsertFromValues("address", values) + ";");){
                statement.setString(1, address);
                statement.setString(2, result);
                statement.setLong(3, timeAdded);
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void deleteUser(String name) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            String sql = "DELETE FROM " + this.tableUsers + " WHERE name = ?;";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, name);
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void deleteProxy(String address) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            String sql = "DELETE FROM " + this.tableProxies + " WHERE address = ?;";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, address);
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void deleteAllUsers() {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            String sql = "DELETE FROM " + this.tableUsers + ";";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void deleteAllProxies() {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            String sql = "DELETE FROM " + this.tableProxies + ";";
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void saveWhitelist(String name, long timeAdded) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            values.put("time_added", String.valueOf(timeAdded));
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("INSERT INTO " + this.tableWhitelist + " (name, time_added) VALUES (?, ?) " + this.database.upsertFromValues("name", values) + ";");){
                statement.setString(1, name);
                statement.setLong(2, timeAdded);
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public void removeWhitelist(String name) {
        if (this.database == null) {
            return;
        }
        this.database.getExecutor().execute(() -> {
            Connection connection = this.database.getConnection();
            try (PreparedStatement statement = connection.prepareStatement("DELETE FROM " + this.tableWhitelist + " WHERE name = ?;");){
                statement.setString(1, name);
                statement.executeUpdate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
        });
    }

    public Future<List<WhitelistedUser>> getAllWhiteList() {
        if (this.database == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return this.database.getExecutor().submit(() -> {
            ArrayList<WhitelistedUser> whiteLists = new ArrayList<WhitelistedUser>();
            Connection connection = this.database.getConnection();
            try (PreparedStatement statament = connection.prepareStatement("SELECT name, time_added FROM " + this.tableWhitelist + ";");
                 ResultSet set = statament.executeQuery();){
                while (set.next()) {
                    String name = set.getString("name");
                    long timeAdded = set.getLong("time_added");
                    whiteLists.add(new WhitelistedUser(name, timeAdded));
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Error while executing database query", e);
            }
            finally {
                this.closeQuietly(connection);
            }
            return whiteLists;
        });
    }

    private void closeQuietly(Connection connection) {
        if (!this.database.needCloseConnection()) {
            return;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

