/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.core.JsonGenerator;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JavaType;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.JsonMappingException;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.SerializerProvider;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import net.shieldcommunity.nullcordx.libs.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            int pos = bbuf.position();
            gen.writeBinary(bbuf.array(), bbuf.arrayOffset() + pos, bbuf.limit() - pos);
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

