/*
 * Decompiled with CFR 0.152.
 */
package net.shieldcommunity.nullcordx.libs.google.inject.internal;

import java.util.Set;
import net.shieldcommunity.nullcordx.libs.google.inject.Binding;
import net.shieldcommunity.nullcordx.libs.google.inject.Key;
import net.shieldcommunity.nullcordx.libs.google.inject.Provider;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.AbstractBindingProcessor;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.BindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.BoundProviderFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ConstantFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ConstructorBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Errors;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ErrorsException;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ExposedBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ExposedKeyFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.FactoryProxy;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Initializable;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Initializer;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InstanceBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalFactory;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalFactoryToInitializableAdapter;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.InternalProviderInstanceBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.LinkedBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.LinkedProviderBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ProcessedBindingData;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ProviderInstanceBindingImpl;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.ProviderMethod;
import net.shieldcommunity.nullcordx.libs.google.inject.internal.Scoping;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ConstructorBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ConvertedConstantBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ExposedBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.InjectionPoint;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.InstanceBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.LinkedKeyBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.PrivateElements;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ProviderBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ProviderInstanceBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.ProviderKeyBinding;
import net.shieldcommunity.nullcordx.libs.google.inject.spi.UntargettedBinding;

final class BindingProcessor
extends AbstractBindingProcessor {
    private final Initializer initializer;

    BindingProcessor(Errors errors, Initializer initializer, ProcessedBindingData processedBindingData) {
        super(errors, processedBindingData);
        this.initializer = initializer;
    }

    @Override
    public <T> Boolean visit(Binding<T> command) {
        Class<T> rawType = command.getKey().getTypeLiteral().getRawType();
        if (Void.class.equals(rawType)) {
            if (command instanceof ProviderInstanceBinding && ((ProviderInstanceBinding)command).getUserSuppliedProvider() instanceof ProviderMethod) {
                this.errors.voidProviderMethod();
            } else {
                this.errors.missingConstantValues();
            }
            return true;
        }
        if (rawType == Provider.class) {
            this.errors.bindingToProvider();
            return true;
        }
        return (Boolean)command.acceptTargetVisitor(new AbstractBindingProcessor.Processor<T, Boolean>((BindingImpl)command){

            @Override
            public Boolean visit(ConstructorBinding<? extends T> binding) {
                this.prepareBinding();
                try {
                    ConstructorBindingImpl onInjector = ConstructorBindingImpl.create(BindingProcessor.this.injector, this.key, binding.getConstructor(), this.source, this.scoping, BindingProcessor.this.errors, false, false);
                    this.scheduleInitialization(onInjector);
                    BindingProcessor.this.putBinding(onInjector);
                }
                catch (ErrorsException e) {
                    BindingProcessor.this.errors.merge(e.getErrors());
                    BindingProcessor.this.putBinding(BindingProcessor.this.invalidBinding(BindingProcessor.this.injector, this.key, this.source));
                }
                return true;
            }

            @Override
            public Boolean visit(InstanceBinding<? extends T> binding) {
                this.prepareBinding();
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Object instance = binding.getInstance();
                InstanceBinding bindingT = binding;
                Initializable ref = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, instance, bindingT, this.source, injectionPoints, BindingProcessor.this.errors);
                ConstantFactory factory = new ConstantFactory(ref);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new InstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, injectionPoints, instance));
                return true;
            }

            @Override
            public Boolean visit(ProviderInstanceBinding<? extends T> binding) {
                this.prepareBinding();
                jakarta.inject.Provider provider = binding.getUserSuppliedProvider();
                if (provider instanceof InternalProviderInstanceBindingImpl.Factory) {
                    InternalProviderInstanceBindingImpl.Factory asProviderMethod = (InternalProviderInstanceBindingImpl.Factory)provider;
                    return this.visitInternalProviderInstanceBindingFactory(asProviderMethod);
                }
                Set<InjectionPoint> injectionPoints = binding.getInjectionPoints();
                Initializable initializable = BindingProcessor.this.initializer.requestInjection(BindingProcessor.this.injector, null, provider, null, this.source, injectionPoints, BindingProcessor.this.errors);
                InternalFactoryToInitializableAdapter factory = new InternalFactoryToInitializableAdapter(initializable, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new ProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, provider, injectionPoints));
                return true;
            }

            @Override
            public Boolean visit(ProviderKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key providerKey = binding.getProviderKey();
                BoundProviderFactory boundProviderFactory = new BoundProviderFactory(BindingProcessor.this.injector, providerKey, this.source, BindingProcessor.this.injector.provisionListenerStore.get(binding));
                BindingProcessor.this.processedBindingData.addCreationListener(boundProviderFactory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, boundProviderFactory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedProviderBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, providerKey));
                return true;
            }

            @Override
            public Boolean visit(LinkedKeyBinding<? extends T> binding) {
                this.prepareBinding();
                Key linkedKey = binding.getLinkedKey();
                if (this.key.equals(linkedKey)) {
                    BindingProcessor.this.errors.recursiveBinding(this.key, linkedKey);
                }
                FactoryProxy factory = new FactoryProxy(BindingProcessor.this.injector, this.key, linkedKey, this.source);
                BindingProcessor.this.processedBindingData.addCreationListener(factory);
                InternalFactory scopedFactory = Scoping.scope(this.key, BindingProcessor.this.injector, factory, this.source, this.scoping);
                BindingProcessor.this.putBinding(new LinkedBindingImpl(BindingProcessor.this.injector, this.key, this.source, scopedFactory, this.scoping, linkedKey));
                return true;
            }

            private Boolean visitInternalProviderInstanceBindingFactory(InternalProviderInstanceBindingImpl.Factory<T> provider) {
                InternalProviderInstanceBindingImpl binding = new InternalProviderInstanceBindingImpl(BindingProcessor.this.injector, this.key, this.source, provider, Scoping.scope(this.key, BindingProcessor.this.injector, provider, this.source, this.scoping), this.scoping);
                switch (binding.getInitializationTiming()) {
                    case DELAYED: {
                        this.scheduleDelayedInitialization(binding);
                        break;
                    }
                    case EAGER: {
                        this.scheduleInitialization(binding);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                BindingProcessor.this.putBinding(binding);
                return true;
            }

            @Override
            public Boolean visit(UntargettedBinding<? extends T> untargetted) {
                return false;
            }

            @Override
            public Boolean visit(ExposedBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ConvertedConstantBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            public Boolean visit(ProviderBinding<? extends T> binding) {
                throw new IllegalArgumentException("Cannot apply a non-module element");
            }

            @Override
            protected Boolean visitOther(Binding<? extends T> binding) {
                throw new IllegalStateException("BindingProcessor should override all visitations");
            }
        });
    }

    @Override
    public Boolean visit(PrivateElements privateElements) {
        for (Key<?> key : privateElements.getExposedKeys()) {
            this.bindExposed(privateElements, key);
        }
        return false;
    }

    private <T> void bindExposed(PrivateElements privateElements, Key<T> key) {
        ExposedKeyFactory<T> exposedKeyFactory = new ExposedKeyFactory<T>(key, privateElements);
        this.processedBindingData.addCreationListener(exposedKeyFactory);
        this.putBinding(new ExposedBindingImpl<T>(this.injector, privateElements.getExposedSource(key), key, exposedKeyFactory, privateElements));
    }
}

